/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.rr.bridge;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.bridge.IRegistryProvider;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.config.StaticConfigurationDao;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadata;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadataDao;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.PresentableDao;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.SearchableDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainerDao;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.execution.rr.bridge.BridgeHelper;
import org.gcube.execution.rr.bridge.FieldModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GCubeRepositoryProvider
implements IRegistryProvider {
    private static Logger logger = Logger.getLogger(GCubeRepositoryProvider.class.getName());
    public static String RRModelGenericResourceNameDef = "ResourceRegistryModel";
    public static String RRModelGenericResourceSecondaryTypeDef = "ResourceRegistryModel";
    public static String RRModelGenericResourceName = RRModelGenericResourceNameDef;
    public static String RRModelGenericResourceSecondaryType = RRModelGenericResourceSecondaryTypeDef;
    public Set<Class<?>> inMemoryTargets = new HashSet();

    public void readConfiguration(Properties config) {
        if (config == null) {
            return;
        }
        boolean defaultUsed = true;
        String value = null;
        value = config.getProperty("modelGenericResourceSecondaryType");
        if (value != null) {
            String secTypeValue = value;
            value = config.getProperty("modelGenericResourceName");
            if (value != null) {
                RRModelGenericResourceSecondaryType = secTypeValue;
                RRModelGenericResourceName = value;
                defaultUsed = false;
                logger.log(Level.INFO, "Using Model Generic Resource secondary type: " + RRModelGenericResourceSecondaryType);
                logger.log(Level.INFO, "Using Model Generic Resource name: " + RRModelGenericResourceName);
            }
        }
        if (defaultUsed) {
            logger.log(Level.INFO, "Using default Model Generic Resource secondary type: " + RRModelGenericResourceSecondaryType);
            logger.log(Level.INFO, "Using default Model Generic Resource name: " + RRModelGenericResourceName);
        }
        try {
            BridgeHelper.initializeIndexTypes(config);
        }
        catch (ResourceRegistryException e) {
            logger.log(Level.WARNING, "Could not initialize index types. Defaults will be used", e);
            BridgeHelper.initializeIndexTypes();
        }
    }

    public boolean isReadPolicySupported(RRContext.ReadPolicy policy) throws ResourceRegistryException {
        switch (policy) {
            case READ_LOCAL: {
                return false;
            }
            case READ_THROUGH: {
                return false;
            }
            case REFRESH_AHEAD: {
                return ResourceRegistry.getContext().isDatastoreSupported(RRContext.DatastoreType.LOCAL) && ResourceRegistry.getContext().isDatastoreSupported(RRContext.DatastoreType.LOCALBUFFER);
            }
        }
        return false;
    }

    public boolean isWritePolicySupported(RRContext.WritePolicy policy) throws ResourceRegistryException {
        switch (policy) {
            case WRITE_THROUGH: {
                return false;
            }
            case WRITE_LOCAL: {
                return false;
            }
            case WRITE_BEHIND: {
                return ResourceRegistry.getContext().isDatastoreSupported(RRContext.DatastoreType.LOCAL) && ResourceRegistry.getContext().isDatastoreSupported(RRContext.DatastoreType.LOCALBUFFER);
            }
        }
        return false;
    }

    public void setInMemoryTargets(Set<Class<?>> items) {
        this.inMemoryTargets = items;
    }

    public void persistDirect(Class<?> item, String id) throws ResourceRegistryException {
        throw new ResourceRegistryException("Operation not supported");
    }

    public void persistDirect(Class<?> items) throws ResourceRegistryException {
        throw new ResourceRegistryException("Operation not supported");
    }

    public void persist(Set<Class<?>> items, Set<String> nonUpdateVOScopes) throws ResourceRegistryException {
        logger.log(Level.INFO, "starting aligning");
        this.alignOutgoing(items);
        logger.log(Level.INFO, "starting persisting");
        this.bridgeOutgoing(items, nonUpdateVOScopes);
        logger.log(Level.INFO, "finished persisting");
    }

    public void retrieve(Set<Class<?>> items) throws ResourceRegistryException {
        logger.log(Level.INFO, "starting retrieving");
        this.bridgeIncoming(items);
        logger.log(Level.INFO, "starting aligning");
        this.alignIncoming(items);
        logger.log(Level.INFO, "finished retrieving");
    }

    public void retrieveDirect(Class<?> item, String id) throws ResourceRegistryException {
        throw new ResourceRegistryException("Operation not supported");
    }

    public void retrieveDirect(Class<?> item) throws ResourceRegistryException {
        throw new ResourceRegistryException("Operation not supported");
    }

    public void prefetchInMemoryItems() throws ResourceRegistryException {
        BridgeHelper.prefetchInMemoryItems(this.inMemoryTargets);
    }

    private void bridgeIncoming(Set<Class<?>> targets) throws ResourceRegistryException {
        try {
            BridgeHelper.retrieveScopes();
            FieldModel.retrieve();
            for (Class<?> include : targets) {
                logger.log(Level.INFO, "retrieving info from IS for element " + include.getName());
                Set<IDaoElement> items = BridgeHelper.getElement(include);
                logger.log(Level.INFO, "buffering information retrieved for element " + include.getName());
                DatastoreHelper.bufferItems(items);
            }
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("could not bridge incoming elements", (Throwable)ex);
        }
    }

    private void alignIncoming(Set<Class<?>> targets) throws ResourceRegistryException {
        boolean locked = false;
        Lock writeLock = ResourceRegistry.getContext().getExclusiveLock();
        try {
            boolean updateMode = !targets.contains(FieldDao.class) || !targets.contains(SearchableDao.class) || !targets.contains(PresentableDao.class);
            RRContext.DatastoreType datastoreType = ResourceRegistry.isInitialBridgingComplete() && updateMode ? RRContext.DatastoreType.LOCAL : RRContext.DatastoreType.LOCALBUFFER;
            logger.log(Level.INFO, "datastore type : " + datastoreType);
            List allFields = Field.getAll((boolean)true, (RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER);
            List allDataSources = DataSource.getAll((boolean)false, (RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER);
            Set allMetadata = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, ElementMetadataDao.class);
            writeLock.lock();
            locked = true;
            List updatedFieldsMetadata = ElementMetadata.getUpdatedFieldsMetadata((boolean)true);
            for (ElementMetadata m : updatedFieldsMetadata) {
                m.delete(true, RRContext.DatastoreType.LOCAL);
            }
            writeLock.unlock();
            locked = false;
            if (targets.contains(FieldIndexContainerDao.class)) {
                Set elems = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, FieldIndexContainerDao.class);
                HashSet<Class<FieldIndexContainerDao>> purge = new HashSet<Class<FieldIndexContainerDao>>();
                purge.add(FieldIndexContainerDao.class);
                DatastoreHelper.clear((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, purge);
                for (IDaoElement el : elems) {
                    if (!(el instanceof FieldIndexContainerDao)) continue;
                    Field f = null;
                    for (Field field : allFields) {
                        if (!field.getName().equals(((FieldIndexContainerDao)el).getField())) continue;
                        f = field;
                        break;
                    }
                    if (f == null) continue;
                    ((FieldIndexContainerDao)el).setField(f.getID());
                }
                DatastoreHelper.bufferItems((Set)elems);
            }
            for (Field f : allFields) {
                Searchable item;
                DataSource ds;
                for (Searchable s : f.getSearchables()) {
                    ds = null;
                    for (DataSource d : allDataSources) {
                        if (!d.getID().equals(s.getLocator())) continue;
                        ds = d;
                        break;
                    }
                    if (ds != null) {
                        logger.info("### Datasource " + ds.getID() + " scopes : " + ds.getScopes() + " capabilities : " + ds.getCapabilities());
                        logger.info("### Datasource : " + ds.deepToString());
                    }
                    if (ds != null) {
                        s.getDatasourceScopes().addAll(ds.getScopes());
                    }
                    item = new Searchable();
                    item.setID(s.getID());
                    item.setCollection(s.getCollection());
                    item.setField(s.getField());
                    item.setLocator(s.getLocator());
                    item.setExpression(s.getExpression());
                    item.setOrder(s.isOrder());
                    if (ds != null && ds.getCapabilities() != null) {
                        item.getCapabilities().addAll(ds.getCapabilities());
                    }
                    item.setDatasourceScopes(s.getDatasourceScopes());
                    if (ds != null) {
                        logger.info("## will save searchable " + item.getID() + " from field : " + f.getID() + " , " + f.getName() + " scopes : " + ds.getScopes());
                    }
                    item.store(true, datastoreType);
                }
                for (Presentable p : f.getPresentables()) {
                    ds = null;
                    for (DataSource d : allDataSources) {
                        if (!d.getID().equals(p.getLocator())) continue;
                        ds = d;
                        break;
                    }
                    if (ds != null) {
                        logger.info("### Datasource " + ds.getID() + " scopes : " + ds.getScopes() + " capabilities : " + ds.getCapabilities());
                        logger.info("### Datasource : " + ds.deepToString());
                    }
                    if (ds != null) {
                        p.getDatasourceScopes().addAll(ds.getScopes());
                    }
                    item = new Presentable();
                    item.setID(p.getID());
                    item.setCollection(p.getCollection());
                    item.setField(p.getField());
                    item.setLocator(p.getLocator());
                    item.setExpression(p.getExpression());
                    item.setOrder(p.isOrder());
                    item.setPresentationInfo(p.getPresentationInfo());
                    item.setDatasourceScopes(p.getDatasourceScopes());
                    item.store(true, datastoreType);
                }
            }
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("could not align incoming elements", (Throwable)ex);
        }
        finally {
            if (locked) {
                writeLock.unlock();
            }
        }
    }

    private void alignOutgoing(Set<Class<?>> targets) throws ResourceRegistryException {
    }

    private void bridgeOutgoing(Set<Class<?>> targets, Set<String> nonUpdateVOScopes) throws ResourceRegistryException {
        try {
            Node importedNode;
            Element newBody;
            String scopes;
            String serialization;
            Node importedNode2;
            Element newBody2;
            String scopes2;
            String serialization2;
            GenericResource resource;
            logger.log(Level.INFO, "retrieving field info from local");
            Set<IDaoElement> fields = new HashSet();
            Set<IDaoElement> searchables = new HashSet();
            Set<IDaoElement> presentables = new HashSet();
            Set<IDaoElement> metadata = new HashSet();
            IDaoElement staticConfig = null;
            boolean updateFields = false;
            boolean updateSearchables = false;
            boolean updatePresentables = false;
            boolean updateMetadata = false;
            boolean updateConfig = false;
            if (targets.contains(FieldDao.class)) {
                logger.log(Level.INFO, "retrieving info for " + FieldDao.class.getName());
                fields = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, FieldDao.class);
                logger.log(Level.INFO, "done retrieving info for " + fields.size() + " " + FieldDao.class.getName());
                updateFields = true;
            }
            if (targets.contains(SearchableDao.class)) {
                logger.log(Level.INFO, "retrieving info for " + SearchableDao.class.getName());
                searchables = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, SearchableDao.class);
                logger.log(Level.INFO, "done retrieving info for " + searchables.size() + " " + SearchableDao.class.getName());
                updateSearchables = true;
            }
            if (targets.contains(PresentableDao.class)) {
                logger.log(Level.INFO, "retrieving info for " + PresentableDao.class.getName());
                presentables = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, PresentableDao.class);
                logger.log(Level.INFO, "done retrieving info for " + presentables.size() + " " + PresentableDao.class.getName());
                updatePresentables = true;
            }
            if (targets.contains(ElementMetadataDao.class)) {
                logger.log(Level.INFO, "retrieving info for " + ElementMetadataDao.class.getName());
                metadata = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, ElementMetadataDao.class);
                logger.log(Level.INFO, "done retrieving info for " + metadata.size() + " " + ElementMetadataDao.class.getName());
                updateMetadata = true;
            }
            if (targets.contains(StaticConfigurationDao.class)) {
                logger.log(Level.INFO, "retrieving info for " + StaticConfigurationDao.class.getName());
                Set staticConfigs = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, StaticConfigurationDao.class);
                logger.log(Level.INFO, "done retrieving info for " + staticConfigs.size() + " " + StaticConfigurationDao.class.getName());
                if (staticConfigs.size() > 1) {
                    throw new ResourceRegistryException("Multiple static configuration elements were found");
                }
                if (!staticConfigs.isEmpty()) {
                    staticConfig = (IDaoElement)staticConfigs.iterator().next();
                }
                updateConfig = true;
            }
            Set datasourceIDs = DataSource.getAllIds();
            ArrayList<String> danglingPresentablesIDs = new ArrayList<String>();
            ArrayList<String> emptyScopePresentablesIDs = new ArrayList<String>();
            if (presentables != null) {
                for (IDaoElement pr : presentables) {
                    String datasourceID;
                    Set<String> voScopes = BridgeHelper.getVOScopes(((PresentableDao)pr).getDatasourceScopes());
                    logger.log(Level.INFO, "presentable datasource scopes : " + voScopes);
                    if (nonUpdateVOScopes.containsAll(voScopes)) {
                        logger.log(Level.INFO, "presentable : " + ((PresentableDao)pr).getID() + " has all its scopes in nonUpdateVOScopes");
                        emptyScopePresentablesIDs.add(((PresentableDao)pr).getID());
                    }
                    if (datasourceIDs.contains(datasourceID = ((PresentableDao)pr).getLocator())) continue;
                    danglingPresentablesIDs.add(((PresentableDao)pr).getID());
                }
            }
            logger.log(Level.INFO, "dangling presentables : " + danglingPresentablesIDs);
            logger.log(Level.INFO, "empty scope presentables : " + emptyScopePresentablesIDs);
            ArrayList<String> danglingSearchablesIDs = new ArrayList<String>();
            ArrayList<String> emptyScopeSearchablesIDs = new ArrayList<String>();
            if (searchables != null) {
                for (IDaoElement pr : searchables) {
                    String datasourceID;
                    Set<String> voScopes = BridgeHelper.getVOScopes(((SearchableDao)pr).getDatasourceScopes());
                    logger.log(Level.INFO, "searchable datasource scopes : " + voScopes);
                    if (nonUpdateVOScopes.containsAll(voScopes)) {
                        logger.log(Level.INFO, "searchable : " + ((SearchableDao)pr).getID() + " has all its scopes in nonUpdateVOScopes");
                        emptyScopeSearchablesIDs.add(((SearchableDao)pr).getID());
                    }
                    if (datasourceIDs.contains(datasourceID = ((SearchableDao)pr).getLocator())) continue;
                    danglingSearchablesIDs.add(((SearchableDao)pr).getID());
                }
            }
            logger.log(Level.INFO, "dangling searchables  : " + danglingSearchablesIDs);
            logger.log(Level.INFO, "empty scope searchables : " + emptyScopeSearchablesIDs);
            for (String danglingSearchableID : danglingSearchablesIDs) {
                Searchable s = new Searchable();
                s.setID(danglingSearchableID);
                s.load(true);
                s.delete(true);
            }
            for (String danglingPresentablesID : danglingPresentablesIDs) {
                Presentable p = new Presentable();
                p.setID(danglingPresentablesID);
                p.load(true);
                p.delete(true);
            }
            if (danglingPresentablesIDs.size() > 0) {
                updateMetadata = true;
                updateFields = true;
                updatePresentables = true;
                logger.log(Level.INFO, "will unmark deleted presentables");
                this.unmarkDeletedPresentables(danglingPresentablesIDs);
            }
            if (danglingSearchablesIDs.size() > 0) {
                updateMetadata = true;
                updateFields = true;
                updateSearchables = true;
                logger.log(Level.INFO, "will unmark deleted searchables");
                this.unmarkDeletedSearchables(danglingSearchablesIDs);
            }
            if (!(updateFields || updateSearchables || updatePresentables || updateMetadata || updateConfig)) {
                return;
            }
            logger.log(Level.INFO, "finished retrieving field info from local");
            ResourceRegistryException re = null;
            List<GenericResource> resources = null;
            if (updateFields) {
                logger.log(Level.INFO, "updating field directory gcube generic resource");
                try {
                    resources = BridgeHelper.getPublishedFieldResources();
                }
                catch (Exception ex) {
                    throw new ResourceRegistryException("could not retrieve remote field directory", (Throwable)ex);
                }
                logger.log(Level.INFO, "resources      : " + resources);
                if (resources != null) {
                    logger.log(Level.INFO, "resources size : " + resources.size());
                }
                if (resources.size() > 0) {
                    for (GenericResource resource2 : resources) {
                        logger.log(Level.INFO, "updating field directory resource with id : " + resource2.id());
                        logger.log(Level.INFO, "---------------------------------------------------");
                        logger.log(Level.INFO, "Updating resource");
                        logger.log(Level.INFO, resource2.id());
                        logger.log(Level.INFO, resource2.profile().name());
                        logger.log(Level.INFO, resource2.profile().description());
                        logger.log(Level.INFO, resource2.profile().body().getTextContent());
                        logger.log(Level.INFO, "---------------------------------------------------");
                        resource2.profile().description(Long.toString(new Date().getTime()));
                        logger.log(Level.INFO, "resource with id1 : " + resource2.id());
                        if (this.hasNonUpdaterVOScope(resource2, nonUpdateVOScopes)) {
                            resource2 = new GenericResource();
                            logger.log(Level.INFO, "resource has a nonVOScope in : " + resource2.scopes().asCollection() + ". Creating new resource with id : " + resource2.id());
                            resource2.newProfile();
                        }
                        logger.log(Level.INFO, "resource with id2 : " + resource2.id());
                        Set<IDaoElement> updatedFields = BridgeHelper.updateFieldList(fields, searchables, presentables, emptyScopeSearchablesIDs, emptyScopePresentablesIDs);
                        if (updatedFields.size() == 0) {
                            logger.log(Level.INFO, "Updating resource");
                            logger.log(Level.INFO, resource2.id());
                            logger.log(Level.INFO, resource2.profile().name());
                            logger.log(Level.INFO, "skipping creation fields cause they have empty searchables and presentables");
                            continue;
                        }
                        String serialization3 = BridgeHelper.buildFieldDirectorySerialization(updatedFields);
                        String scopes3 = "(";
                        for (String s : BridgeHelper.getFieldModelScopes()) {
                            scopes3 = scopes3 + s + " ";
                        }
                        scopes3 = scopes3 + ")";
                        logger.log(Level.FINE, "updating field directory resource serialization in scope " + scopes3 + " to :\n" + serialization3);
                        Element newBody3 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(serialization3.getBytes())).getDocumentElement();
                        resource2.profile().newBody();
                        Node importedNode3 = resource2.profile().body().getOwnerDocument().importNode(newBody3, true);
                        resource2.profile().body().appendChild(importedNode3);
                        try {
                            BridgeHelper.publishFieldResource(resource2, false, nonUpdateVOScopes);
                        }
                        catch (Exception ex) {
                            throw new ResourceRegistryException("could not publish remote field profile", (Throwable)ex);
                        }
                    }
                } else {
                    resource = new GenericResource();
                    logger.log(Level.INFO, "creating field directory resource. new id : " + resource.id());
                    resource.newProfile();
                    resource.profile().name(RRModelGenericResourceName);
                    resource.profile().type(RRModelGenericResourceSecondaryType);
                    resource.profile().description(Long.toString(new Date().getTime()));
                    Set<IDaoElement> updatedFields = BridgeHelper.updateFieldList(fields, searchables, presentables, emptyScopeSearchablesIDs, emptyScopePresentablesIDs);
                    if (updatedFields.size() == 0) {
                        logger.log(Level.INFO, "Adding resource");
                        logger.log(Level.INFO, resource.id());
                        logger.log(Level.INFO, resource.profile().name());
                        logger.log(Level.INFO, "skipping creation fields cause they have empty searchables and presentables");
                    } else {
                        serialization2 = BridgeHelper.buildFieldDirectorySerialization(updatedFields);
                        scopes2 = "(";
                        for (String s : BridgeHelper.getFieldModelScopes()) {
                            scopes2 = scopes2 + s + " ";
                        }
                        scopes2 = scopes2 + ")";
                        logger.log(Level.FINE, "adding field directory resource serialization in scope " + scopes2 + " to :\n" + serialization2);
                        newBody2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(serialization2.getBytes())).getDocumentElement();
                        resource.profile().newBody();
                        importedNode2 = resource.profile().body().getOwnerDocument().importNode(newBody2, true);
                        resource.profile().body().appendChild(importedNode2);
                        try {
                            logger.log(Level.INFO, "Adding NEW resource : " + resource);
                            BridgeHelper.publishFieldResource(resource, true, nonUpdateVOScopes);
                            logger.log(Level.INFO, "Adding NEW resource done ");
                        }
                        catch (Exception ex) {
                            throw new ResourceRegistryException("could not publish remote field profile", (Throwable)ex);
                        }
                    }
                }
                logger.log(Level.INFO, "finished updating field directory gcube generic resource");
                List deletedFieldsMetadata = ElementMetadata.getDeletedFieldsMetadata((boolean)true);
                HashSet deletedFieldIds = new HashSet();
                for (ElementMetadata m : deletedFieldsMetadata) {
                    try {
                        resources = null;
                        try {
                            resources = BridgeHelper.getPublishedFieldResourcesForField((String)m.getProperties().get("id"));
                        }
                        catch (Exception ex) {
                            throw new ResourceRegistryException("could not retrieve remote field profile", (Throwable)ex);
                        }
                        if (resources.size() > 0) {
                            for (GenericResource resource3 : resources) {
                                String scopes4 = "(";
                                for (String s : BridgeHelper.getFieldModelScopes()) {
                                    scopes4 = scopes4 + s + " ";
                                }
                                scopes4 = scopes4 + ")";
                                logger.log(Level.FINE, "deleting resource for field " + (String)m.getProperties().get("id") + " in scope " + scopes4);
                                try {
                                    BridgeHelper.deleteFieldResource(resource3, nonUpdateVOScopes);
                                    deletedFieldIds.add(m.getProperties().get("id"));
                                }
                                catch (Exception ex) {
                                    throw new ResourceRegistryException("could not delete remote field profile", (Throwable)ex);
                                }
                            }
                        }
                        m.delete(true, RRContext.DatastoreType.LOCAL);
                    }
                    catch (ResourceRegistryException e) {
                        logger.log(Level.WARNING, "Could not delete remote field profiles");
                        re = e;
                    }
                }
                List updatedFieldsMetadata = ElementMetadata.getUpdatedFieldsMetadata((boolean)true);
                HashSet updatedFieldIds = new HashSet();
                for (ElementMetadata m : updatedFieldsMetadata) {
                    updatedFieldIds.add(m.getProperties().get("id"));
                }
                logger.log(Level.INFO, "Updating fields");
                logger.log(Level.INFO, "updatedFieldIds " + updatedFieldIds);
                Set<String> deletedSearchables = this.getDeletedSearchables();
                deletedSearchables.addAll(danglingSearchablesIDs);
                deletedSearchables.addAll(emptyScopeSearchablesIDs);
                Set<String> deletedPresentables = this.getDeletedPresentables();
                deletedPresentables.addAll(danglingPresentablesIDs);
                deletedPresentables.addAll(emptyScopePresentablesIDs);
                for (IDaoElement f : fields) {
                    try {
                        FieldDao field = (FieldDao)f;
                        logger.log(Level.INFO, "1. updating gcube generic resource for field " + field.getName() + " (" + field.getID() + ")");
                        if (deletedFieldIds.contains(f.getID())) continue;
                        logger.log(Level.INFO, "2. updating gcube generic resource for field " + field.getName() + " (" + field.getID() + ")");
                        resources = null;
                        try {
                            resources = BridgeHelper.getPublishedFieldResourcesForField(field.getID());
                        }
                        catch (Exception ex) {
                            throw new ResourceRegistryException("could not retrieve remote field profile", (Throwable)ex);
                        }
                        logger.log(Level.INFO, "resources      : " + resources);
                        if (resources != null) {
                            logger.log(Level.INFO, "resources size : " + resources.size());
                        }
                        if (resources.size() > 0) {
                            for (GenericResource resource4 : resources) {
                                logger.log(Level.INFO, "updating field resource with id : " + resource4.id());
                                logger.log(Level.INFO, "resource with id1 : " + resource4.id());
                                Element bodyEl = resource4.profile().body();
                                if (this.hasNonUpdaterVOScope(resource4, nonUpdateVOScopes)) {
                                    resource4 = new GenericResource();
                                    logger.log(Level.INFO, "resource has a nonVOScope in : " + resource4.scopes().asCollection() + ". Creating new resource with id : " + resource4.id());
                                    resource4.newProfile();
                                }
                                logger.log(Level.INFO, "resource with id2 : " + resource4.id());
                                resource4.profile().description(Long.toString(new Date().getTime()));
                                TransformerFactory transFactory = TransformerFactory.newInstance();
                                Transformer transformer = transFactory.newTransformer();
                                StringWriter buffer = new StringWriter();
                                transformer.setOutputProperty("omit-xml-declaration", "yes");
                                transformer.transform(new DOMSource(bodyEl), new StreamResult(buffer));
                                String bodySerialization = buffer.toString();
                                logger.log(Level.FINEST, "serialization1 : " + bodyEl.getTextContent());
                                logger.log(Level.FINEST, "serialization2 : " + bodySerialization);
                                if (!BridgeHelper.shouldUpdateField((IDaoElement)field, searchables, presentables, emptyScopeSearchablesIDs, emptyScopePresentablesIDs)) {
                                    logger.log(Level.INFO, "1.####################################");
                                    logger.log(Level.INFO, "field ID   : " + field.getID());
                                    logger.log(Level.INFO, "field Name : " + field.getName());
                                    logger.log(Level.INFO, "field " + field.getID() + " - " + field.getName() + "has no presentables or searchable. skipping");
                                    continue;
                                }
                                String serialization4 = BridgeHelper.updateFieldSerialization(bodySerialization, (IDaoElement)field, searchables, presentables, updateFields, updateSearchables, updatePresentables, deletedSearchables, deletedPresentables);
                                logger.log(Level.INFO, "1.####################################");
                                logger.log(Level.INFO, "field ID   : " + field.getID());
                                logger.log(Level.INFO, "field Name : " + field.getName());
                                logger.log(Level.INFO, serialization4);
                                logger.log(Level.INFO, "field Searchables  : " + field.getSearchables());
                                logger.log(Level.INFO, "field Presentables : " + field.getPresentables());
                                logger.log(Level.INFO, "1.####################################");
                                String scopes5 = "(";
                                for (String s : BridgeHelper.getFieldModelScopes()) {
                                    scopes5 = scopes5 + s + " ";
                                }
                                scopes5 = scopes5 + ")";
                                logger.log(Level.FINE, "updating resource serialization for field " + field.getName() + " (" + field.getID() + ")" + " in scope " + scopes5 + " to :\n" + serialization4);
                                Element newBody4 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(serialization4.getBytes())).getDocumentElement();
                                resource4.profile().newBody();
                                Node importedNode4 = resource4.profile().body().getOwnerDocument().importNode(newBody4, true);
                                resource4.profile().body().appendChild(importedNode4);
                                try {
                                    BridgeHelper.publishFieldResource(resource4, false, nonUpdateVOScopes);
                                }
                                catch (Exception ex) {
                                    throw new ResourceRegistryException("could not publish remote field profile", (Throwable)ex);
                                }
                            }
                        } else {
                            GenericResource resource5 = new GenericResource();
                            logger.log(Level.INFO, "creating field resource. New  id : " + resource5.id());
                            resource5.newProfile();
                            resource5.profile().name(RRModelGenericResourceName + "." + field.getID());
                            resource5.profile().type(RRModelGenericResourceSecondaryType);
                            resource5.profile().description(Long.toString(new Date().getTime()));
                            if (!BridgeHelper.shouldUpdateField((IDaoElement)field, searchables, presentables, emptyScopeSearchablesIDs, emptyScopePresentablesIDs)) {
                                logger.log(Level.INFO, "2.####################################");
                                logger.log(Level.INFO, "field ID   : " + field.getID());
                                logger.log(Level.INFO, "field Name : " + field.getName());
                                logger.log(Level.INFO, "field " + field.getID() + " - " + field.getName() + "has no presentables or searchable. skipping");
                                continue;
                            }
                            String serialization5 = BridgeHelper.buildFieldSerialization((IDaoElement)field, searchables, presentables, deletedSearchables, deletedPresentables);
                            logger.log(Level.INFO, "2.####################################");
                            logger.log(Level.INFO, "field ID   : " + field.getID());
                            logger.log(Level.INFO, "field Name : " + field.getName());
                            logger.log(Level.INFO, serialization5);
                            logger.log(Level.INFO, "field Searchables  : " + field.getSearchables());
                            logger.log(Level.INFO, "field Presentables : " + field.getPresentables());
                            logger.log(Level.INFO, "2.####################################");
                            String scopes6 = "(";
                            for (String s : BridgeHelper.getFieldModelScopes()) {
                                scopes6 = scopes6 + s + " ";
                            }
                            scopes6 = scopes6 + ")";
                            logger.log(Level.FINE, "adding resource serialization for field " + field.getName() + " (" + field.getID() + ")" + " in scope " + scopes6 + " to :\n" + serialization5);
                            Element newBody5 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(serialization5.getBytes())).getDocumentElement();
                            resource5.profile().newBody();
                            Node importedNode5 = resource5.profile().body().getOwnerDocument().importNode(newBody5, true);
                            resource5.profile().body().appendChild(importedNode5);
                            try {
                                BridgeHelper.publishFieldResource(resource5, true, nonUpdateVOScopes);
                            }
                            catch (Exception ex) {
                                throw new ResourceRegistryException("could not publish remote field profile", (Throwable)ex);
                            }
                        }
                        logger.log(Level.INFO, "finished updating gcube generic resource");
                    }
                    catch (ResourceRegistryException e) {
                        re = e;
                        logger.log(Level.WARNING, "Error creating/updating gcube generic resource for field " + ((FieldDao)f).getName() + "(" + ((FieldDao)f).getID() + ")");
                    }
                }
            }
            if (updateMetadata) {
                logger.log(Level.INFO, "updating element metadata gcube generic resource");
                resources = null;
                try {
                    resources = BridgeHelper.getPublishedMetadataResources();
                }
                catch (Exception ex) {
                    throw new ResourceRegistryException("could not retrieve remote element metadata", (Throwable)ex);
                }
                if (resources.size() > 0) {
                    for (GenericResource resource2 : resources) {
                        logger.log(Level.INFO, "updating metadata resource. id : " + resource2.id());
                        logger.log(Level.INFO, "recource id1 : " + resource2.id());
                        if (this.hasNonUpdaterVOScope(resource2, nonUpdateVOScopes)) {
                            resource2 = new GenericResource();
                            logger.log(Level.INFO, "resource has a nonVOScope in : " + resource2.scopes().asCollection() + ". Creating new resource with id : " + resource2.id());
                            resource2.newProfile();
                        }
                        logger.log(Level.INFO, "recource id2 : " + resource2.id());
                        resource2.profile().description(Long.toString(new Date().getTime()));
                        serialization2 = BridgeHelper.buildElementMetadataSerialization(metadata);
                        scopes2 = "(";
                        for (String s : BridgeHelper.getFieldModelScopes()) {
                            scopes2 = scopes2 + s + " ";
                        }
                        scopes2 = scopes2 + ")";
                        logger.log(Level.FINE, "updating element metadata resource serialization in scope " + scopes2 + " to :\n" + serialization2);
                        newBody2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(serialization2.getBytes())).getDocumentElement();
                        resource2.profile().newBody();
                        importedNode2 = resource2.profile().body().getOwnerDocument().importNode(newBody2, true);
                        resource2.profile().body().appendChild(importedNode2);
                        try {
                            BridgeHelper.publishFieldResource(resource2, false, nonUpdateVOScopes);
                        }
                        catch (Exception ex) {
                            throw new ResourceRegistryException("could not publish remote element metadata", (Throwable)ex);
                        }
                    }
                } else {
                    resource = new GenericResource();
                    logger.log(Level.INFO, "creating metadata resource. new id : " + resource.id());
                    resource.newProfile();
                    resource.profile().name(RRModelGenericResourceName + ".Metadata");
                    resource.profile().type(RRModelGenericResourceSecondaryType);
                    resource.profile().description(Long.toString(new Date().getTime()));
                    serialization = BridgeHelper.buildElementMetadataSerialization(metadata);
                    scopes = "(";
                    for (String s : BridgeHelper.getFieldModelScopes()) {
                        scopes = scopes + s + " ";
                    }
                    scopes = scopes + ")";
                    logger.log(Level.FINE, "adding element metadata resource serialization in scope " + scopes + " to :\n" + serialization);
                    newBody = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(serialization.getBytes())).getDocumentElement();
                    resource.profile().newBody();
                    importedNode = resource.profile().body().getOwnerDocument().importNode(newBody, true);
                    resource.profile().body().appendChild(importedNode);
                    try {
                        BridgeHelper.publishFieldResource(resource, true, nonUpdateVOScopes);
                    }
                    catch (Exception ex) {
                        throw new ResourceRegistryException("could not publish remote field profiles", (Throwable)ex);
                    }
                }
                logger.log(Level.INFO, "finished updating element metadata gcube generic resource");
            }
            if (updateConfig) {
                logger.log(Level.INFO, "updating static configuration gcube generic resource");
                resources = null;
                try {
                    resources = BridgeHelper.getPublishedStaticConfigResources();
                }
                catch (Exception ex) {
                    throw new ResourceRegistryException("could not retrieve remote static configuration", (Throwable)ex);
                }
                if (resources.size() > 0) {
                    for (GenericResource resource2 : resources) {
                        logger.log(Level.INFO, "updating static config resource. id : " + resource2.id());
                        logger.log(Level.INFO, "resource id1 :" + resource2.id());
                        if (this.hasNonUpdaterVOScope(resource2, nonUpdateVOScopes)) {
                            resource2 = new GenericResource();
                            logger.log(Level.INFO, "resource has a nonVOScope in : " + resource2.scopes().asCollection() + ". Creating new resource with id : " + resource2.id());
                            resource2.newProfile();
                        }
                        logger.log(Level.INFO, "resource id2 :" + resource2.id());
                        resource2.profile().description(Long.toString(new Date().getTime()));
                        serialization2 = BridgeHelper.buildStaticConfigSerialization(staticConfig);
                        scopes2 = "(";
                        for (String s : BridgeHelper.getFieldModelScopes()) {
                            scopes2 = scopes2 + s + " ";
                        }
                        scopes2 = scopes2 + ")";
                        logger.log(Level.FINE, "updating static configuration resource serialization in scope " + scopes2 + " to :\n" + serialization2);
                        newBody2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(serialization2.getBytes())).getDocumentElement();
                        resource2.profile().newBody();
                        importedNode2 = resource2.profile().body().getOwnerDocument().importNode(newBody2, true);
                        resource2.profile().body().appendChild(importedNode2);
                        try {
                            BridgeHelper.publishFieldResource(resource2, false, nonUpdateVOScopes);
                        }
                        catch (Exception ex) {
                            throw new ResourceRegistryException("could not publish remote element metadata", (Throwable)ex);
                        }
                    }
                } else {
                    resource = new GenericResource();
                    logger.log(Level.INFO, "creating static config resource. new id : " + resource.id());
                    resource.newProfile();
                    resource.profile().name(RRModelGenericResourceName + ".StaticConfig");
                    resource.profile().type(RRModelGenericResourceSecondaryType);
                    resource.profile().description(Long.toString(new Date().getTime()));
                    serialization = BridgeHelper.buildStaticConfigSerialization(staticConfig);
                    scopes = "(";
                    for (String s : BridgeHelper.getFieldModelScopes()) {
                        scopes = scopes + s + " ";
                    }
                    scopes = scopes + ")";
                    logger.log(Level.FINE, "adding static configuration resource serialization in scope " + scopes + " to :\n" + serialization);
                    newBody = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(serialization.getBytes())).getDocumentElement();
                    resource.profile().newBody();
                    importedNode = resource.profile().body().getOwnerDocument().importNode(newBody, true);
                    resource.profile().body().appendChild(importedNode);
                    try {
                        BridgeHelper.publishFieldResource(resource, true, nonUpdateVOScopes);
                    }
                    catch (Exception ex) {
                        throw new ResourceRegistryException("could not publish remote static configuration", (Throwable)ex);
                    }
                }
                logger.log(Level.INFO, "finished updating static configuration gcube generic resource");
            }
            if (re != null) {
                throw re;
            }
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("could not bridge outgoing elements", (Throwable)ex);
        }
    }

    boolean hasNonUpdaterVOScope(GenericResource resource, Set<String> nonUpdaterVOScopes) {
        for (String scope : nonUpdaterVOScopes) {
            if (!resource.scopes().contains((Object)scope)) continue;
            return true;
        }
        return false;
    }

    void unmarkDeletedSearchables(List<String> searchables) {
        ArrayList<ElementMetadata> deletedMetadata = new ArrayList<ElementMetadata>();
        try {
            List deletedSearchables = ElementMetadata.getDeletedSearchablesMetadata((boolean)true);
            logger.log(Level.INFO, "deleted searchables elementes : " + deletedSearchables.size());
            for (ElementMetadata em : deletedSearchables) {
                if (em == null) continue;
                if (em.getProperties() == null) {
                    logger.log(Level.WARNING, "em : " + em.getID() + " has no properties");
                    continue;
                }
                if (em.getProperties().get("searchable_id") == null) {
                    logger.log(Level.WARNING, "em : " + em.getID() + " has no searchable_id in properties");
                    continue;
                }
                String[] valParts = ((String)em.getProperties().get("searchable_id")).split("#");
                if (valParts == null || valParts.length == 0) {
                    logger.log(Level.WARNING, "em : " + em.getID() + " searchable_id has no #");
                    continue;
                }
                String searchableID = valParts[valParts.length - 1];
                if (!searchables.contains(searchableID)) continue;
                deletedMetadata.add(em);
            }
            logger.log(Level.WARNING, "found : " + deletedMetadata.size() + " out of : " + searchables.size());
            for (ElementMetadata em : deletedMetadata) {
                try {
                    em.delete(true);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "error deleting element metadata : " + em.getID());
                }
            }
        }
        catch (ResourceRegistryException e) {
            logger.log(Level.WARNING, "error in unmarking deleted searchables", e);
        }
    }

    Set<String> getDeletedSearchables() {
        HashSet<String> deleted = new HashSet<String>();
        try {
            List deletedSearchables = ElementMetadata.getDeletedSearchablesMetadata((boolean)true);
            logger.log(Level.INFO, "deleted searchables elementes : " + deletedSearchables.size());
            for (ElementMetadata em : deletedSearchables) {
                if (em == null) continue;
                if (em.getProperties() == null) {
                    logger.log(Level.WARNING, "em : " + em.getID() + " has no properties");
                    continue;
                }
                if (em.getProperties().get("searchable_id") == null) {
                    logger.log(Level.WARNING, "em : " + em.getID() + " has no searchable_id in properties");
                    continue;
                }
                String[] valParts = ((String)em.getProperties().get("searchable_id")).split("#");
                if (valParts == null || valParts.length == 0) {
                    logger.log(Level.WARNING, "em : " + em.getID() + " searchable_id has no #");
                    continue;
                }
                deleted.add(valParts[valParts.length - 1]);
            }
        }
        catch (ResourceRegistryException e) {
            logger.log(Level.WARNING, "error in deleted searchables", e);
        }
        logger.log(Level.INFO, "deleted searchables : " + deleted);
        return deleted;
    }

    void unmarkDeletedPresentables(List<String> presentables) {
        ArrayList<ElementMetadata> deletedMetadata = new ArrayList<ElementMetadata>();
        try {
            List deletedPresentables = ElementMetadata.getDeletedPresentablesMetadata((boolean)true);
            logger.log(Level.INFO, "deleted presentables elements : " + deletedPresentables.size());
            for (ElementMetadata em : deletedPresentables) {
                if (em == null) continue;
                if (em.getProperties() == null) {
                    logger.log(Level.WARNING, "em : " + em.getID() + " has no properties");
                    continue;
                }
                if (em.getProperties().get("presentable_id") == null) {
                    logger.log(Level.WARNING, "em : " + em.getID() + " has no presentable_id in properties");
                    continue;
                }
                String[] valParts = ((String)em.getProperties().get("presentable_id")).split("#");
                if (valParts == null || valParts.length == 0) {
                    logger.log(Level.WARNING, "em : " + em.getID() + " presentable_id has no #");
                    continue;
                }
                String presentableID = valParts[valParts.length - 1];
                if (!presentables.contains(presentableID)) continue;
                deletedMetadata.add(em);
            }
            logger.log(Level.WARNING, "found : " + deletedMetadata.size() + " out of : " + presentables.size());
            for (ElementMetadata em : deletedMetadata) {
                try {
                    em.delete(true);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "error deleting element metadata : " + em.getID());
                }
            }
        }
        catch (ResourceRegistryException e) {
            logger.log(Level.WARNING, "error in unmarking deleted presentables", e);
        }
    }

    Set<String> getDeletedPresentables() {
        HashSet<String> deleted = new HashSet<String>();
        try {
            List deletedPresentables = ElementMetadata.getDeletedPresentablesMetadata((boolean)true);
            logger.log(Level.INFO, "deleted presentables elements : " + deletedPresentables.size());
            for (ElementMetadata em : deletedPresentables) {
                if (em == null) continue;
                if (em.getProperties() == null) {
                    logger.log(Level.WARNING, "em : " + em.getID() + " has no properties");
                    continue;
                }
                if (em.getProperties().get("presentable_id") == null) {
                    logger.log(Level.WARNING, "em : " + em.getID() + " has no presentable_id in properties");
                    continue;
                }
                String[] valParts = ((String)em.getProperties().get("presentable_id")).split("#");
                if (valParts == null || valParts.length == 0) {
                    logger.log(Level.WARNING, "em : " + em.getID() + " presentable_id has no #");
                    continue;
                }
                deleted.add(valParts[valParts.length - 1]);
            }
        }
        catch (ResourceRegistryException e) {
            logger.log(Level.WARNING, "error in deleted presentables", e);
        }
        logger.log(Level.INFO, "deleted presentables : " + deleted);
        return deleted;
    }

    static {
        BridgeHelper.initializeIndexTypes();
    }
}

