package org.gcube.execution.rr.bridge;

import java.io.StringReader;
import java.util.Calendar;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.gcube.common.core.resources.GCUBEGenericResource;

@XmlRootElement(name="CollectionInfo")
public class CollectionDescription {

	private String id;
	private String name;
	private String description;
	private Calendar creationTime;
	private boolean isUser;
	
	public String getId() {
		return id;
	}
	
	@XmlTransient 
	public void setId(String id) {
		this.id = id;
	}
	
	public String getName() {
		return name;
	}
	
	@XmlTransient 
	public void setName(String name) {
		this.name = name;
	}
	
	public String getDescription() {
		return description;
	}
	
	@XmlTransient 
	public void setDescription(String descritpion) {
		this.description = descritpion;
	}
	
	public Calendar getCreationTime() {
		return creationTime;
	}
	
	@XmlElement 
	public void setCreationTime(Calendar creationTime) {
		this.creationTime = creationTime;
	}
	
	public boolean isUser() {
		return isUser;
	}

	@XmlElement 
	public void setUser(boolean isUser) {
		this.isUser = isUser;
	}
	
	private static JAXBContext jaxbContext = null;

	private static synchronized JAXBContext getJAXBContext() throws Exception{
		if (jaxbContext==null) jaxbContext = JAXBContext.newInstance(CollectionDescription.class);
		return jaxbContext;
	}

	protected static CollectionDescription getCollection(GCUBEGenericResource resource) throws JAXBException, Exception
	{
		CollectionDescription collectionDescription = (CollectionDescription) getJAXBContext().createUnmarshaller().unmarshal(new StringReader(resource.getBody()));
		
		return collectionDescription;
	}
		
}


