/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.rr.bridge;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.access.InMemoryStore;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.IRRElement;
import gr.uoa.di.madgik.rr.element.config.StaticConfigurationDao;
import gr.uoa.di.madgik.rr.element.data.DataCollection;
import gr.uoa.di.madgik.rr.element.data.DataCollectionDao;
import gr.uoa.di.madgik.rr.element.data.DataLanguage;
import gr.uoa.di.madgik.rr.element.execution.ExecutionServerDao;
import gr.uoa.di.madgik.rr.element.execution.ExecutionServiceDao;
import gr.uoa.di.madgik.rr.element.execution.SearchServiceDao;
import gr.uoa.di.madgik.rr.element.execution.WorkflowServiceDao;
import gr.uoa.di.madgik.rr.element.functionality.Functionality;
import gr.uoa.di.madgik.rr.element.functionality.FunctionalityDao;
import gr.uoa.di.madgik.rr.element.infra.HostingNode;
import gr.uoa.di.madgik.rr.element.infra.HostingNodeDao;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadata;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadataDao;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.PresentableDao;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.SearchableDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.FTIndex;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexDao;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexService;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.FWIndex;
import gr.uoa.di.madgik.rr.element.search.index.FWIndexDao;
import gr.uoa.di.madgik.rr.element.search.index.FWIndexService;
import gr.uoa.di.madgik.rr.element.search.index.FWIndexServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainer;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainerDao;
import gr.uoa.di.madgik.rr.element.search.index.GeoIndex;
import gr.uoa.di.madgik.rr.element.search.index.GeoIndexDao;
import gr.uoa.di.madgik.rr.element.search.index.GeoIndexService;
import gr.uoa.di.madgik.rr.element.search.index.GeoIndexServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSource;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceDao;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceServiceDao;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGHNQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.node.Description;
import org.gcube.common.core.resources.runninginstance.Endpoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.Collection;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.Collections;
import org.gcube.execution.rr.bridge.FieldModel;
import org.gcube.execution.rr.bridge.GCubeRepositoryProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BridgeHelper {
    private static Logger logger = Logger.getLogger(BridgeHelper.class.getName());
    private static GCUBEScope[] scopes = null;
    private static GCUBEScope[] searchSystemScopes = null;
    private static Set<IDaoElement> searchSystemServices = null;
    private static final String JNDI_NAME = "gcube/data/tm";
    private static final String TREADER_NAME = "gcube/data/tm/reader";
    private static final String SOURCENAME_RPNAME = "Name";
    private static final String SOURCEID_RPNAME = "SourceId";
    private static final String CARDINALITY_RPNAME = "Cardinality";

    public static void initializeIndexTypes() {
        DataSource.clearSubTypes();
        DataSource.addSubType((DataSource.Type)DataSource.Type.FullTextIndex, FTIndex.class, FTIndexDao.class);
        DataSource.addSubType((DataSource.Type)DataSource.Type.ForwardIndex, FWIndex.class, FWIndexDao.class);
        DataSource.addSubType((DataSource.Type)DataSource.Type.GeoIndex, GeoIndex.class, GeoIndexDao.class);
        DataSource.addSubType((DataSource.Type)DataSource.Type.OpenSearch, OpenSearchDataSource.class, OpenSearchDataSourceDao.class);
        DataSourceService.clearSubTypes();
        DataSourceService.addSubType((DataSourceService.Type)DataSourceService.Type.FullTextIndex, FTIndexService.class, FTIndexServiceDao.class);
        DataSourceService.addSubType((DataSourceService.Type)DataSourceService.Type.ForwardIndex, FWIndexService.class, FWIndexServiceDao.class);
        DataSourceService.addSubType((DataSourceService.Type)DataSourceService.Type.GeoIndex, GeoIndexService.class, GeoIndexServiceDao.class);
        DataSourceService.addSubType((DataSourceService.Type)DataSourceService.Type.OpenSearch, OpenSearchDataSourceService.class, OpenSearchDataSourceServiceDao.class);
    }

    public static void initializeIndexTypes(Properties config) throws ResourceRegistryException {
        try {
            String value;
            String key;
            String type;
            int i;
            HashSet res;
            int count = Integer.parseInt(config.getProperty("dataSourceSubTypesCount", "0"));
            if (count != 0) {
                DataSource.clearSubTypes();
                res = new HashSet(count);
                for (i = 0; i < count; ++i) {
                    type = config.getProperty("dataSourceSubTypesType." + i);
                    if (type == null) {
                        throw new ResourceRegistryException("Could not read datasource type #" + i);
                    }
                    key = config.getProperty("dataSourceSubTypesKey." + i);
                    if (key == null) {
                        throw new ResourceRegistryException("Could not read datasource class name #" + i);
                    }
                    value = config.getProperty("dataSourceSubTypesValue." + i);
                    if (value == null) {
                        throw new ResourceRegistryException("Could not read datasource dao class name #" + i);
                    }
                    DataSource.addSubType((DataSource.Type)DataSource.Type.valueOf((String)type), Class.forName(key), Class.forName(value));
                    logger.log(Level.INFO, "Adding DataSource type: " + type + "-" + key + "-" + value);
                }
            }
            if ((count = Integer.parseInt(config.getProperty("dataSourceServiceSubTypesCount", "0"))) != 0) {
                DataSourceService.clearSubTypes();
                res = new HashSet(count);
                for (i = 0; i < count; ++i) {
                    type = config.getProperty("dataSourceServiceSubTypesType." + i);
                    if (type == null) {
                        throw new ResourceRegistryException("Could not read datasource service type #" + i);
                    }
                    key = config.getProperty("dataSourceServiceSubTypesKey." + i);
                    if (key == null) {
                        throw new ResourceRegistryException("Could not read datasource service class name #" + i);
                    }
                    value = config.getProperty("dataSourceServiceSubTypesValue." + i);
                    if (value == null) {
                        throw new ResourceRegistryException("Could not read datasource service dao class name #" + i);
                    }
                    DataSourceService.addSubType((DataSourceService.Type)DataSourceService.Type.valueOf((String)type), Class.forName(key), Class.forName(value));
                    logger.log(Level.INFO, "Adding DataSource service type: " + type + "-" + key + "-" + value);
                }
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error while initializing datasource types", (Throwable)e);
        }
    }

    public static void retrieveScopes() throws Exception {
        if (GHNContext.getContext().isClientMode()) {
            BridgeHelper.retrieveScopesOffline();
        } else {
            BridgeHelper.retrieveScopesOnline();
        }
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder logScopes = new StringBuilder();
            for (GCUBEScope scope : scopes) {
                logScopes.append(scope.toString());
                logScopes.append(" ");
            }
            logger.log(Level.INFO, "Scopes: " + logScopes.toString());
        }
        searchSystemServices = BridgeHelper.retrieveSearchService();
        HashSet searchSystemScopeSet = new HashSet();
        for (IDaoElement searchSystemService : searchSystemServices) {
            searchSystemScopeSet.addAll(((SearchServiceDao)searchSystemService).scopes);
        }
        searchSystemScopes = new GCUBEScope[searchSystemScopeSet.size()];
        int i = 0;
        for (String s : searchSystemScopeSet) {
            BridgeHelper.searchSystemScopes[i++] = GCUBEScope.getScope((String)s);
        }
    }

    public static GCUBEScope[] getFieldModelScopes() throws Exception {
        HashSet<String> fieldScopes = new HashSet<String>();
        for (GCUBEScope scope : searchSystemScopes) {
            if (scope.getType().equals((Object)GCUBEScope.Type.VO)) {
                fieldScopes.add(scope.toString());
                continue;
            }
            if (!scope.getType().equals((Object)GCUBEScope.Type.VRE)) continue;
            fieldScopes.add(scope.getEnclosingScope().toString());
        }
        ArrayList<GCUBEScope> gCubeScopes = new ArrayList<GCUBEScope>();
        for (String scope : fieldScopes) {
            gCubeScopes.add(GCUBEScope.getScope((String)scope));
        }
        return gCubeScopes.toArray(new GCUBEScope[0]);
    }

    private static void retrieveScopesOnline() {
        java.util.Collection tmpScopes = GHNContext.getContext().getGHN().getScopes().values();
        ArrayList<GCUBEScope> toKeepScopes = new ArrayList<GCUBEScope>();
        for (GCUBEScope scope : tmpScopes) {
            if (scope.isInfrastructure()) continue;
            toKeepScopes.add(scope);
        }
        scopes = toKeepScopes.toArray(new GCUBEScope[0]);
    }

    private static void retrieveScopesOffline() throws Exception {
        ArrayList<GCUBEScope> scopes = new ArrayList<GCUBEScope>();
        scopes.addAll(Arrays.asList(GHNContext.getContext().getStartScopes()));
        List<GCUBEGenericResource> resources = BridgeHelper.getPublishedVREResources();
        for (GCUBEGenericResource resource : resources) {
            String retrievedScope = BridgeHelper.getVREScope(resource);
            if (retrievedScope == null) continue;
            scopes.add(GCUBEScope.getScope((String)retrievedScope));
        }
        BridgeHelper.scopes = scopes.toArray(new GCUBEScope[0]);
    }

    private static List<GCUBEGenericResource> getPublishedVREResources() throws Exception {
        ISClient client = null;
        GCUBEGenericResourceQuery query = null;
        client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEScope[] scopes = GHNContext.getContext().getStartScopes();
        ArrayList<GCUBEGenericResource> resources = new ArrayList<GCUBEGenericResource>();
        for (GCUBEScope scope : scopes) {
            if (scope.getType() != GCUBEScope.Type.VO) continue;
            query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/SecondaryType", "VRE")});
            resources.addAll(client.execute((ISQuery)query, scope));
        }
        return resources;
    }

    private static String getVREScope(GCUBEGenericResource resource) throws Exception {
        Document doc = null;
        if (resource == null || resource.getBody() == null || resource.getBody().trim().length() == 0) {
            return null;
        }
        doc = XMLUtils.Deserialize((String)("<root>" + resource.getBody() + "</root>"));
        return XMLUtils.GetChildElementWithName((Node)doc.getDocumentElement(), (String)"Scope").getFirstChild().getNodeValue();
    }

    public static Set<IDaoElement> getElement(Class<?> type) throws Exception {
        if (type.equals(FieldDao.class)) {
            return BridgeHelper.getFields();
        }
        if (type.equals(PresentableDao.class)) {
            return BridgeHelper.getPresentables();
        }
        if (type.equals(SearchableDao.class)) {
            return BridgeHelper.getSearchables();
        }
        if (type.equals(DataCollectionDao.class)) {
            return BridgeHelper.getAllCollections();
        }
        if (type.equals(HostingNodeDao.class)) {
            return BridgeHelper.getHostingNodes();
        }
        if (type.equals(FunctionalityDao.class)) {
            return BridgeHelper.getFunctionality();
        }
        if (type.equals(ExecutionServerDao.class)) {
            return BridgeHelper.getExecutionServer();
        }
        if (type.equals(ExecutionServiceDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(WorkflowServiceDao.class)) {
            return BridgeHelper.getWorkflowService();
        }
        if (type.equals(FieldIndexContainerDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(FTIndexDao.class)) {
            return BridgeHelper.getFTIndex();
        }
        if (type.equals(FWIndexDao.class)) {
            return BridgeHelper.getFWIndex();
        }
        if (type.equals(GeoIndexDao.class)) {
            return BridgeHelper.getGeoIndex();
        }
        if (type.equals(OpenSearchDataSourceDao.class)) {
            return BridgeHelper.getOpenSearchDataSource();
        }
        if (type.equals(FTIndexServiceDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(FWIndexServiceDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(GeoIndexServiceDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(OpenSearchDataSourceServiceDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(ElementMetadataDao.class)) {
            return BridgeHelper.getElementMetadata();
        }
        if (type.equals(StaticConfigurationDao.class)) {
            return BridgeHelper.getStaticConfiguration();
        }
        throw new ResourceRegistryException("unrecognized element type " + type);
    }

    private static Set<IDaoElement> getDataSource(String className, String serviceClassName, String serviceClass, String serviceName, String functionality, DataSource.Type type, String description) throws Exception {
        GCUBEScope[] scopes = BridgeHelper.scopes;
        logger.log(Level.WARNING, "### getting datasources from scopes : " + scopes);
        HashMap<String, GCUBEScope> datasourceItems = new HashMap<String, GCUBEScope>();
        HashMap<String, DataSourceServiceDao> datasourceServiceItems = new HashMap<String, DataSourceServiceDao>();
        HashSet<FieldIndexContainerDao> fieldItems = new HashSet<FieldIndexContainerDao>();
        for (GCUBEScope scope : scopes) {
            logger.log(Level.INFO, "Searching for " + description + " indexes in scope " + scope.toString());
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            WSResourceQuery query = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            query.addGenericCondition("$result//Data/child::*[local-name()='ServiceName']/string() eq '" + serviceName + "'");
            query.addGenericCondition("$result//Data/child::*[local-name()='ServiceClass']/string() eq '" + serviceClass + "'");
            List inds = client.execute((ISQuery)query, scope);
            logger.log(Level.INFO, "Found " + inds.size() + " indexes in scope");
            for (RPDocument d : inds) {
                GCUBEScope s2;
                if (d.getKey() == null || d.getKey().getValue() == null) continue;
                String key = d.getKey().getValue();
                if (datasourceItems.containsKey(key)) {
                    for (GCUBEScope s2 : d.getScope()) {
                        ((DataSourceDao)datasourceItems.get(d.getKey().getValue())).getScopes().add(s2.toString());
                        ((DataSourceServiceDao)datasourceServiceItems.get(d.getKey().getValue())).getScopes().add(s2.toString());
                    }
                    ((DataSourceDao)datasourceItems.get(d.getKey().getValue())).getScopes().add(scope.toString());
                    ((DataSourceServiceDao)datasourceServiceItems.get(d.getKey().getValue())).getScopes().add(scope.toString());
                    continue;
                }
                DataSourceServiceDao ss = (DataSourceServiceDao)Class.forName(serviceClassName).newInstance();
                ss.setID(key);
                ss.setType(type.toString());
                ss.getDataSources().add(key);
                ss.setEndpoint(d.getEndpoint().getAddress().toString());
                ss.setFunctionality(functionality);
                ss.setHostingNode(d.getGHNID());
                for (GCUBEScope sc : d.getScope()) {
                    ss.getScopes().add(sc.toString());
                }
                ss.getScopes().add(scope.toString());
                ss.setTimestamp(Calendar.getInstance().getTimeInMillis());
                datasourceServiceItems.put(ss.getID(), ss);
                s2 = (DataSourceDao)Class.forName(className).newInstance();
                s2.setID(key);
                s2.setType(type.toString());
                s2.setFunctionality(functionality);
                if (s2.getBoundDataSourceServices() == null) {
                    s2.setBoundDataSourceServices(new HashSet());
                }
                s2.getBoundDataSourceServices().add(key);
                s2.setTimestamp(Calendar.getInstance().getTimeInMillis());
                s2.getCapabilities().clear();
                s2.getCapabilities().addAll(d.evaluate("//SupportedRelations/text()"));
                for (GCUBEScope sc : d.getScope()) {
                    s2.getScopes().add(sc.toString());
                }
                s2.getScopes().add(scope.toString());
                List ff = d.evaluate("//Fields/text()");
                HashSet<String> checkDups = new HashSet<String>();
                for (String f : ff) {
                    String[] fparts = f.split(":");
                    if (fparts.length == 6 && fparts[2].equals("s")) {
                        fparts[4] = fparts[4] + ":" + fparts[5];
                    }
                    if (fparts.length < 4 || fparts.length > 6 || fparts.length == 6 && !fparts[2].equals("s")) continue;
                    FieldIndexContainerDao fc = new FieldIndexContainerDao();
                    fc.setID(s2.getID() + ":" + f);
                    if (checkDups.contains(fc.getID())) {
                        logger.log(Level.WARNING, "Duplicate field detected: " + fc.getID());
                        continue;
                    }
                    checkDups.add(fc.getID());
                    fc.setCollection(fparts[0]);
                    fc.setLanguage(fparts[1]);
                    fc.setFieldType(fparts[2]);
                    fc.setField(fparts[3]);
                    if (fparts.length >= 5) {
                        fc.setExpression(fparts[4]);
                    }
                    s2.getFields().add(fc.getID());
                    fieldItems.add(fc);
                }
                datasourceItems.put(s2.getID(), s2);
            }
        }
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(datasourceItems.values());
        retValue.addAll(datasourceServiceItems.values());
        retValue.addAll(fieldItems);
        return retValue;
    }

    private static Set<IDaoElement> getFTIndex() throws Exception {
        return BridgeHelper.getDataSource(FTIndexDao.class.getName(), FTIndexServiceDao.class.getName(), "Index", "FullTextIndexNode", "search.index.ft", DataSource.Type.FullTextIndex, "full text");
    }

    private static Set<IDaoElement> getFakeFTIndex() throws Exception {
        FieldIndexContainerDao fc;
        String[] fparts;
        HashMap<String, FTIndexDao> datasourceItems = new HashMap<String, FTIndexDao>();
        HashMap<String, FTIndexServiceDao> serviceItems = new HashMap<String, FTIndexServiceDao>();
        HashSet<FieldIndexContainerDao> fieldItems = new HashSet<FieldIndexContainerDao>();
        FTIndexServiceDao ss = new FTIndexServiceDao();
        ss.setID("1283-5c96-f869-172b");
        ss.setFunctionality("search.index.ft");
        ss.setHostingNode("FTIndexGHNOne");
        ss.setEndpoint("http://nowhere1.com/wsrf/index/fulltext");
        ss.getScopes().add("/no/scope/");
        ss.setTimestamp(Calendar.getInstance().getTimeInMillis());
        ss.setType(DataSource.Type.FullTextIndex.toString());
        serviceItems.put(ss.getID(), ss);
        FTIndexDao s = new FTIndexDao();
        s.setID("1283-5c96-f869-172b");
        s.setType(DataSource.Type.FullTextIndex.toString());
        s.setFunctionality("search.index.ft");
        s.getCapabilities().clear();
        s.getCapabilities().add("any");
        s.getFields().clear();
        s.getScopes().add("/no/scope/");
        ArrayList<String> ff = new ArrayList<String>();
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:title");
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:title");
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:source");
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:source");
        for (String f : ff) {
            fparts = f.split(":");
            if (fparts.length != 4) continue;
            fc = new FieldIndexContainerDao();
            fc.setID(s.getID() + ":" + f);
            fc.setCollection(fparts[0]);
            fc.setLanguage(fparts[1]);
            fc.setFieldType(fparts[2]);
            fc.setField(fparts[3]);
            s.getFields().add(fc.getID());
            fieldItems.add(fc);
        }
        datasourceItems.put(s.getID(), s);
        ss = new FTIndexServiceDao();
        ss.setID("768a-8ab8-1281-9812");
        ss.setType(DataSource.Type.FullTextIndex.toString());
        ss.setHostingNode("FTIndexGHNTwo");
        ss.setEndpoint("http://nowhere2.com/wsrf/index/fulltext");
        serviceItems.put(ss.getID(), ss);
        s = new FTIndexDao();
        s.setID("768a-8ab8-1281-9812");
        s.setType(DataSource.Type.FullTextIndex.toString());
        s.setFunctionality("search.index.ft");
        s.getCapabilities().clear();
        s.getCapabilities().add("any");
        s.getFields().clear();
        s.getScopes().add("/no/scope/");
        ff = new ArrayList();
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:type");
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:type");
        for (String f : ff) {
            fparts = f.split(":");
            if (fparts.length != 4) continue;
            fc = new FieldIndexContainerDao();
            fc.setID(s.getID() + ":" + f);
            fc.setCollection(fparts[0]);
            fc.setLanguage(fparts[1]);
            fc.setFieldType(fparts[2]);
            fc.setField(fparts[3]);
            s.getFields().add(fc.getID());
            fieldItems.add(fc);
        }
        datasourceItems.put(s.getID(), s);
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(datasourceItems.values());
        retValue.addAll(serviceItems.values());
        retValue.addAll(fieldItems);
        return retValue;
    }

    private static Set<IDaoElement> getFWIndex() throws Exception {
        return BridgeHelper.getDataSource(FWIndexDao.class.getName(), FWIndexServiceDao.class.getName(), "Index", "ForwardIndexLookup", "search.index.fw", DataSource.Type.ForwardIndex, "forward");
    }

    private static Set<IDaoElement> getGeoIndex() throws Exception {
        return BridgeHelper.getDataSource(GeoIndexDao.class.getName(), GeoIndexServiceDao.class.getName(), "Index", "GeoIndexLookup", "search.index.geo", DataSource.Type.GeoIndex, "geo");
    }

    private static Set<IDaoElement> getOpenSearchDataSource() throws Exception {
        return BridgeHelper.getDataSource(OpenSearchDataSourceDao.class.getName(), OpenSearchDataSourceServiceDao.class.getName(), "OpenSearch", "OpenSearchDataSource", "search.index.opensearch", DataSource.Type.OpenSearch, "opensearch");
    }

    private static Set<IDaoElement> getFakeFWIndex() throws Exception {
        HashMap<String, FWIndexDao> datasourceItems = new HashMap<String, FWIndexDao>();
        HashMap<String, FWIndexServiceDao> serviceItems = new HashMap<String, FWIndexServiceDao>();
        HashSet<FieldIndexContainerDao> fieldItems = new HashSet<FieldIndexContainerDao>();
        FWIndexServiceDao ss = new FWIndexServiceDao();
        ss.setID("8b77-1111-89b1-c128");
        ss.setType(DataSource.Type.ForwardIndex.toString());
        ss.setFunctionality("search.index.fw");
        ss.setHostingNode("FWIndexGHNOne");
        ss.setEndpoint("http://nowhere3.com/wsrf/index/forward");
        ss.getScopes().add("/no/scope/");
        serviceItems.put(ss.getID(), ss);
        FWIndexDao s = new FWIndexDao();
        s.setID("8b77-1111-89b1-c128");
        s.setType(DataSource.Type.ForwardIndex.toString());
        s.setFunctionality("search.index.fw");
        s.getCapabilities().clear();
        s.getCapabilities().add("any");
        s.getFields().clear();
        s.getScopes().add("/no/scope/");
        ArrayList<String> ff = new ArrayList<String>();
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:identifier");
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:identifier");
        for (String f : ff) {
            String[] fparts = f.split(":");
            if (fparts.length != 4) continue;
            FieldIndexContainerDao fc = new FieldIndexContainerDao();
            fc.setID(s.getID() + ":" + f);
            fc.setCollection(fparts[0]);
            fc.setLanguage(fparts[1]);
            fc.setFieldType(fparts[2]);
            fc.setField(fparts[3]);
            s.getFields().add(fc.getID());
            fieldItems.add(fc);
        }
        datasourceItems.put(s.getID(), s);
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(datasourceItems.values());
        retValue.addAll(fieldItems);
        return retValue;
    }

    private static Set<IDaoElement> getWorkflowService() throws Exception {
        GCUBEScope[] scopes = BridgeHelper.scopes;
        HashMap<String, WorkflowServiceDao> serviceItems = new HashMap<String, WorkflowServiceDao>();
        for (GCUBEScope scope : scopes) {
            logger.log(Level.INFO, "Searching for workflow engine services in scope " + scope.toString());
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBERIQuery query = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/ServiceName", "WorkflowEngineService")});
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/ServiceClass", "Execution")});
            List result = client.execute((ISQuery)query, scope);
            logger.log(Level.INFO, "Found " + result.size() + " services in scope");
            for (GCUBERunningInstance inst : result) {
                List eprs = inst.getAccessPoint().getRunningInstanceInterfaces().getEndpoint();
                if (eprs.size() != 1) continue;
                if (serviceItems.containsKey(inst.getID())) {
                    ((WorkflowServiceDao)serviceItems.get(inst.getID())).getScopes().addAll(new HashSet(inst.getScopes().keySet()));
                    continue;
                }
                WorkflowServiceDao s = new WorkflowServiceDao();
                s.setEndpoint(((Endpoint)eprs.get(0)).getValue());
                s.setFunctionality("execution.workflow");
                s.setID(inst.getID());
                s.setHostingNode(inst.getGHNID());
                s.getScopes().addAll(new HashSet(inst.getScopes().keySet()));
                serviceItems.put(s.getID(), s);
            }
        }
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(serviceItems.values());
        return retValue;
    }

    private static Set<IDaoElement> getSearchService() {
        return searchSystemServices;
    }

    private static Set<IDaoElement> retrieveSearchService() throws Exception {
        GCUBEScope[] scopes = BridgeHelper.scopes;
        HashMap<String, SearchServiceDao> serviceItems = new HashMap<String, SearchServiceDao>();
        for (GCUBEScope scope : scopes) {
            logger.log(Level.INFO, "Searching for search system services in scope " + scope.toString());
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBERIQuery query = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/ServiceName", "SearchSystemService")});
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/ServiceClass", "Search")});
            List result = client.execute((ISQuery)query, scope);
            logger.log(Level.INFO, "Found " + result.size() + " services in scope");
            for (GCUBERunningInstance inst : result) {
                List eprs = inst.getAccessPoint().getRunningInstanceInterfaces().getEndpoint();
                if (eprs.size() != 1) continue;
                if (serviceItems.containsKey(inst.getID())) {
                    ((SearchServiceDao)serviceItems.get(inst.getID())).getScopes().addAll(new HashSet(inst.getScopes().keySet()));
                    continue;
                }
                SearchServiceDao s = new SearchServiceDao();
                s.setEndpoint(((Endpoint)eprs.get(0)).getValue());
                s.setFunctionality("search.orchestrator");
                s.setID(inst.getID());
                s.setHostingNode(inst.getGHNID());
                s.getScopes().addAll(new HashSet(inst.getScopes().keySet()));
                serviceItems.put(s.getID(), s);
            }
        }
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(serviceItems.values());
        return retValue;
    }

    private static Set<IDaoElement> getExecutionServer() throws Exception {
        GCUBEScope[] scopes = BridgeHelper.scopes;
        HashMap<String, ExecutionServerDao> serverItems = new HashMap<String, ExecutionServerDao>();
        HashMap<String, ExecutionServiceDao> serviceItems = new HashMap<String, ExecutionServiceDao>();
        for (GCUBEScope scope : scopes) {
            logger.log(Level.INFO, "Searching for execution engine services in scope " + scope.toString());
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBERIQuery query = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/ServiceName", "ExecutionEngineService")});
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/ServiceClass", "Execution")});
            List result = client.execute((ISQuery)query, scope);
            logger.log(Level.INFO, "Found " + result.size() + " services in scope");
            for (GCUBERunningInstance inst : result) {
                String sd;
                List eprs = inst.getAccessPoint().getRunningInstanceInterfaces().getEndpoint();
                if (eprs.size() != 1) continue;
                if (serviceItems.containsKey(inst.getID())) {
                    ((ExecutionServiceDao)serviceItems.get(inst.getID())).getScopes().addAll(new HashSet(inst.getScopes().keySet()));
                } else {
                    ExecutionServiceDao s = new ExecutionServiceDao();
                    s.setEndpoint(((Endpoint)eprs.get(0)).getValue());
                    s.setFunctionality("execution.execute");
                    s.setID(inst.getID());
                    s.setHostingNode(inst.getGHNID());
                    s.getScopes().addAll(new HashSet(inst.getScopes().keySet()));
                    serviceItems.put(s.getID(), s);
                }
                if ((sd = inst.getSpecificData()) == null || sd.trim().length() == 0) continue;
                Document doc = XMLUtils.Deserialize((String)sd);
                List elems = XMLUtils.GetChildElementsWithName((Node)doc.getDocumentElement(), (String)"element");
                String hostname = null;
                String port = null;
                String elemId = null;
                for (Element el : elems) {
                    elemId = XMLUtils.GetAttribute((Element)el, (String)"id");
                    Element dynElem = XMLUtils.GetChildElementWithName((Node)el, (String)"dynamic");
                    List dynPairs = XMLUtils.GetChildElementsWithName((Node)dynElem, (String)"entry");
                    for (Element pair : dynPairs) {
                        String attrVal;
                        if (!XMLUtils.AttributeExists((Element)pair, (String)"pe2ng.port").booleanValue()) {
                            if (!XMLUtils.AttributeExists((Element)pair, (String)"key").booleanValue()) continue;
                            attrVal = XMLUtils.GetAttribute((Element)pair, (String)"key");
                            if (attrVal != null && attrVal.equals("pe2ng.port")) {
                                port = XMLUtils.GetChildText((Node)pair);
                            }
                        } else {
                            port = XMLUtils.GetAttribute((Element)pair, (String)"pe2ng.port");
                        }
                        if (!XMLUtils.AttributeExists((Element)pair, (String)"hostname").booleanValue()) {
                            if (!XMLUtils.AttributeExists((Element)pair, (String)"key").booleanValue() || (attrVal = XMLUtils.GetAttribute((Element)pair, (String)"key")) == null || !attrVal.equals("hostname")) continue;
                            hostname = XMLUtils.GetChildText((Node)pair);
                            break;
                        }
                        hostname = XMLUtils.GetAttribute((Element)pair, (String)"hostname");
                        break;
                    }
                    if (port == null || hostname == null) continue;
                    break;
                }
                if (port == null) continue;
                if (serverItems.containsKey(elemId)) {
                    ((ExecutionServerDao)serverItems.get(elemId)).getScopes().addAll(new HashSet(inst.getScopes().keySet()));
                    continue;
                }
                ExecutionServerDao ss = new ExecutionServerDao();
                ss.setFunctionality("execution.execute");
                ss.setHostingNode(inst.getGHNID());
                ss.setID(elemId);
                ss.setHostname(hostname);
                ss.setPort(port);
                ss.getScopes().addAll(new HashSet(inst.getScopes().keySet()));
                serverItems.put(ss.getID(), ss);
            }
        }
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(serviceItems.values());
        retValue.addAll(serverItems.values());
        logger.log(Level.INFO, "Found " + serverItems.values().size() + " execution servers");
        return retValue;
    }

    private static Set<IDaoElement> getFunctionality() throws Exception {
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        FunctionalityDao f = new FunctionalityDao();
        f.setName("execution.execute");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("execution.workflow");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("search.index.ft");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("search.index.fw");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("search.index.geo");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("search.index.opensearch");
        items.add((IDaoElement)f);
        return items;
    }

    private static Set<IDaoElement> getHostingNodes() throws Exception {
        GCUBEScope[] scopes = BridgeHelper.scopes;
        HashMap<String, HostingNodeDao> items = new HashMap<String, HostingNodeDao>();
        for (GCUBEScope scope : scopes) {
            logger.log(Level.INFO, "Searching for hosting nodes in scope " + scope.toString());
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGHNQuery query = (GCUBEGHNQuery)client.getQuery(GCUBEGHNQuery.class);
            List result = client.execute((ISQuery)query, scope);
            logger.log(Level.INFO, "Found " + result.size() + " nodes in scope");
            for (GCUBEHostingNode node : result) {
                if (items.containsKey(node.getID())) {
                    ((HostingNodeDao)items.get(node.getID())).getScopes().addAll(node.getScopes().keySet());
                    continue;
                }
                HostingNodeDao item = new HostingNodeDao();
                item.setID(node.getID());
                item.setScopes(new HashSet(node.getScopes().keySet()));
                try {
                    item.getPairKeys().add("hn.infrastructure");
                    item.getPairValues().add("hn.infrastructure##delim##" + node.getInfrastructure());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.country");
                    item.getPairValues().add("hn.country##delim##" + node.getSite().getCountry());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.domain");
                    item.getPairValues().add("hn.domain##delim##" + node.getSite().getDomain());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.latitude");
                    item.getPairValues().add("hn.latitude##delim##" + node.getSite().getLatitude());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.longitude");
                    item.getPairValues().add("hn.longitude##delim##" + node.getSite().getLongitude());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.location");
                    item.getPairValues().add("hn.location##delim##" + node.getSite().getLocation());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.architecture.platform");
                    item.getPairValues().add("hn.architecture.platform##delim##" + node.getNodeDescription().getArchitecture().getPlatformType());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.architecture.smp");
                    item.getPairValues().add("hn.architecture.smp##delim##" + Long.toString(node.getNodeDescription().getArchitecture().getSMPSize()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.architecture.smt");
                    item.getPairValues().add("hn.architecture.smt##delim##" + Long.toString(node.getNodeDescription().getArchitecture().getSMTSize()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.benchmark.sf00");
                    item.getPairValues().add("hn.benchmark.sf00##delim##" + Long.toString(node.getNodeDescription().getBenchmark().getSF00()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.benchmark.si00");
                    item.getPairValues().add("hn.benchmark.si00##delim##" + Long.toString(node.getNodeDescription().getBenchmark().getSI00()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.one_day");
                    item.getPairValues().add("hn.load.one_day##delim##" + Double.toString(node.getNodeDescription().getHistoricalLoad().getLast1Day()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.one_hour");
                    item.getPairValues().add("hn.load.one_hour##delim##" + Double.toString(node.getNodeDescription().getHistoricalLoad().getLast1Hour()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.one_week");
                    item.getPairValues().add("hn.load.one_week##delim##" + Double.toString(node.getNodeDescription().getHistoricalLoad().getLast1Week()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.one_min");
                    item.getPairValues().add("hn.load.one_min##delim##" + Double.toString(node.getNodeDescription().getLoad().getLast1min()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.five_min");
                    item.getPairValues().add("hn.load.five_min##delim##" + Double.toString(node.getNodeDescription().getLoad().getLast5min()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.fifteen_min");
                    item.getPairValues().add("hn.load.fifteen_min##delim##" + Double.toString(node.getNodeDescription().getLoad().getLast15min()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.disk.size");
                    item.getPairValues().add("hn.disk.size##delim##" + Long.toString(node.getNodeDescription().getLocalAvailableSpace()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.memory.physical.available");
                    item.getPairValues().add("hn.memory.physical.available##delim##" + Long.toString(node.getNodeDescription().getMemory().getAvailable()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.memory.physical.size");
                    item.getPairValues().add("hn.memory.physical.size##delim##" + Long.toString(node.getNodeDescription().getMemory().getSize()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.memory.virtual.size");
                    item.getPairValues().add("hn.memory.virtual.size##delim##" + Long.toString(node.getNodeDescription().getMemory().getVirtualSize()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.memory.virtual.available");
                    item.getPairValues().add("hn.memory.virtual.available##delim##" + Long.toString(node.getNodeDescription().getMemory().getVirtualAvailable()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hostname");
                    item.getPairValues().add("hostname##delim##" + node.getNodeDescription().getName().substring(0, node.getNodeDescription().getName().lastIndexOf(58)));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.port");
                    item.getPairValues().add("hn.port##delim##" + node.getNodeDescription().getName().substring(node.getNodeDescription().getName().lastIndexOf(58) + 1));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.hostname");
                    item.getPairValues().add("hn.hostname##delim##" + node.getNodeDescription().getName());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                int count = 0;
                try {
                    for (Description.NetworkAdapter nadp : node.getNodeDescription().getNetworkAdapters()) {
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".inbound.ip");
                            item.getPairValues().add("hn.network.adapter." + count + ".inbound.ip" + "##delim##" + nadp.getInboundIP());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".ip.address");
                            item.getPairValues().add("hn.network.adapter." + count + ".ip.address" + "##delim##" + nadp.getIPAddress());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".mtu");
                            item.getPairValues().add("hn.network.adapter." + count + ".mtu" + "##delim##" + Long.toString(nadp.getMTU()));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".name");
                            item.getPairValues().add("hn.network.adapter." + count + ".name" + "##delim##" + nadp.getName());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".outbound.ip");
                            item.getPairValues().add("hn.network.adapter." + count + ".outbound.ip" + "##delim##" + nadp.getOutboundIP());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        ++count;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.os.name");
                    item.getPairValues().add("hn.os.name##delim##" + node.getNodeDescription().getOS().getName());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.os.release");
                    item.getPairValues().add("hn.os.release##delim##" + node.getNodeDescription().getOS().getRelease());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.os.version");
                    item.getPairValues().add("hn.os.version##delim##" + node.getNodeDescription().getOS().getVersion());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                count = 0;
                try {
                    long totalBogoMips = 0L;
                    long totalClockSpeed = 0L;
                    for (Description.Processor pr : node.getNodeDescription().getProcessors()) {
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".bogomips");
                            item.getPairValues().add("hn.processor." + count + ".bogomips" + "##delim##" + Double.toString(pr.getBogomips()));
                            totalBogoMips = (long)((double)totalBogoMips + pr.getBogomips());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".cache.l1");
                            item.getPairValues().add("hn.processor." + count + ".cache.l1" + "##delim##" + Long.toString(pr.getCacheL1()));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".cache.l1d");
                            item.getPairValues().add("hn.processor." + count + ".cache.l1d" + "##delim##" + Long.toString(pr.getCacheL1D()));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".cache.l1i");
                            item.getPairValues().add("hn.processor." + count + ".cache.l1i" + "##delim##" + Long.toString(pr.getCacheL1I()));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".cache.l2");
                            item.getPairValues().add("hn.processor." + count + ".cache.l2" + "##delim##" + Long.toString(pr.getCacheL2()));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".clockspeed");
                            item.getPairValues().add("hn.processor." + count + ".clockspeed" + "##delim##" + Double.toString(pr.getClockSpeedMHZ()));
                            totalClockSpeed = (long)((double)totalClockSpeed + pr.getClockSpeedMHZ());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".family");
                            item.getPairValues().add("hn.processor." + count + ".clockspeed" + "##delim##" + pr.getFamily());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".model");
                            item.getPairValues().add("hn.processor." + count + ".model" + "##delim##" + pr.getModel());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".model_name");
                            item.getPairValues().add("hn.processor." + count + ".model_name" + "##delim##" + pr.getModelName());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".vendor");
                            item.getPairValues().add("hn.processor." + count + ".vendor" + "##delim##" + pr.getVendor());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        ++count;
                    }
                    item.getPairKeys().add("hn.processor.count");
                    item.getPairValues().add("hn.processor.count##delim##" + Integer.toString(count));
                    item.getPairKeys().add("hn.processor.total_bogomips");
                    item.getPairValues().add("hn.processor.total_bogomips##delim##" + Long.toString(totalBogoMips));
                    item.getPairKeys().add("hn.processor.total_clockspeed");
                    item.getPairValues().add("hn.processor.total_clockspeed##delim##" + Long.toString(totalClockSpeed));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.status");
                    item.getPairValues().add("hn.status##delim##" + node.getNodeDescription().getStatus().toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                count = 0;
                try {
                    for (Description.StorageDevice sd : node.getNodeDescription().getStorageDevices()) {
                        try {
                            item.getPairKeys().add("hn.disk.device." + count + ".name");
                            item.getPairValues().add("hn.disk.device." + count + ".name" + "##delim##" + sd.getName());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.disk.device." + count + ".size");
                            item.getPairValues().add("hn.disk.device." + count + ".size" + "##delim##" + Long.toString(sd.getSize()));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.disk.device." + count + ".transfer_rate");
                            item.getPairValues().add("hn.disk.device." + count + ".transfer_rate" + "##delim##" + Long.toString(sd.getTransferRate()));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.disk.device." + count + ".type");
                            item.getPairValues().add("hn.disk.device." + count + ".type" + "##delim##" + sd.getType());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        int newCount = 0;
                        try {
                            for (Description.StoragePartition sdp : sd.getPartitions().values()) {
                                try {
                                    item.getPairKeys().add("hn.disk.device." + count + ".partition." + newCount + ".name");
                                    item.getPairValues().add("hn.disk.device." + count + ".partition." + newCount + ".name" + "##delim##" + sdp.getName());
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                try {
                                    item.getPairKeys().add("hn.disk.device." + count + ".partition." + newCount + ".read_rate");
                                    item.getPairValues().add("hn.disk.device." + count + ".partition." + newCount + ".read_rate" + "##delim##" + Long.toString(sdp.getReadRate()));
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                try {
                                    item.getPairKeys().add("hn.disk.device." + count + ".partition." + newCount + ".size");
                                    item.getPairValues().add("hn.disk.device." + count + ".partition." + newCount + ".size" + "##delim##" + sdp.getSize());
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                try {
                                    item.getPairKeys().add("hn.disk.device." + count + ".partition." + newCount + ".write_rate");
                                    item.getPairValues().add("hn.disk.device." + count + ".partition." + newCount + ".write_rate" + "##delim##" + Long.toString(sdp.getWriteRate()));
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                int deepCount = 0;
                                try {
                                    for (Description.FileSystem sdpfs : sdp.getFileSystems().values()) {
                                        try {
                                            item.getPairKeys().add("hn.disk.device." + count + ".partition." + newCount + ".filesystem." + deepCount + ".name");
                                            item.getPairValues().add("hn.disk.device." + count + ".partition." + newCount + ".filesystem." + deepCount + ".name" + "##delim##" + sdpfs.getName());
                                        }
                                        catch (Exception ex) {
                                            // empty catch block
                                        }
                                        try {
                                            item.getPairKeys().add("hn.disk.device." + count + ".partition." + newCount + ".filesystem." + deepCount + ".root");
                                            item.getPairValues().add("hn.disk.device." + count + ".partition." + newCount + ".filesystem." + deepCount + ".root" + "##delim##" + sdpfs.getRoot());
                                        }
                                        catch (Exception ex) {
                                            // empty catch block
                                        }
                                        try {
                                            item.getPairKeys().add("hn.disk.device." + count + ".partition." + newCount + ".filesystem." + deepCount + ".size");
                                            item.getPairValues().add("hn.disk.device." + count + ".partition." + newCount + ".filesystem." + deepCount + ".size" + "##delim##" + Long.toString(sdpfs.getSize()));
                                        }
                                        catch (Exception ex) {
                                            // empty catch block
                                        }
                                        try {
                                            item.getPairKeys().add("hn.disk.device." + count + ".partition." + newCount + ".filesystem." + deepCount + ".type");
                                            item.getPairValues().add("hn.disk.device." + count + ".partition." + newCount + ".filesystem." + deepCount + ".type" + "##delim##" + sdpfs.getType());
                                        }
                                        catch (Exception ex) {
                                            // empty catch block
                                        }
                                        ++deepCount;
                                    }
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                ++newCount;
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        ++count;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.uptime");
                    item.getPairValues().add("hn.uptime##delim##" + node.getNodeDescription().getUptime());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    for (GCUBEHostingNode.Package pkg : node.getDeployedPackages()) {
                        String identifier = pkg.getServiceClass() + "." + pkg.getServiceName() + "." + pkg.getPackageName();
                        try {
                            item.getPairKeys().add("software." + identifier + ".deployed");
                            item.getPairValues().add("software." + identifier + ".deployed" + "##delim##" + "true");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("software." + identifier + ".service_version");
                            item.getPairValues().add("software." + identifier + ".service_version" + "##delim##" + pkg.getServiceVersion());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("software." + identifier + ".package_version");
                            item.getPairValues().add("software." + identifier + ".package_version" + "##delim##" + pkg.getPackageVersion());
                        }
                        catch (Exception ex) {}
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    for (Description.RuntimeEnvironment.Variable var : node.getNodeDescription().getRuntime().getVariables()) {
                        try {
                            item.getPairKeys().add(var.getKey());
                            item.getPairValues().add(var.getKey() + "##delim##" + var.getValue());
                        }
                        catch (Exception ex) {}
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                items.put(item.getID(), item);
            }
        }
        return new HashSet<IDaoElement>(items.values());
    }

    private static Set<IDaoElement> getAllCollections() throws Exception {
        HashSet<IDaoElement> dataCollections = new HashSet<IDaoElement>();
        dataCollections.addAll(BridgeHelper.getDataCollections());
        dataCollections.addAll(BridgeHelper.getTreeCollections());
        return dataCollections;
    }

    private static Set<IDaoElement> getDataCollections() throws Exception {
        GCUBEScope[] scopes = BridgeHelper.scopes;
        HashMap<String, DataCollectionDao> hcols = new HashMap<String, DataCollectionDao>();
        for (GCUBEScope scope : scopes) {
            logger.log(Level.INFO, "Searching for collection in scope " + scope.toString());
            List cols = Collections.list((GCUBEScope)scope);
            logger.log(Level.INFO, "Found " + cols.size() + " collections in scope");
            for (Collection col : cols) {
                if (hcols.containsKey(col.getId())) {
                    ((DataCollectionDao)hcols.get(col.getId())).getScopes().add(scope.toString());
                    continue;
                }
                if (!col.isUserCollection()) continue;
                DataCollectionDao d = new DataCollectionDao();
                d.setID(col.getId());
                d.setDescription(col.getDescription());
                if (col.getCreationTime() != null) {
                    d.setCreationTime(Long.toString(col.getCreationTime().getTimeInMillis()));
                }
                d.setName(col.getName());
                d.getScopes().add(scope.toString());
                hcols.put(d.getID(), d);
                if (d.getDescription() == null || d.getDescription().trim().length() == 0) {
                    d.setDescription(null);
                }
                if (d.getName().trim().length() == 0) {
                    d.setName(null);
                }
                HashSet<String> toDel = new HashSet<String>();
                for (String s : d.getScopes()) {
                    if (s.trim().length() != 0) continue;
                    toDel.add(s);
                }
                d.getScopes().removeAll(toDel);
            }
        }
        return new HashSet<IDaoElement>(hcols.values());
    }

    public static Set<IDaoElement> getTreeCollections() throws Exception {
        GCUBEScope[] scopes = BridgeHelper.scopes;
        HashMap<String, DataCollectionDao> hcols = new HashMap<String, DataCollectionDao>();
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        for (GCUBEScope scope : scopes) {
            logger.log(Level.INFO, "Searching for tree collection in scope : " + scope);
            WSResourceQuery query = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//gc:ServiceName", "tree-manager-service"), new AtomicCondition("//gc:ServiceClass", "DataAccess")});
            List results = client.execute((ISQuery)query, scope);
            for (RPDocument result : results) {
                String endpoint = result.getEndpoint().getAddress().getPath();
                if (!endpoint.endsWith(TREADER_NAME)) continue;
                String name = (String)result.evaluate("//*[local-name()='Name']/text()").get(0);
                String id = (String)result.evaluate("//*[local-name()='SourceId']/text()").get(0);
                String totalItems = (String)result.evaluate("//*[local-name()='Cardinality']/text()").get(0);
                String description = null;
                String creationTime = null;
                logger.log(Level.INFO, "Parsed elements from xml : [id = " + id + ", name = " + name + ", totalItems = " + totalItems + " ] ");
                if (hcols.containsKey(id)) {
                    ((DataCollectionDao)hcols.get(id)).getScopes().add(scope.toString());
                    logger.log(Level.INFO, "updated collection of : \n" + ((DataCollectionDao)hcols.get(id)).deepToString());
                    continue;
                }
                DataCollectionDao d = new DataCollectionDao();
                d.setID(id);
                d.setName(name);
                d.setDescription(description);
                d.setCreationTime(creationTime);
                if (d.getDescription() == null || d.getDescription().trim().length() == 0) {
                    d.setDescription(null);
                }
                if (d.getName().trim().length() == 0) {
                    d.setName(null);
                }
                if (creationTime == null || creationTime.trim().length() == 0) {
                    d.setCreationTime(null);
                }
                d.getScopes().add(scope.toString());
                hcols.put(d.getID(), d);
                HashSet<String> toDel = new HashSet<String>();
                for (String s : d.getScopes()) {
                    if (s.trim().length() != 0) continue;
                    toDel.add(s);
                }
                d.getScopes().removeAll(toDel);
                logger.log(Level.INFO, "added collection : \n" + ((DataCollectionDao)hcols.get(id)).deepToString());
            }
        }
        return new HashSet<IDaoElement>(hcols.values());
    }

    private static Set<IDaoElement> getFields() throws Exception {
        logger.info("Searching for fields");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document fieldsDOM = null;
        String fieldsResource = FieldModel.getMainResource();
        if (fieldsResource == null) {
            return items;
        }
        fieldsDOM = XMLUtils.Deserialize((String)fieldsResource);
        boolean flatModel = false;
        List xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"field");
        if (xmlObjs.size() != 0) {
            flatModel = true;
        } else {
            xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"fieldId");
        }
        if (flatModel) {
            for (Element elem : xmlObjs) {
                FieldDao f = new FieldDao();
                f.fromXML(elem);
                items.add((IDaoElement)f);
            }
        } else {
            Set<String> fieldIds = FieldModel.getFieldIds();
            for (String fieldId : fieldIds) {
                String fieldResource = FieldModel.getFieldResource(fieldId);
                if (fieldResource == null) continue;
                fieldsDOM = XMLUtils.Deserialize((String)fieldResource);
                xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fieldInfo"), (String)"field");
                for (Element elem : xmlObjs) {
                    FieldDao f = new FieldDao();
                    f.fromXML(elem);
                    items.add((IDaoElement)f);
                }
            }
        }
        logger.info("Found " + items.size() + " fields");
        return items;
    }

    private static Set<IDaoElement> getSearchables() throws Exception {
        logger.info("Searching for searchables");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document fieldsDOM = null;
        String fieldsResource = FieldModel.getMainResource();
        if (fieldsResource == null) {
            return items;
        }
        fieldsDOM = XMLUtils.Deserialize((String)fieldsResource);
        boolean flatModel = false;
        List xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"searchables"), (String)"searchable");
        if (xmlObjs.size() != 0) {
            flatModel = true;
        } else {
            xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"fieldId");
        }
        if (flatModel) {
            for (Element elem : xmlObjs) {
                SearchableDao f = new SearchableDao();
                f.fromXML(elem);
                items.add((IDaoElement)f);
            }
        } else {
            Set<String> fieldIds = FieldModel.getFieldIds();
            for (String fieldId : fieldIds) {
                String fieldResource = FieldModel.getFieldResource(fieldId);
                if (fieldResource == null) continue;
                fieldsDOM = XMLUtils.Deserialize((String)fieldResource);
                xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"searchables"), (String)"searchable");
                for (Element elem : xmlObjs) {
                    SearchableDao f = new SearchableDao();
                    f.fromXML(elem);
                    items.add((IDaoElement)f);
                }
            }
        }
        logger.info("Found " + items.size() + " searchables");
        return items;
    }

    private static Set<IDaoElement> getPresentables() throws Exception {
        logger.info("Searching for presentables");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document fieldsDOM = null;
        String fieldsResource = FieldModel.getMainResource();
        if (fieldsResource == null) {
            return items;
        }
        fieldsDOM = XMLUtils.Deserialize((String)fieldsResource);
        boolean flatModel = false;
        List xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"presentables"), (String)"presentable");
        if (xmlObjs.size() != 0) {
            flatModel = true;
        } else {
            xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"fieldId");
        }
        if (flatModel) {
            for (Element elem : xmlObjs) {
                PresentableDao f = new PresentableDao();
                f.fromXML(elem);
                items.add((IDaoElement)f);
            }
        } else {
            Set<String> fieldIds = FieldModel.getFieldIds();
            for (String fieldId : fieldIds) {
                String fieldResource = FieldModel.getFieldResource(fieldId);
                if (fieldResource == null) continue;
                fieldsDOM = XMLUtils.Deserialize((String)fieldResource);
                xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"presentables"), (String)"presentable");
                for (Element elem : xmlObjs) {
                    PresentableDao f = new PresentableDao();
                    f.fromXML(elem);
                    items.add((IDaoElement)f);
                }
            }
        }
        logger.info("Found " + items.size() + " presentables");
        return items;
    }

    private static Set<IDaoElement> getElementMetadata() throws Exception {
        logger.info("Searching for element metadata");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document fieldsDOM = null;
        String resource = null;
        String fieldsResource = null;
        String metadataResource = FieldModel.getMetadataResource();
        resource = metadataResource == null ? (fieldsResource = FieldModel.getMainResource()) : metadataResource;
        if (resource == null) {
            return items;
        }
        fieldsDOM = XMLUtils.Deserialize((String)resource);
        List xmlObjs = null;
        Element metadataElement = XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"metadata");
        if (metadataElement == null) {
            return items;
        }
        xmlObjs = XMLUtils.GetChildElementsWithName((Node)metadataElement, (String)"elementMetadata");
        for (Element elem : xmlObjs) {
            ElementMetadataDao s = new ElementMetadataDao();
            s.fromXML(elem);
            items.add((IDaoElement)s);
        }
        logger.info("Found " + items.size() + " element metadata");
        return items;
    }

    private static Set<IDaoElement> getStaticConfiguration() throws Exception {
        logger.info("Searching for static configuration");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document staticConfigDOM = null;
        String staticConfigResource = FieldModel.getStaticConfigResource();
        if (staticConfigResource == null) {
            return items;
        }
        staticConfigDOM = XMLUtils.Deserialize((String)staticConfigResource);
        StaticConfigurationDao item = new StaticConfigurationDao();
        item.fromXML(staticConfigDOM.getDocumentElement());
        items.add((IDaoElement)item);
        logger.info("Found " + items.size() + " static configuration");
        return items;
    }

    private static GCUBEGenericResource getMostRecentResource(List<GCUBEGenericResource> resources) throws Exception {
        long mostRecentTime = -1L;
        GCUBEGenericResource mostRecentResource = null;
        for (GCUBEGenericResource resource : resources) {
            long updateTime = 0L;
            try {
                updateTime = Long.parseLong(resource.getDescription());
            }
            catch (Exception ex) {
                continue;
            }
            if (updateTime <= mostRecentTime) continue;
            mostRecentResource = resource;
        }
        return mostRecentResource;
    }

    public static List<GCUBEGenericResource> getPublishedFieldResources() throws Exception {
        return BridgeHelper.getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName);
    }

    public static List<GCUBEGenericResource> getPublishedMetadataResources() throws Exception {
        return BridgeHelper.getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + "Metadata");
    }

    public static List<GCUBEGenericResource> getPublishedStaticConfigResources() throws Exception {
        return BridgeHelper.getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + "StaticConfig");
    }

    public static List<GCUBEGenericResource> getPublishedFieldResourcesForField(String fieldId) throws Exception {
        return BridgeHelper.getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + fieldId);
    }

    public static List<GCUBEGenericResource> getPublishedFieldResources(String resourceName) throws Exception {
        ISClient client = null;
        GCUBEGenericResourceQuery query = null;
        client = (ISClient)GHNContext.getImplementation(ISClient.class);
        query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/SecondaryType", GCubeRepositoryProvider.RRModelGenericResourceName)});
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Name", resourceName)});
        GCUBEScope[] scopes = BridgeHelper.scopes;
        ArrayList<GCUBEGenericResource> resources = new ArrayList<GCUBEGenericResource>();
        for (GCUBEScope scope : scopes) {
            resources.addAll(client.execute((ISQuery)query, scope));
        }
        return resources;
    }

    public static void publishFieldResource(GCUBEGenericResource resource, boolean isNew) throws Exception {
        logger.log(Level.INFO, "publishing information on IS");
        GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl(){

            public boolean isSecurityEnabled() {
                return false;
            }
        };
        ISPublisher publish = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
        for (GCUBEScope scope : BridgeHelper.getFieldModelScopes()) {
            if (isNew) {
                publish.registerGCUBEResource((GCUBEResource)resource, scope, (GCUBESecurityManager)managerSec);
                continue;
            }
            publish.updateGCUBEResource((GCUBEResource)resource, scope, (GCUBESecurityManager)managerSec);
        }
        logger.log(Level.INFO, "done publishing information on IS");
    }

    public static void deleteFieldResource(GCUBEGenericResource resource) throws Exception {
        logger.log(Level.INFO, "Deleting information from IS");
        GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl(){

            public boolean isSecurityEnabled() {
                return false;
            }
        };
        ISPublisher publish = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
        for (GCUBEScope scope : BridgeHelper.getFieldModelScopes()) {
            publish.removeGCUBEResource(resource.getID(), resource.getType(), scope, (GCUBESecurityManager)managerSec);
        }
        logger.log(Level.INFO, "done deleting information from IS");
    }

    public static String buildFieldDirectorySerialization(Set<IDaoElement> fields) throws ResourceRegistryException {
        StringBuilder buf = new StringBuilder();
        buf.append("<root>\n");
        buf.append("<fields>\n");
        for (IDaoElement elem : fields) {
            buf.append("<fieldId>");
            buf.append(((FieldDao)elem).getID());
            buf.append("</fieldId>");
        }
        buf.append("</fields>\n");
        buf.append("</root>\n");
        return buf.toString();
    }

    public static String buildFieldSerialization(IDaoElement field, Set<IDaoElement> searchables, Set<IDaoElement> presentables) throws ResourceRegistryException {
        StringBuilder buf = new StringBuilder();
        buf.append("<root>\n");
        buf.append("<fieldInfo>\n");
        buf.append(field.toXML());
        buf.append("</fieldInfo>\n");
        buf.append("<searchables>\n");
        for (String searchableId : ((FieldDao)field).getSearchables()) {
            for (IDaoElement elem : searchables) {
                if (!elem.getID().equals(searchableId)) continue;
                buf.append(elem.toXML());
            }
        }
        buf.append("</searchables>\n");
        buf.append("<presentables>\n");
        for (String presentableId : ((FieldDao)field).getPresentables()) {
            for (IDaoElement elem : presentables) {
                if (!elem.getID().equals(presentableId)) continue;
                buf.append(elem.toXML());
            }
        }
        buf.append("</presentables>\n");
        buf.append("</root>\n");
        return buf.toString();
    }

    public static String updateFieldSerialization(String originalSerialization, IDaoElement field, Set<IDaoElement> searchables, Set<IDaoElement> presentables, boolean updateFields, boolean updateSearchables, boolean updatePresentables) throws Exception {
        Document original = XMLUtils.Deserialize((String)originalSerialization);
        StringBuilder buf = new StringBuilder();
        buf.append("<root>\n");
        if (updateFields) {
            if (updateSearchables && updatePresentables) {
                buf.append("<fieldInfo>\n");
                buf.append(field.toXML());
                buf.append("</fieldInfo>\n");
            } else {
                Element originalField = (Element)XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)original.getDocumentElement(), (String)"fieldInfo"), (String)"field").get(0);
                buf.append("<fieldInfo>\n");
                FieldDao updatedDao = new FieldDao();
                Document dbField = XMLUtils.Deserialize((String)field.toXML());
                updatedDao.setID(((FieldDao)field).getID());
                updatedDao.setName(((FieldDao)field).getName());
                updatedDao.setDescription(((FieldDao)field).getDescription());
                HashSet<String> updatedSearchables = new HashSet<String>();
                if (updateSearchables) {
                    List dbSearchables = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)dbField.getDocumentElement(), (String)"searchables"), (String)"searchable");
                    for (Element dbSearchable : dbSearchables) {
                        updatedSearchables.add(dbSearchable.getFirstChild().getNodeValue());
                    }
                } else {
                    List originalSearchables = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)originalField, (String)"searchables"), (String)"searchable");
                    for (Element originalSearchable : originalSearchables) {
                        updatedSearchables.add(originalSearchable.getFirstChild().getNodeValue());
                    }
                }
                HashSet<String> updatedPresentables = new HashSet<String>();
                if (updatePresentables) {
                    List dbPresentables = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)dbField.getDocumentElement(), (String)"presentables"), (String)"presentable");
                    for (Element dbPresentable : dbPresentables) {
                        updatedPresentables.add(dbPresentable.getFirstChild().getNodeValue());
                    }
                } else {
                    List originalPresentables = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)originalField, (String)"presentables"), (String)"presentable");
                    for (Element originalPresentable : originalPresentables) {
                        updatedPresentables.add(originalPresentable.getFirstChild().getNodeValue());
                    }
                }
                updatedDao.setSearchables(updatedSearchables);
                updatedDao.setPresentables(updatedPresentables);
                buf.append(updatedDao.toXML());
                buf.append("</fieldInfo>\n");
            }
        } else {
            Element originalFields = XMLUtils.GetChildElementWithName((Node)original.getDocumentElement(), (String)"fieldInfo");
            buf.append(XMLUtils.Serialize((Node)originalFields, (boolean)true));
        }
        if (updateSearchables) {
            buf.append("<searchables>\n");
            for (String searchableId : ((FieldDao)field).getSearchables()) {
                for (IDaoElement elem : searchables) {
                    if (!elem.getID().equals(searchableId)) continue;
                    buf.append(elem.toXML());
                }
            }
            buf.append("</searchables>\n");
        } else {
            Element originalSearchables = XMLUtils.GetChildElementWithName((Node)original.getDocumentElement(), (String)"searchables");
            buf.append(XMLUtils.Serialize((Node)originalSearchables, (boolean)true));
        }
        if (updatePresentables) {
            buf.append("<presentables>\n");
            for (String presentableId : ((FieldDao)field).getPresentables()) {
                for (IDaoElement elem : presentables) {
                    if (!elem.getID().equals(presentableId)) continue;
                    buf.append(elem.toXML());
                }
            }
            buf.append("</presentables>\n");
        } else {
            Element originalPresentables = XMLUtils.GetChildElementWithName((Node)original.getDocumentElement(), (String)"presentables");
            buf.append(XMLUtils.Serialize((Node)originalPresentables, (boolean)true));
        }
        buf.append("</root>\n");
        return buf.toString();
    }

    public static String buildElementMetadataSerialization(Set<IDaoElement> metadata) throws ResourceRegistryException {
        StringBuilder buf = new StringBuilder();
        buf.append("<root>\n");
        buf.append("<metadata>\n");
        for (IDaoElement elem : metadata) {
            buf.append(elem.toXML());
        }
        buf.append("</metadata>\n");
        buf.append("</root>\n");
        return buf.toString();
    }

    public static String buildStaticConfigSerialization(IDaoElement staticConfig) throws ResourceRegistryException {
        StringBuilder buf = new StringBuilder();
        buf.append(staticConfig.toXML());
        return buf.toString();
    }

    public static void prefetchInMemoryItems(Set<Class<?>> itemTypes) throws ResourceRegistryException {
        InMemoryStore.clear();
        HashMap<String, ElementMetadataDao> metadata = new HashMap<String, ElementMetadataDao>();
        Set metadataSet = null;
        try {
            metadataSet = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, ElementMetadataDao.class);
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Could not retrieve element metadata", (Throwable)e);
        }
        for (IDaoElement m : metadataSet) {
            metadata.put(m.getID(), (ElementMetadataDao)m);
        }
        boolean baseDatasource = false;
        for (Class<?> itemType : itemTypes) {
            if (!itemType.getName().equals(DataSource.class.getName())) continue;
            baseDatasource = true;
            break;
        }
        boolean baseDatasourceService = false;
        for (Class<?> itemType : itemTypes) {
            if (!itemType.getName().equals(DataSourceService.class.getName())) continue;
            baseDatasourceService = true;
            break;
        }
        for (Class<?> itemType : itemTypes) {
            List ds;
            Searchable loaded;
            Set items;
            logger.log(Level.INFO, "Prefetching element " + itemType.getName());
            if (itemType.getName().equals(DataCollection.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(DataCollection.getAllCollections((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(DataLanguage.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(DataLanguage.getLanguages()));
                continue;
            }
            if (itemType.getName().equals(Functionality.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(Functionality.getAllFunctionalities((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(HostingNode.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(HostingNode.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(Field.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(Field.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(Searchable.class.getName())) {
                items = null;
                try {
                    items = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, SearchableDao.class);
                }
                catch (Exception e) {
                    throw new ResourceRegistryException("Could not prefetch searchables", (Throwable)e);
                }
                for (IDaoElement item : items) {
                    loaded = new Searchable();
                    loaded.setID(((SearchableDao)item).getID());
                    loaded.load(false);
                    if (metadata.containsKey(loaded.getField()) && ((ElementMetadataDao)metadata.get(loaded.getField())).getType().equals(ElementMetadata.Type.DeletedField.toString())) continue;
                    InMemoryStore.setItem(Searchable.class, (IRRElement)loaded);
                }
                continue;
            }
            if (itemType.getName().equals(Presentable.class.getName())) {
                items = null;
                try {
                    items = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, PresentableDao.class);
                }
                catch (Exception e) {
                    throw new ResourceRegistryException("Could not prefetch presentables", (Throwable)e);
                }
                for (IDaoElement item : items) {
                    loaded = new Presentable();
                    loaded.setID(((PresentableDao)item).getID());
                    loaded.load(false);
                    if (metadata.containsKey(loaded.getField()) && ((ElementMetadataDao)metadata.get(loaded.getField())).getType().equals(ElementMetadata.Type.DeletedField.toString())) continue;
                    InMemoryStore.setItem(Presentable.class, (IRRElement)loaded);
                }
                continue;
            }
            if (itemType.getName().equals(DataSource.class.getName())) {
                ds = DataSource.getAll((boolean)false);
                for (DataSource d : ds) {
                    InMemoryStore.setItem(d.getClass(), (IRRElement)d);
                }
                continue;
            }
            if (itemType.getName().equals(DataSourceService.class.getName())) {
                ds = DataSourceService.getAll((boolean)false);
                for (DataSource d : ds) {
                    InMemoryStore.setItem(d.getClass(), (IRRElement)d);
                }
                continue;
            }
            if (itemType.getName().equals(FTIndex.class.getName())) {
                if (baseDatasource) continue;
                InMemoryStore.setItems(FTIndex.class, new HashSet(FTIndex.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(FTIndexService.class.getName())) {
                if (baseDatasourceService) continue;
                InMemoryStore.setItems(FTIndexService.class, new HashSet(FTIndexService.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(FWIndex.class.getName())) {
                if (baseDatasource) continue;
                InMemoryStore.setItems(FWIndex.class, new HashSet(FWIndex.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(FWIndexService.class.getName())) {
                if (baseDatasourceService) continue;
                InMemoryStore.setItems(FWIndexService.class, new HashSet(FWIndexService.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(GeoIndex.class.getName())) {
                if (baseDatasource) continue;
                InMemoryStore.setItems(GeoIndex.class, new HashSet(GeoIndex.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(GeoIndexService.class.getName())) {
                if (baseDatasourceService) continue;
                InMemoryStore.setItems(GeoIndexService.class, new HashSet(GeoIndexService.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(OpenSearchDataSource.class.getName())) {
                if (baseDatasource) continue;
                InMemoryStore.setItems(OpenSearchDataSource.class, new HashSet(OpenSearchDataSource.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(OpenSearchDataSourceService.class.getName())) {
                if (baseDatasourceService) continue;
                InMemoryStore.setItems(OpenSearchDataSourceService.class, new HashSet(OpenSearchDataSourceService.getAll((boolean)false)));
                continue;
            }
            if (!itemType.getName().equals(FieldIndexContainer.class.getName())) continue;
            items = null;
            try {
                items = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, FieldIndexContainerDao.class);
            }
            catch (Exception e) {
                throw new ResourceRegistryException("Could not prefetch datasource field info", (Throwable)e);
            }
            for (IDaoElement item : items) {
                loaded = new FieldIndexContainer();
                loaded.setID(((FieldIndexContainerDao)item).getID());
                loaded.load(false);
                InMemoryStore.setItem(FieldIndexContainer.class, (IRRElement)loaded);
            }
        }
    }
}

