/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.rr.bridge;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.execution.rr.bridge.BridgeHelper;
import org.gcube.execution.rr.bridge.GCubeRepositoryProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FieldModel {
    private static Logger logger = Logger.getLogger(FieldModel.class.getName());
    private static GCUBEGenericResource mainResource;
    private static Map<String, GCUBEGenericResource> fieldResources;
    private static GCUBEGenericResource metadataResource;
    private static GCUBEGenericResource staticConfigResource;
    private static Set<String> fieldIds;

    private static GCUBEGenericResource getMostRecentResource(List<GCUBEGenericResource> resources) throws Exception {
        long mostRecentTime = -1L;
        GCUBEGenericResource mostRecentResource = null;
        for (GCUBEGenericResource resource : resources) {
            long updateTime = 0L;
            try {
                updateTime = Long.parseLong(resource.getDescription());
            }
            catch (Exception ex) {
                continue;
            }
            if (updateTime <= mostRecentTime) continue;
            mostRecentResource = resource;
        }
        return mostRecentResource;
    }

    private static void processResources(Map<String, Map<String, GCUBEGenericResource>> resources) throws Exception {
        HashSet<String> fieldResourceIds = new HashSet<String>();
        HashSet<String> fieldIdsInDirectory = new HashSet<String>();
        ArrayList<GCUBEGenericResource> mainResources = new ArrayList<GCUBEGenericResource>();
        for (Map<String, GCUBEGenericResource> resourcesInScope : resources.values()) {
            GCUBEGenericResource mainResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName);
            if (mainResource == null) continue;
            mainResources.add(mainResource);
        }
        mainResource = FieldModel.getMostRecentResource(mainResources);
        Document fieldsDOM = null;
        if (mainResource == null || mainResource.getBody() == null || mainResource.getBody().trim().length() == 0) {
            return;
        }
        fieldsDOM = XMLUtils.Deserialize((String)mainResource.getBody());
        boolean flatModel = false;
        List xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"field");
        if (xmlObjs.size() != 0) {
            flatModel = true;
        } else {
            xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"fieldId");
        }
        for (Element elem : xmlObjs) {
            if (!flatModel) {
                fieldIdsInDirectory.add(elem.getFirstChild().getNodeValue());
                continue;
            }
            fieldIdsInDirectory.add(XMLUtils.GetChildElementWithName((Node)elem, (String)"id").getFirstChild().getNodeValue());
        }
        fieldIds.addAll(fieldIdsInDirectory);
        ArrayList<GCUBEGenericResource> metadataResources = new ArrayList<GCUBEGenericResource>();
        for (Map<String, GCUBEGenericResource> resourcesInScope : resources.values()) {
            GCUBEGenericResource metadataResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName + ".Metadata");
            if (metadataResource == null) continue;
            metadataResources.add(metadataResource);
        }
        metadataResource = FieldModel.getMostRecentResource(metadataResources);
        ArrayList<GCUBEGenericResource> staticConfigResources = new ArrayList<GCUBEGenericResource>();
        for (Map<String, GCUBEGenericResource> resourcesInScope : resources.values()) {
            GCUBEGenericResource staticConfigResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName + ".StaticConfig");
            if (staticConfigResource == null) continue;
            staticConfigResources.add(staticConfigResource);
        }
        staticConfigResource = FieldModel.getMostRecentResource(staticConfigResources);
        for (Map<String, GCUBEGenericResource> resourcesInScope : resources.values()) {
            for (Map.Entry<String, GCUBEGenericResource> r : resourcesInScope.entrySet()) {
                if (!r.getKey().startsWith(GCubeRepositoryProvider.RRModelGenericResourceName + ".")) continue;
                fieldResourceIds.add(r.getValue().getName().substring(r.getValue().getName().indexOf(".") + 1));
            }
        }
        for (String fieldResourceId : fieldResourceIds) {
            if (!fieldIdsInDirectory.contains(fieldResourceId)) continue;
            ArrayList<GCUBEGenericResource> fieldResources = new ArrayList<GCUBEGenericResource>();
            for (Map<String, GCUBEGenericResource> resourcesInScope : resources.values()) {
                GCUBEGenericResource fieldResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName + "." + fieldResourceId);
                if (fieldResource == null) continue;
                fieldResources.add(fieldResource);
            }
            GCUBEGenericResource fr = FieldModel.getMostRecentResource(fieldResources);
            if (fr == null) continue;
            FieldModel.fieldResources.put(fieldResourceId, fr);
        }
    }

    public static void retrieve() throws Exception {
        mainResource = null;
        fieldResources = new HashMap<String, GCUBEGenericResource>();
        metadataResource = null;
        staticConfigResource = null;
        fieldIds = new HashSet<String>();
        ISClient client = null;
        GCUBEGenericResourceQuery query = null;
        client = (ISClient)GHNContext.getImplementation(ISClient.class);
        query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/SecondaryType", GCubeRepositoryProvider.RRModelGenericResourceName)});
        GCUBEScope[] scopes = BridgeHelper.getFieldModelScopes();
        HashMap<String, Map<String, GCUBEGenericResource>> resources = new HashMap<String, Map<String, GCUBEGenericResource>>();
        for (GCUBEScope scope : scopes) {
            logger.info("Retrieving field model generic resources in scope " + scope.toString());
            List res = client.execute((ISQuery)query, scope);
            if (!resources.containsKey(scope.toString())) {
                resources.put(scope.toString(), new HashMap());
            }
            for (GCUBEGenericResource r : res) {
                ((Map)resources.get(scope.toString())).put(r.getName(), r);
            }
        }
        FieldModel.processResources(resources);
        logger.info("Processed field model generic resources: " + (mainResource != null ? "1" : "0") + " field directory resources containing " + fieldIds.size() + " field references, " + fieldResources.keySet().size() + " field resources, " + (metadataResource != null ? "1" : "0") + " element metadata resources, " + (staticConfigResource != null ? "1" : "0") + " static configuration resources.");
    }

    public static String getMainResource() {
        if (mainResource == null || mainResource.getBody() == null || mainResource.getBody().trim().length() == 0) {
            return null;
        }
        return mainResource.getBody();
    }

    public static String getMetadataResource() {
        if (metadataResource == null || metadataResource.getBody() == null || metadataResource.getBody().trim().length() == 0) {
            return null;
        }
        return metadataResource.getBody();
    }

    public static String getStaticConfigResource() {
        if (staticConfigResource == null || staticConfigResource.getBody() == null || staticConfigResource.getBody().trim().length() == 0) {
            return null;
        }
        return staticConfigResource.getBody();
    }

    public static Set<String> getFieldIds() {
        return fieldIds;
    }

    public static String getFieldResource(String id) {
        GCUBEGenericResource fieldResource = fieldResources.get(id);
        if (fieldResource == null || fieldResource.getBody() == null || fieldResource.getBody().trim().length() == 0) {
            return null;
        }
        return fieldResource.getBody();
    }

    static {
        fieldResources = new HashMap<String, GCUBEGenericResource>();
        fieldIds = new HashSet<String>();
    }
}

