package org.gcube.execution.rr.bridge;

import gr.uoa.di.madgik.commons.utils.XMLUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FieldModel 
{
	private static Logger logger = Logger.getLogger(FieldModel.class.getName());
	
	private static GCUBEGenericResource mainResource;
	private static Map<String, GCUBEGenericResource> fieldResources = new HashMap<String, GCUBEGenericResource>();
	private static GCUBEGenericResource metadataResource;
	private static GCUBEGenericResource staticConfigResource;
	
	private static Set<String> fieldIds = new HashSet<String>();

	private static GCUBEGenericResource getMostRecentResource(List<GCUBEGenericResource> resources) throws Exception
	{
		long mostRecentTime=-1;
		GCUBEGenericResource mostRecentResource=null;
		for(GCUBEGenericResource resource : resources)
		{
			long updateTime=0;
			try{updateTime = Long.parseLong(resource.getDescription());}catch(Exception ex){continue;}
			if(updateTime> mostRecentTime) mostRecentResource=resource;
		}
		return mostRecentResource;
	}
	
	private static void processResources(Map<String, Map<String, GCUBEGenericResource>> resources) throws Exception
	{
		Set<String> fieldResourceIds = new HashSet<String>();
		Set<String> fieldIdsInDirectory = new HashSet<String>();
		
		List<GCUBEGenericResource> mainResources = new ArrayList<GCUBEGenericResource>();
		for(Map<String, GCUBEGenericResource> resourcesInScope : resources.values())
		{
			GCUBEGenericResource mainResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName);
			if(mainResource!=null) mainResources.add(mainResource);
		}
		mainResource = getMostRecentResource(mainResources);
		
		Document fieldsDOM=null;
		if(mainResource != null && 
			mainResource.getBody()!=null && 
			mainResource.getBody().trim().length()!=0) fieldsDOM = XMLUtils.Deserialize(mainResource.getBody());
		else return;
		
		boolean flatModel = false;
		List<Element> xmlObjs = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "fields") , "field");
		if(xmlObjs.size()!=0)
			flatModel = true;
		else
			xmlObjs =XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "fields"), "fieldId");
			
		for(Element elem : xmlObjs)
		{
			if(!flatModel)
				fieldIdsInDirectory.add(elem.getFirstChild().getNodeValue());
			else
				fieldIdsInDirectory.add(XMLUtils.GetChildElementWithName(elem, "id").getFirstChild().getNodeValue());
		}
		FieldModel.fieldIds.addAll(fieldIdsInDirectory);
		
		List<GCUBEGenericResource> metadataResources = new ArrayList<GCUBEGenericResource>();
		for(Map<String, GCUBEGenericResource> resourcesInScope : resources.values())
		{
			GCUBEGenericResource metadataResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName+".Metadata");
			if(metadataResource!=null) metadataResources.add(metadataResource);
		}
		metadataResource = getMostRecentResource(metadataResources);
		
		List<GCUBEGenericResource> staticConfigResources = new ArrayList<GCUBEGenericResource>();
		for(Map<String, GCUBEGenericResource> resourcesInScope : resources.values())
		{
			GCUBEGenericResource staticConfigResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName+".StaticConfig");
			if(staticConfigResource!=null) staticConfigResources.add(staticConfigResource);
		}
		staticConfigResource = getMostRecentResource(staticConfigResources);
		
		for(Map<String, GCUBEGenericResource> resourcesInScope : resources.values())
		{
			for(Map.Entry<String, GCUBEGenericResource> r : resourcesInScope.entrySet())
			{
				if(r.getKey().startsWith(GCubeRepositoryProvider.RRModelGenericResourceName+".")) fieldResourceIds.add(r.getValue().getName().substring(r.getValue().getName().indexOf(".")+1));
			}
		}
		
		for(String fieldResourceId : fieldResourceIds)
		{
			if(!fieldIdsInDirectory.contains(fieldResourceId)) continue;
			List<GCUBEGenericResource> fieldResources = new ArrayList<GCUBEGenericResource>();
			for(Map<String, GCUBEGenericResource> resourcesInScope : resources.values())
			{
				GCUBEGenericResource fieldResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName+"."+fieldResourceId);
				if(fieldResource!=null) fieldResources.add(fieldResource);
			}
			GCUBEGenericResource fr = getMostRecentResource(fieldResources);
			if(fr!=null) FieldModel.fieldResources.put(fieldResourceId, fr);
		}
		
	}
	
	public static void retrieve() throws Exception
	{
		mainResource = null;
		fieldResources = new HashMap<String, GCUBEGenericResource>();
		metadataResource = null;
		staticConfigResource = null;
		fieldIds = new HashSet<String>();
		
		ISClient client = null;
		GCUBEGenericResourceQuery query = null;
		client =  GHNContext.getImplementation(ISClient.class);
		query = client.getQuery(GCUBEGenericResourceQuery.class);
		
		query.addAtomicConditions(new AtomicCondition("/Profile/SecondaryType", GCubeRepositoryProvider.RRModelGenericResourceName));
		
		GCUBEScope []scopes = BridgeHelper.getFieldModelScopes();
		
		Map<String, Map<String, GCUBEGenericResource>> resources=new HashMap<String, Map<String, GCUBEGenericResource>>();
		for(GCUBEScope scope : scopes)
		{
			logger.info("Retrieving field model generic resources in scope " + scope.toString());
			List<GCUBEGenericResource> res = client.execute(query,scope);
			if(!resources.containsKey(scope.toString())) resources.put(scope.toString(), new HashMap<String, GCUBEGenericResource>());
			for(GCUBEGenericResource r : res)
				resources.get(scope.toString()).put(r.getName(), r);
		}
		processResources(resources);
		logger.info("Processed field model generic resources: " + (mainResource != null ? "1" : "0") + " field directory resources containing " + fieldIds.size() + " field references, " + 
				fieldResources.keySet().size() + " field resources, " + (metadataResource != null ? "1" : "0") + " element metadata resources, " + 
				(staticConfigResource != null ? "1" : "0") + " static configuration resources.");
	}
	
	public static String getMainResource()
	{
		if(mainResource == null || 
				mainResource.getBody()==null ||
				mainResource.getBody().trim().length()==0) return null;
		 return mainResource.getBody();
	}
	
	public static String getMetadataResource()
	{
		if(metadataResource == null || 
				metadataResource.getBody()==null ||
				metadataResource.getBody().trim().length()==0) return null;
		 return metadataResource.getBody();
	}
	
	public static String getStaticConfigResource()
	{
		if(staticConfigResource == null ||
				staticConfigResource.getBody() == null ||
				staticConfigResource.getBody().trim().length()==0) return null;
		return staticConfigResource.getBody();
	}
	
	public static Set<String> getFieldIds()
	{
		return fieldIds;
	}
	
	public static String getFieldResource(String id)
	{
		GCUBEGenericResource fieldResource = fieldResources.get(id);
		if(fieldResource == null || 
				fieldResource.getBody()==null ||
				fieldResource.getBody().trim().length()==0) return null;
		 return fieldResource.getBody();
	}
	
	
}
