/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.bridge;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.bridge.IRegistryProvider;
import gr.uoa.di.madgik.rr.plugins.Plugin;
import gr.uoa.di.madgik.rr.plugins.PluginManager;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegistryBridge
extends Thread {
    private static Logger logger = Logger.getLogger(RegistryBridge.class.getName());
    private static Semaphore sem = new Semaphore(1);
    private static Lock writeLock = null;
    private static long BridgingPeriod = 600000L;
    private static long ShortBridgingPeriod = 120000L;
    private static boolean clearDatastoreOnStartup = false;
    private HashMap<String, Class<?>> incoming = new HashMap();
    private HashMap<String, Class<?>> outgoing = new HashMap();
    private HashMap<String, Class<?>> updating = new HashMap();
    private HashMap<String, Class<?>> inMemory = new HashMap();
    private IRegistryProvider provider = null;
    private boolean isInitialBridging = true;
    private boolean incomingBridgingSuccess = true;
    private Holder<Long> currentIteration = new Holder<Long>(0L);

    public RegistryBridge(IRegistryProvider provider) throws ResourceRegistryException {
        this.setDaemon(true);
        this.setName("Repository Bridge Daemon Thread");
        this.provider = provider;
        writeLock = ResourceRegistry.getContext().getExclusiveLock();
    }

    public void setIncoming(Set<String> incoming) throws ResourceRegistryException {
        this.incoming.clear();
        try {
            for (String s : incoming) {
                this.incoming.put(s, Class.forName(s));
            }
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("Could not load incoming", ex);
        }
    }

    public void setOutgoing(Set<String> outgoing) throws ResourceRegistryException {
        this.outgoing.clear();
        try {
            for (String s : outgoing) {
                this.outgoing.put(s, Class.forName(s));
            }
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("Could not load outgoing", ex);
        }
    }

    public void setUpdating(Set<String> updating) throws ResourceRegistryException {
        this.updating.clear();
        try {
            for (String s : updating) {
                this.updating.put(s, Class.forName(s));
            }
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("Could not load updating", ex);
        }
    }

    public void setInMemory(Set<String> inMemory) throws ResourceRegistryException {
        this.inMemory.clear();
        try {
            for (String s : inMemory) {
                this.inMemory.put(s, Class.forName(s));
            }
            this.provider.setInMemoryTargets(new HashSet(this.inMemory.values()));
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("Could not load in-memory items", ex);
        }
    }

    public void setBridgingPeriod(long millis) {
        BridgingPeriod = millis;
    }

    public void setShortBridgingPeriod(long millis) {
        ShortBridgingPeriod = millis;
    }

    public void setClearDataStoreOnStartup(boolean value) {
        clearDatastoreOnStartup = value;
    }

    public boolean getClearDataStoreOnStartup() {
        return clearDatastoreOnStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentIteration() {
        Holder<Long> holder = this.currentIteration;
        synchronized (holder) {
            return this.currentIteration.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        boolean acquired = false;
        logger.log(Level.INFO, "starting updating");
        try {
            logger.log(Level.FINE, "Trying to acquire lock");
            if (!sem.tryAcquire()) {
                logger.log(Level.FINE, "Failed to acquire lock because a bridging iteration is ongoing. Outgoing items will be updated during next iteration");
                return;
            }
            acquired = true;
            logger.log(Level.FINE, "Acquired lock. Continuing with update operation");
            this.doBridge(new HashSet(this.updating.values()), new HashSet(this.outgoing.values()));
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Could not complete bridging iteration", ex);
        }
        finally {
            if (acquired) {
                sem.release();
            }
        }
        logger.log(Level.INFO, "completed bridging iteration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                writeLock.lock();
            }
        });
        try {
            if (clearDatastoreOnStartup) {
                logger.log(Level.INFO, "Clearing local data store");
                DatastoreHelper.clear(RRContext.DatastoreType.LOCAL, new HashSet(this.incoming.values()));
                DatastoreHelper.clear(RRContext.DatastoreType.LOCAL, new HashSet(this.outgoing.values()));
            }
            DatastoreHelper.clear(RRContext.DatastoreType.LOCALBUFFER, new HashSet(this.incoming.values()));
            DatastoreHelper.clear(RRContext.DatastoreType.LOCALBUFFER, new HashSet(this.outgoing.values()));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to perform initial database cleanup", e);
        }
        while (true) {
            logger.log(Level.INFO, "starting bridging iteration");
            boolean acquired = false;
            try {
                if (!ResourceRegistry.isReadPolicySupported(RRContext.ReadPolicy.REFRESH_AHEAD) || !ResourceRegistry.isWritePolicySupported(RRContext.WritePolicy.WRITE_BEHIND)) {
                    this.isInitialBridging = false;
                }
            }
            catch (ResourceRegistryException e) {
                logger.log(Level.WARNING, "Could not determine read/write policy");
            }
            boolean isInitBridging = this.isInitialBridging;
            try {
                while (!acquired) {
                    try {
                        sem.acquire();
                        acquired = true;
                    }
                    catch (InterruptedException e) {}
                }
                if (ResourceRegistry.isReadPolicySupported(RRContext.ReadPolicy.REFRESH_AHEAD)) {
                    this.doBridge(new HashSet(this.incoming.values()), new HashSet(this.outgoing.values()));
                } else {
                    logger.log(Level.INFO, "REFRESH_AHEAD/WRITE_BEHIND policies not supported, nothing to do");
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Could not complete bridging iteration", ex);
            }
            finally {
                sem.release();
                Holder<Long> ex = this.currentIteration;
                synchronized (ex) {
                    this.currentIteration.set(this.currentIteration.get() + 1L);
                }
            }
            logger.log(Level.INFO, "completed bridging iteration");
            try {
                if (this.incomingBridgingSuccess && !isInitBridging) {
                    Thread.sleep(BridgingPeriod);
                    continue;
                }
                Thread.sleep(ShortBridgingPeriod);
            }
            catch (Exception exception) {
            }
        }
    }

    public boolean isInitialBridgingComplete() {
        return !this.isInitialBridging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBridge(HashSet<Class<?>> incomingItems, HashSet<Class<?>> outgoingItems) throws ResourceRegistryException {
        int pluginCount;
        logger.log(Level.INFO, "starting purging buffer");
        DatastoreHelper.clear(RRContext.DatastoreType.LOCALBUFFER, incomingItems);
        if (this.isInitialBridging) {
            logger.log(Level.INFO, "initial bridging, omiting outgoing");
            DatastoreHelper.clear(RRContext.DatastoreType.LOCALBUFFER, outgoingItems);
            incomingItems.addAll(outgoingItems);
        } else if (this.incomingBridgingSuccess) {
            pluginCount = PluginManager.getPluginsOfType(Plugin.Type.PRE_UPDATE).size();
            logger.log(Level.INFO, pluginCount != 0 ? "Executing " + pluginCount + " plugins of type " + (Object)((Object)Plugin.Type.PRE_UPDATE) : "No " + (Object)((Object)Plugin.Type.PRE_UPDATE) + " plugins to execute");
            PluginManager.executePluginsOfType(Plugin.Type.PRE_UPDATE, outgoingItems);
            if (pluginCount != 0) {
                logger.log(Level.INFO, "Finished executing " + (Object)((Object)Plugin.Type.PRE_UPDATE) + " plugins");
            }
            logger.log(Level.INFO, "starting bridging outgoing");
            this.provider.persist(outgoingItems);
            ResourceRegistry.getContext().getExclusiveLock().lock();
            try {
                DatastoreHelper.clear(RRContext.DatastoreType.LOCALBUFFER, outgoingItems);
                DatastoreHelper.replicate(RRContext.DatastoreType.LOCAL, RRContext.DatastoreType.LOCALBUFFER, outgoingItems);
            }
            finally {
                ResourceRegistry.getContext().getExclusiveLock().unlock();
            }
            pluginCount = PluginManager.getPluginsOfType(Plugin.Type.POST_UPDATE).size();
            logger.log(Level.INFO, pluginCount != 0 ? "Executing " + pluginCount + " plugins of type " + (Object)((Object)Plugin.Type.POST_UPDATE) : "No " + (Object)((Object)Plugin.Type.POST_UPDATE) + " plugins to execute");
            PluginManager.executePluginsOfType(Plugin.Type.POST_UPDATE, outgoingItems);
            if (pluginCount != 0) {
                logger.log(Level.INFO, "Finished executing " + (Object)((Object)Plugin.Type.POST_UPDATE) + " plugins");
            }
        } else {
            logger.log(Level.INFO, "incoming bridging was not successful, omiting outgoing");
        }
        try {
            pluginCount = PluginManager.getPluginsOfType(Plugin.Type.PRE_RETRIEVE).size();
            logger.log(Level.INFO, pluginCount != 0 ? "Executing " + pluginCount + " plugins of type " + (Object)((Object)Plugin.Type.PRE_RETRIEVE) : "No " + (Object)((Object)Plugin.Type.PRE_RETRIEVE) + " plugins to execute");
            PluginManager.executePluginsOfType(Plugin.Type.PRE_RETRIEVE, incomingItems);
            if (pluginCount != 0) {
                logger.log(Level.INFO, "Finished executing " + (Object)((Object)Plugin.Type.PRE_RETRIEVE) + " plugins");
            }
            logger.log(Level.INFO, "starting bridging incoming");
            this.provider.retrieve(incomingItems);
            pluginCount = PluginManager.getPluginsOfType(Plugin.Type.POST_RETRIEVE).size();
            logger.log(Level.INFO, pluginCount != 0 ? "Executing " + pluginCount + " plugins of type " + (Object)((Object)Plugin.Type.POST_RETRIEVE) : "No " + (Object)((Object)Plugin.Type.POST_RETRIEVE) + " plugins to execute");
            PluginManager.executePluginsOfType(Plugin.Type.POST_RETRIEVE, incomingItems);
            if (pluginCount != 0) {
                logger.log(Level.INFO, "Finished executing " + (Object)((Object)Plugin.Type.POST_RETRIEVE) + " plugins");
            }
        }
        catch (ResourceRegistryException e) {
            this.incomingBridgingSuccess = false;
            throw e;
        }
        logger.log(Level.INFO, "starting purging local");
        ResourceRegistry.getContext().getExclusiveLock().lock();
        try {
            DatastoreHelper.resolveUpdateConflicts(RRContext.DatastoreType.LOCALBUFFER, RRContext.DatastoreType.LOCAL, outgoingItems);
            logger.log(Level.INFO, "starting replication from buffer to local");
            DatastoreHelper.clear(RRContext.DatastoreType.LOCAL, incomingItems);
            DatastoreHelper.replicate(RRContext.DatastoreType.LOCALBUFFER, RRContext.DatastoreType.LOCAL, incomingItems);
        }
        finally {
            ResourceRegistry.getContext().getExclusiveLock().unlock();
        }
        this.provider.prefetchInMemoryItems();
        logger.log(Level.INFO, "finished client bridging");
        this.incomingBridgingSuccess = true;
        this.isInitialBridging = false;
    }

    private static class Holder<T> {
        private T obj;

        public Holder(T obj) {
            this.obj = obj;
        }

        public T get() {
            return this.obj;
        }

        public void set(T val) {
            this.obj = val;
        }
    }
}

