/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.engine.monitoring.consumer;

import gr.uoa.di.madgik.environment.notifications.Message;
import gr.uoa.di.madgik.environment.notifications.NotificationMessageListenerI;
import gr.uoa.di.madgik.environment.notifications.SubscriberToTopic;
import gr.uoa.di.madgik.environment.notifications.TextMessage;
import gr.uoa.di.madgik.execution.engine.monitoring.resource.ExecutionNodesLoad;
import gr.uoa.di.madgik.notificationhandling.NotificationHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionNodesLoadConsumer {
    public static final String EXECUTIONNODEMONITOR = "ExecutionNodeMonitor";
    private Logger log = LoggerFactory.getLogger((String)ExecutionNodesLoadConsumer.class.getName());
    private String resourceID = null;
    private SubscriberToTopic subscriberToExecutionNodeLoad = null;
    private ExecutionNodesLoad executionNodesLoad;
    private NotificationMessageListenerI executionNodeListener = new LoadConsumerNotification();

    public ExecutionNodesLoadConsumer(String resourceID, ExecutionNodesLoad executionNodesLoad) {
        this.resourceID = resourceID;
        this.executionNodesLoad = executionNodesLoad;
    }

    public void subscribeForExecutionNodeLoad() {
        try {
            String topicId = NotificationHandling.RegisterNotificationTopic((String)"NodeLoadMonitoring", (String)"ExecutionEngine", null);
            this.subscriberToExecutionNodeLoad = NotificationHandling.RegisterToNotificationTopic((String)topicId, (String)this.resourceID, (String)(topicId + this.resourceID), (String)"", (SubscriberToTopic)this.subscriberToExecutionNodeLoad, (NotificationMessageListenerI)this.executionNodeListener, null);
            this.log.debug("Consumer with id " + this.resourceID + " subscribed for execution node load reporting, to the following topic ID: " + topicId);
        }
        catch (Exception e) {
            this.log.error("Failed to subscribe for execution node load reporting with id: " + this.resourceID, (Throwable)e);
        }
    }

    public void UnregisterFromExecutionNodeLoad() {
        try {
            String topicId = NotificationHandling.RegisterNotificationTopic((String)"NodeLoadMonitoring", (String)"ExecutionEngine", null);
            NotificationHandling.UnregisterFromNotificationTopic((String)topicId, (String)(topicId + this.resourceID), (SubscriberToTopic)this.subscriberToExecutionNodeLoad, null);
            this.log.debug("Consumer unsubscribed from execution node load reporting, with the following topic ID: " + topicId);
        }
        catch (Exception e) {
            this.log.error("Failed to unsubscribe for execution node load reporting", (Throwable)e);
        }
    }

    private void handleUpdateNotification(String strMsg) {
        String hostName = null;
        Float load = null;
        this.log.info("Received load notification.");
        if (strMsg != null) {
            String[] parsed;
            for (String token : parsed = strMsg.split(",")) {
                String attr = token.split("=")[0];
                String value = token.split("=")[1];
                if (attr.equals("load")) {
                    load = Float.valueOf(Float.parseFloat(value));
                    continue;
                }
                if (!attr.equals("hostname")) continue;
                hostName = value;
            }
        }
        if (hostName != null && load != null) {
            String[] parts = hostName.split(":");
            if (parts.length > 1 && parts[1].compareTo("null") == 0) {
                this.log.warn("Received notification from node with port null. Hostname: " + hostName);
            }
            this.log.info("Hostname " + hostName + " reported load: " + load);
            this.executionNodesLoad.put(hostName, load);
        }
    }

    public class LoadConsumerNotification
    implements NotificationMessageListenerI {
        public void onMessage(Message message) {
            TextMessage textMsg = (TextMessage)message;
            String strMsg = textMsg.getText();
            ExecutionNodesLoadConsumer.this.handleUpdateNotification(strMsg);
        }
    }
}

