/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.madgik.environment.jms;

import gr.uoa.di.madgik.environment.notifications.NotificationMessageListenerI;
import gr.uoa.di.madgik.environment.notifications.SubscriberToTopic;
import gr.uoa.madgik.environment.notifications.exceptions.FailedToCommunicateWithNotificationService;
import gr.uoa.madgik.environment.notifications.exceptions.FailedToRegisterToTopicException;
import gr.uoa.madgik.environment.notifications.exceptions.FailedToUnregisterFromTopicException;
import gr.uoa.madgik.environment.notifications.exceptions.TopicCreationException;
import gr.uoa.madgik.environment.notifications.model.GeneralMessageListener;
import gr.uoa.madgik.environment.notifications.model.TopicData;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.apache.activemq.command.ActiveMQTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSConnectionHandler {
    static JMSConnectionHandler jmsManager = null;
    ConnectionFactory connectionFactory = null;
    static Logger logger = LoggerFactory.getLogger((String)JMSConnectionHandler.class.getName());

    protected JMSConnectionHandler(String jmsLocation) {
        Context jndiContext = null;
        jndiContext = JMSConnectionHandler.configureJNDIwithMap(jmsLocation);
        try {
            this.connectionFactory = (ConnectionFactory)jndiContext.lookup("ConnectionFactory");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public static JMSConnectionHandler getInstance(String jmsLocation) {
        if (jmsManager == null) {
            jmsManager = new JMSConnectionHandler(jmsLocation);
        }
        return jmsManager;
    }

    public Topic createTopic(TopicData topicData) throws TopicCreationException {
        Connection connection = null;
        try {
            Topic myTopic;
            connection = this.connectionFactory.createConnection();
            Session session = connection.createSession(false, 1);
            Topic topic = myTopic = session.createTopic(topicData.createTopicId());
            return topic;
        }
        catch (JMSException e) {
            throw new TopicCreationException(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void sendMessageForTopic(String topicName, String textMessage, HashMap<String, String> messageProperties) throws JMSException {
        Connection connection = this.connectionFactory.createConnection();
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic(topicName);
        MessageProducer producer = session.createProducer((Destination)topic);
        TextMessage message = session.createTextMessage();
        message.setText(textMessage);
        for (String key : messageProperties.keySet()) {
            message.setStringProperty(key, messageProperties.get(key));
        }
        producer.send((Message)message);
        if (connection != null) {
            try {
                connection.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    public SubscriberToTopic listenToMessagesOfTopic(TopicData topicData, String clientId, String subscriptionName, String selector, SubscriberToTopic subToTopic, NotificationMessageListenerI listener) throws FailedToRegisterToTopicException {
        if (subToTopic == null) {
            Connection connection = null;
            try {
                connection = this.connectionFactory.createConnection();
                connection.setClientID(clientId);
                Session session = connection.createSession(false, 1);
                String mySelector = "operationName = 'add'";
                mySelector = selector;
                ActiveMQTopic topic = new ActiveMQTopic();
                topic.createDestination(topicData.createTopicId());
                topic.setPhysicalName(topicData.createTopicId());
                TopicSubscriber topicSubscriber = !mySelector.equals("") ? session.createDurableSubscriber((Topic)topic, subscriptionName, mySelector, false) : session.createDurableSubscriber((Topic)topic, subscriptionName);
                GeneralMessageListener generalListener = new GeneralMessageListener();
                generalListener.setNotificationMessageListener(listener);
                topicSubscriber.setMessageListener((MessageListener)generalListener);
                SubscriberToTopic subscriber = new SubscriberToTopic();
                subscriber.setTopicSubscriber((Object)topicSubscriber);
                connection.start();
                subscriber.setConnection((Object)connection);
                return subscriber;
            }
            catch (JMSException e) {
                throw new FailedToRegisterToTopicException(e);
            }
        }
        Connection connection = (Connection)subToTopic.getConnection();
        try {
            Session session = connection.createSession(false, 1);
            String mySelector = "operationName = 'add'";
            mySelector = selector;
            ActiveMQTopic topic = new ActiveMQTopic();
            topic.createDestination(topicData.createTopicId());
            topic.setPhysicalName(topicData.createTopicId());
            TopicSubscriber topicSubscriber = !mySelector.equals("") ? session.createDurableSubscriber((Topic)topic, subscriptionName, mySelector, false) : session.createDurableSubscriber((Topic)topic, subscriptionName);
            GeneralMessageListener generalListener = new GeneralMessageListener();
            generalListener.setNotificationMessageListener(listener);
            topicSubscriber.setMessageListener((MessageListener)generalListener);
            SubscriberToTopic subscriber = new SubscriberToTopic();
            subscriber.setTopicSubscriber((Object)topicSubscriber);
            connection.start();
            subscriber.setConnection((Object)connection);
            return subscriber;
        }
        catch (JMSException e) {
            throw new FailedToRegisterToTopicException(e);
        }
    }

    public void unsubscribeFromTopic(TopicData topicData, String clientId, SubscriberToTopic subscriberToTopic) throws FailedToUnregisterFromTopicException {
        Connection connection = null;
        TopicSubscriber topicSubscriber = null;
        try {
            connection = (Connection)subscriberToTopic.getConnection();
            Session session = connection.createSession(false, 1);
            topicSubscriber = (TopicSubscriber)subscriberToTopic.getTopicSubscriber();
            topicSubscriber.close();
            session.unsubscribe(clientId);
        }
        catch (JMSException e) {
            throw new FailedToUnregisterFromTopicException(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotificationToTopic(TopicData topicData, String textMessage, HashMap<String, String> propertiesNameValueMap) {
        Session session = null;
        MessageProducer producer = null;
        Connection connection = null;
        try {
            connection = this.connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            Topic topic = session.createTopic(topicData.createTopicId());
            producer = session.createProducer((Destination)topic);
            TextMessage message = session.createTextMessage();
            message.setText(textMessage);
            for (String propertyName : propertiesNameValueMap.keySet()) {
                message.setStringProperty(propertyName, propertiesNameValueMap.get(propertyName));
            }
            producer.send((Message)message);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotificationToTopic(Topic topic, String textMessage, HashMap<String, String> propertiesNameValueMap) {
        Session session = null;
        MessageProducer producer = null;
        Connection connection = null;
        try {
            connection = this.connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            producer = session.createProducer((Destination)topic);
            TextMessage message = session.createTextMessage();
            message.setText(textMessage);
            for (String propertyName : propertiesNameValueMap.keySet()) {
                message.setStringProperty(propertyName, propertiesNameValueMap.get(propertyName));
            }
            producer.send((Message)message);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean[] isTopicRegistered(List<TopicData> topics) throws FailedToCommunicateWithNotificationService {
        boolean[] toReturn = new boolean[topics.size()];
        try {
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://dl09.di.uoa.gr:1099/jmxrmi");
            JMXConnector jmxc = JMXConnectorFactory.connect(url);
            MBeanServerConnection conn = jmxc.getMBeanServerConnection();
            ObjectName activeMQ = new ObjectName("org.apache.activemq:BrokerName=localhost,Type=Broker");
            activeMQ = new ObjectName("org.apache.activemq:BrokerName=localhost,Type=Broker");
            BrokerViewMBean mbean = MBeanServerInvocationHandler.newProxyInstance(conn, activeMQ, BrokerViewMBean.class, true);
            for (int i = 0; i < topics.size(); ++i) {
                String topicName = topics.get(i).getTopicName();
                boolean found = false;
                for (ObjectName name : mbean.getTopics()) {
                    TopicViewMBean topicMbean = MBeanServerInvocationHandler.newProxyInstance(conn, name, TopicViewMBean.class, true);
                    if (!topicMbean.getName().equals(topicName)) continue;
                    logger.debug("Found the topic!!... Deleting it...");
                    found = true;
                    break;
                }
                toReturn[i] = found;
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new FailedToCommunicateWithNotificationService(e);
        }
    }

    public void deleteTopic(TopicData topicData) throws FailedToCommunicateWithNotificationService {
        try {
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://dl09.di.uoa.gr:1099/jmxrmi");
            JMXConnector jmxc = JMXConnectorFactory.connect(url);
            MBeanServerConnection conn = jmxc.getMBeanServerConnection();
            ObjectName activeMQ = new ObjectName("org.apache.activemq:BrokerName=localhost,Type=Broker");
            String[] sig = new String[]{"java.lang.String"};
            activeMQ = new ObjectName("org.apache.activemq:BrokerName=localhost,Type=Broker");
            BrokerViewMBean mbean = MBeanServerInvocationHandler.newProxyInstance(conn, activeMQ, BrokerViewMBean.class, true);
            mbean.removeTopic(topicData.createTopicId());
        }
        catch (MalformedURLException e) {
            throw new FailedToCommunicateWithNotificationService(e);
        }
        catch (IOException e) {
            throw new FailedToCommunicateWithNotificationService(e);
        }
        catch (MalformedObjectNameException e) {
            throw new FailedToCommunicateWithNotificationService(e);
        }
        catch (NullPointerException e) {
            throw new FailedToCommunicateWithNotificationService(e);
        }
        catch (InstanceNotFoundException e) {
            throw new FailedToCommunicateWithNotificationService(e);
        }
        catch (MBeanException e) {
            throw new FailedToCommunicateWithNotificationService(e);
        }
        catch (ReflectionException e) {
            throw new FailedToCommunicateWithNotificationService(e);
        }
        catch (Exception e) {
            throw new FailedToCommunicateWithNotificationService(e);
        }
    }

    private BrokerViewMBean getActiveMQBroker() throws IOException, MalformedObjectNameException, NullPointerException {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://dl09.di.uoa.gr:1099/jmxrmi");
        JMXConnector jmxc = JMXConnectorFactory.connect(url);
        MBeanServerConnection conn = jmxc.getMBeanServerConnection();
        ObjectName activeMQ = new ObjectName("org.apache.activemq:BrokerName=localhost,Type=Broker");
        BrokerViewMBean mbean = MBeanServerInvocationHandler.newProxyInstance(conn, activeMQ, BrokerViewMBean.class, true);
        return mbean;
    }

    private static Context configureJNDIwithMap(String jmsLocation) {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        props.setProperty("java.naming.provider.url", jmsLocation);
        try {
            InitialContext ctx = new InitialContext(props);
            return ctx;
        }
        catch (NamingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

