/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.channel.nozzle;

import gr.uoa.di.madgik.commons.channel.events.ChannelPayloadStateEvent;
import gr.uoa.di.madgik.commons.channel.events.ChannelState;
import gr.uoa.di.madgik.commons.channel.events.ChannelStateEvent;
import gr.uoa.di.madgik.commons.channel.nozzle.INozzleConfig;
import gr.uoa.di.madgik.commons.channel.proxy.IChannelLocator;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistry;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChannelInlet
implements Observer {
    private static Logger logger = Logger.getLogger(ChannelInlet.class.getName());
    private long NozzleIdentifierLeastSignificantBits = 0L;
    private long NozzleIdentifierMostSignificantBits = 0L;
    private INozzleConfig Config = null;
    private ChannelState State = new ChannelState();
    private ChannelState NozzleState = new ChannelState();

    public ChannelInlet(INozzleConfig Config) {
        if (Config == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Inlet configuration cannot be null");
            }
            throw new IllegalArgumentException("Inlet configuration cannot be null");
        }
        UUID ID = UUID.randomUUID();
        this.NozzleIdentifierLeastSignificantBits = ID.getLeastSignificantBits();
        this.NozzleIdentifierMostSignificantBits = ID.getMostSignificantBits();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created inlet with identifier " + this.GetNozzleID());
        }
        this.Config = Config;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Registering for emited events");
        }
        for (ChannelStateEvent ev : this.State.GetChannelEvents()) {
            ev.addObserver(this);
        }
        ChannelRegistry.Register(this.State, this.Config, this.GetNozzleID());
    }

    @Override
    public void update(Observable o, Object arg) {
        ChannelStateEvent ev;
        if (!o.getClass().getName().equals(arg.getClass().getName())) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Caught event has argument other than the one registered for. Disgarding");
            }
            return;
        }
        if (arg instanceof ChannelStateEvent && (((ChannelStateEvent)arg).GetEmitingNozzleIdentifierLeastSignificantBits() != this.NozzleIdentifierLeastSignificantBits || ((ChannelStateEvent)arg).GetEmitingNozzleIdentifierMostSignificantBits() != this.NozzleIdentifierMostSignificantBits) && (ev = this.NozzleState.GetEvent(((ChannelStateEvent)arg).GetEventName())) != null) {
            ev.NotifyChange((ChannelStateEvent)arg);
        }
    }

    public String GetNozzleID() {
        return Long.toString(this.NozzleIdentifierLeastSignificantBits) + "#" + Long.toString(this.NozzleIdentifierMostSignificantBits);
    }

    public Collection<ChannelStateEvent> GetNozzleEvents() {
        return this.NozzleState.GetChannelEvents();
    }

    public void Dispose() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Disposing Inlet Nozzle");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Unregistering nozzle from state events");
        }
        for (ChannelStateEvent ev : this.State.GetChannelEvents()) {
            ev.deleteObserver(this);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Disposing Nozzle config");
        }
        this.Config.Dispose();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Disposing Nozzle state");
        }
        this.NozzleState.Dispose();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Disposing internal state");
        }
        this.State.Dispose();
    }

    public void Push(ChannelPayloadStateEvent Event) {
        ChannelStateEvent ev = this.State.GetEvent(Event.GetEventName());
        if (ev != null) {
            Event.SetEmitingNozzleIdentifierLeastSignificantBits(this.NozzleIdentifierLeastSignificantBits);
            Event.SetEmitingNozzleIdentifierMostSignificantBits(this.NozzleIdentifierMostSignificantBits);
            ev.NotifyChange(Event);
        }
    }

    public IChannelLocator GetLocator() {
        return this.Config.GetChannelProxy().GetLocator();
    }
}

