package gr.uoa.di.madgik.commons.infra.nodefilter;

import gr.uoa.di.madgik.commons.infra.HostingNode;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NodeFilter {
	protected static Logger logger = Logger.getLogger(NodeFilter.class
			.getName());

	static Set<HostingNode> filterNodes(Facet facet, ConstraintType filterType,
			Set<HostingNode> hostingNodes) {
		Set<HostingNode> filteredNodes = new HashSet<HostingNode>();

		for (HostingNode hostingNode : hostingNodes) {
			switch (filterType) {
			case WEAK:
				logger.log(Level.INFO, "Required WEAK constraint");
				if (facet.applyWeakConstraints(hostingNode))
					filteredNodes.add(hostingNode);
				else
					logger.log(Level.INFO, "WEAK constraint not satisfied");
				break;
			case STRONG:
				logger.log(Level.INFO, "Required STRONG constraint");
				if (facet.applyWeakConstraints(hostingNode))
					filteredNodes.add(hostingNode);
				else
					logger.log(Level.INFO, "WEAK constraint not satisfied");
				break;
			case BOTH:
				logger.log(Level.INFO, "Required STRONG constraint");
				if (facet.applyWeakConstraints(hostingNode)){
					if (facet.applyStrongConstraints(hostingNode))
						filteredNodes.add(hostingNode);
					else
						logger.log(Level.INFO, "STRONG constraint not satisfied");
				}
				else
					logger.log(Level.INFO, "WEAK constraint not satisfied");
				
				break;
			case NONE:
				logger.log(Level.INFO, "Required NO constraint");
			default:
				break;
			}
		}

		return filteredNodes;
	}
}
