/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.madgik.providers;

import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.notifications.INotificationHandlingProvider;
import gr.uoa.di.madgik.environment.notifications.NotificationMessageListenerI;
import gr.uoa.di.madgik.environment.notifications.SubscriberToTopic;
import gr.uoa.di.madgik.environment.notifications.exceptions.FailedToCommunicateWithNotificationService;
import gr.uoa.di.madgik.environment.notifications.exceptions.FailedToRegisterToTopicException;
import gr.uoa.di.madgik.environment.notifications.exceptions.FailedToUnregisterFromTopicException;
import gr.uoa.di.madgik.environment.notifications.exceptions.IllegalTopicIdGivenException;
import gr.uoa.di.madgik.environment.notifications.exceptions.TopicCreationException;
import gr.uoa.di.madgik.environment.notifications.handlers.NotificationHandler;
import gr.uoa.di.madgik.environment.notifications.model.TopicData;
import java.util.HashMap;

public class JMSNotificationHandlingProvider
implements INotificationHandlingProvider {
    public static String JMSLocationHintName = "JMSHost";

    public String registerNotificationTopic(String topicName, String producerId, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        TopicData topicData = new TopicData(topicName, producerId);
        try {
            NotificationHandler.getInstance().configureHandler(JMSNotificationHandlingProvider.GetJMSLocation(Hints));
            String topicId = NotificationHandler.getInstance().registerNotificationTopics(topicData);
            return topicId;
        }
        catch (TopicCreationException e) {
            throw new EnvironmentInformationSystemException("Error while registering to topic", (Throwable)e);
        }
    }

    public SubscriberToTopic registerToNotificationTopic(String topicId, String listenerId, String subscriptionName, String selector, SubscriberToTopic subscriberToTopic, NotificationMessageListenerI messageListener, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        try {
            String topicName = TopicData.getTopicNameFromId((String)topicId);
            String producerId = TopicData.getProviderIdFromId((String)topicId);
            TopicData topicData = new TopicData(topicName, producerId);
            NotificationHandler.getInstance().configureHandler(JMSNotificationHandlingProvider.GetJMSLocation(Hints));
            return NotificationHandler.getInstance().registerToNotificationTopic(topicData, listenerId, subscriptionName, selector, subscriberToTopic, messageListener);
        }
        catch (IllegalTopicIdGivenException e) {
            throw new EnvironmentInformationSystemException(e.getMessage(), (Throwable)e);
        }
        catch (FailedToRegisterToTopicException e) {
            throw new EnvironmentInformationSystemException(e.getMessage(), (Throwable)e);
        }
    }

    public void unregisterNotificationTopic(String topicId, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        try {
            String topicName = TopicData.getTopicNameFromId((String)topicId);
            String producerId = TopicData.getProviderIdFromId((String)topicId);
            TopicData topicData = new TopicData(topicName, producerId);
            NotificationHandler.getInstance().configureHandler(JMSNotificationHandlingProvider.GetJMSLocation(Hints));
            NotificationHandler.getInstance().unregisterNotificationTopic(topicData);
        }
        catch (IllegalTopicIdGivenException e) {
            throw new EnvironmentInformationSystemException(e.getMessage(), (Throwable)e);
        }
        catch (FailedToCommunicateWithNotificationService e) {
            throw new EnvironmentInformationSystemException(e.getMessage(), (Throwable)e);
        }
    }

    public void unregisterFromNotificationTopic(String topicId, String listenerId, SubscriberToTopic subscriberToTopic, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        try {
            String topicName = TopicData.getTopicNameFromId((String)topicId);
            String producerId = TopicData.getProviderIdFromId((String)topicId);
            TopicData topicData = new TopicData(topicName, producerId);
            NotificationHandler.getInstance().configureHandler(JMSNotificationHandlingProvider.GetJMSLocation(Hints));
            NotificationHandler.getInstance().unregisterFromNotificationTopic(topicData, listenerId, subscriberToTopic);
        }
        catch (IllegalTopicIdGivenException e) {
            throw new EnvironmentInformationSystemException(e.getMessage(), (Throwable)e);
        }
        catch (FailedToUnregisterFromTopicException e) {
            throw new EnvironmentInformationSystemException(e.getMessage(), (Throwable)e);
        }
    }

    public void sendNotificationToTopic(String topicId, String textMessage, HashMap<String, String> propertiesNameValueMap, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        try {
            String topicName = TopicData.getTopicNameFromId((String)topicId);
            String producerId = TopicData.getProviderIdFromId((String)topicId);
            TopicData topicData = new TopicData(topicName, producerId);
            NotificationHandler.getInstance().configureHandler(JMSNotificationHandlingProvider.GetJMSLocation(Hints));
            NotificationHandler.getInstance().sendNotificationToTopic(topicData, textMessage, propertiesNameValueMap);
        }
        catch (IllegalTopicIdGivenException e) {
            throw new EnvironmentInformationSystemException(e.getMessage(), (Throwable)e);
        }
    }

    private static String GetStringHint(EnvHintCollection Hints, String hintName) {
        if (Hints == null || !Hints.HintExists(hintName)) {
            return null;
        }
        String payload = Hints.GetHint((String)hintName).Hint.Payload;
        if (payload == null || payload.trim().length() == 0) {
            return null;
        }
        return payload;
    }

    private static String GetJMSLocation(EnvHintCollection Hints) {
        String hostL = JMSNotificationHandlingProvider.GetStringHint(Hints, JMSLocationHintName);
        return hostL;
    }
}

