package org.gcube.execution.indexerservice.tests;

import java.io.File;
import java.io.FileInputStream;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.contentmanager.stubs.CollectionReference;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.execution.indexerservice.utils.CMUtils;



/* Use this client to upload indexer jar in a scope in CMS
 */
public class UploadIndexerJarClient {

	public static void main(String args[]) {

		if(args.length!=1){
			System.out.println("Usage:    java org.gcube.execution.ocrservice.tests.UploadIndexerJarClient <GCUBE scope> ");
			System.out.println("Example:  java org.gcube.execution.ocrservice.tests.UploadIndexerJarClient /gcube/devNext ");
			System.exit(1);
		}

	
		try{
			
			String jarLocation = System.getenv("GLOBUS_LOCATION") + "/lib/";
			jarLocation += "org.gcube.application.parallelindexing.jar";
			
			System.out.println("Scope:                      " + args[0]);
			System.out.println("Indexer jar file to upload: " + jarLocation);
			System.out.println("");
			
			File inp = new File(jarLocation);
			if(inp==null || inp.exists()==false)
				throw new Exception("org.gcube.application.parallelindexing.jar was not found under $GLOBUS_LOCATION/lib");
			
			GCUBEScope scope = GCUBEScope.getScope(args[0]);

			///---> delete all "indexerJobCollection" collections in scope
			System.out.println("Going to delete all collections with name='"+ CMUtils.indexerJobCollectionPrefix + "_" + args[0]);
			CMUtils.deleteAllIndexerJobCollections(scope);
			
			CollectionReference indexerJobCollectionReference = null;			
			//we create the collection now
			System.out.println("We will create indexerJobCollection now in scope " + scope );
			indexerJobCollectionReference = CMUtils.createIndexerJobCollection(scope);
			if(indexerJobCollectionReference==null){
				System.out.println("Could not create collection.");
				System.exit(1);
			}

			System.out.println("Created indexer collection with id: " + indexerJobCollectionReference.getCollectionID() + " scope:" + scope );
					Thread.sleep(60000);
			
			//get writer on the new collection
			DocumentWriter	writer = CMUtils.getDocumentWriterByCollectionReference( indexerJobCollectionReference, scope);

			System.out.println("Sleeping for 1 minute");
			Thread.sleep(60000);
			//read the ocropus file from argument[1]
			System.out.println("Reading 1 file,  indexer jar in path:" + args[1]);
			FileInputStream indexerJarFile = new FileInputStream( args[1] );

			//write the document with indexer.jar and get CM Reference
			System.out.println("Creating indexer document of jar file ");
			String cmRef = CMUtils.createIndexerDocument(writer, "indexer.jar" , indexerJarFile , scope);
			System.out.println("Stored in CMS with ref: " + "cms://"+ indexerJobCollectionReference.getCollectionID()+"/"+ cmRef );

		}catch(Exception ex){
			ex.printStackTrace();
		}
		
	}

}