package org.gcube.execution.indexerservice.tests;

import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.execution.indexerservice.stubs.IndexerServiceFactoryPortType;
import org.gcube.execution.indexerservice.stubs.IndexerServicePortType;
import org.gcube.execution.indexerservice.stubs.Submit;
import org.gcube.execution.indexerservice.stubs.StatusResponseType;
import org.gcube.execution.indexerservice.stubs.SubmitResponse;
import org.gcube.execution.indexerservice.stubs.service.IndexerServiceAddressingLocator;
import org.gcube.execution.indexerservice.stubs.service.IndexerServiceFactoryServiceAddressingLocator;
import org.oasis.wsrf.lifetime.Destroy;



//java org.gcube.execution.indexerservice.tests.TestIndexerService 		<indexer factory address>                                                                          	<scope> 	  		<input location> 															<output location>											 	<shards number>  	<optional job name in >=0 words > 
//java org.gcube.execution.indexerservice.tests.TestIndexerService 		http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/indexerservice/IndexerServiceFactory 	/gcube/devNext 	    hdfs://node1.hadoop.research-infrastructures.eu:8020/user/INSPIRE/smalldata	hdfs://node1.hadoop.research-infrastructures.eu:8020/tmp/out		5 				Indexing by John in /user/INSPIRE/smalldata/texts
public class TestIndexerService {

	private static 	boolean destroyWSResources 		= false;		// whether you want the WS resource of the job to be destroyed in the end
	private static	long 	pollPeriodMilliSeconds	= 10000;	// milliseconds between polling status of indexer job
	private static  String	owner					= "TestIndexerServiceClient";

	
	public static void main(String[] args) throws Exception {

			
		try {

			if(args.length<5){
				System.err.println("Usage:   java org.gcube.execution.indexerservice.tests.TestIndexerService <indexer factory address> <gcube scope> <input location> <output location> <shards number> <optional job name in >=0 words >");
				System.err.println("Example: java org.gcube.execution.indexerservice.tests.TestIndexerService http://jazzman.di.uoa.gr:8081/wsrf/services/gcube/execution/indexerservice/IndexerServiceFactory /d4science.research-infrastructures.eu/INSPIRE  hdfs://node1.hadoop.research-infrastructures.eu:8020/user/INSPIRE/smalldata/ hdfs://node1.hadoop.research-infrastructures.eu:8020/tmp/output 5  An indexing on smalldata, Friday night");
				System.err.println("Example: java org.gcube.execution.indexerservice.tests.TestIndexerService http://jazzman.di.uoa.gr:8081/wsrf/services/gcube/execution/indexerservice/IndexerServiceFactory /gcube/devNext  hdfs:///user/INSPIRE/smalldata/ hdfs:///tmp/output 5  An indexing on smalldata devNext scope, Friday night");
				System.exit(1);
			}
			
			String jobName="";
			for(int i=5; i<args.length; i++)
				jobName+=args[i]+" ";
			jobName = jobName.trim();
			
			System.out.println("\nTestIndexerService client started");
			System.out.println("Client started with arguments: ");
			System.out.println("Indexer factory:  " + args[0] );
			System.out.println("Scope:            " + args[1] );
			System.out.println("Input:            " + args[2] );
			System.out.println("Output:           " + args[3] );
			System.out.println("Shard Number:     " + args[4] );
			System.out.println("jobName:          " + jobName );

			System.out.println("\nGetting Indexer Factory stub");
			EndpointReferenceType factoryEPR = new EndpointReferenceType(new AttributedURI(args[0]));
			IndexerServiceFactoryPortType stub1 = new IndexerServiceFactoryServiceAddressingLocator().getIndexerServiceFactoryPortTypePort(factoryEPR);
			stub1 = GCUBERemotePortTypeContext.getProxy(stub1,GCUBEScope.getScope(args[1].trim()));
			
			///--->prepare arguments
			System.out.println("Preparing Indexer arguments");
			Submit sub=new Submit();
			
			//input location
			sub.setInputLocation(args[2]);
			
			//output location
			sub.setOutputLocation(args[3]);
			
			//number of shards
			sub.setShardsNumber( Integer.parseInt( args[4]));
			
			//owner name
			sub.setOwner(owner);
			
			//job name
			sub.setJobName(jobName);
			
			System.out.println("Calling submit() for Indexing job");
			SubmitResponse 			response 	= 	stub1.submit(sub);
			EndpointReferenceType 	resourceEpr =	response.getEndpointReference();  
			
			IndexerServicePortType stub2 = new  IndexerServiceAddressingLocator().getIndexerServicePortTypePort(resourceEpr);
			stub2=GCUBERemotePortTypeContext.getProxy(stub2,GCUBEScope.getScope(args[1]));

			//call status() until completion
			System.out.println("Calling status() until completion\n");
			StatusResponseType status;
			do{

				status= stub2.status( new VOID() );
				System.out.println("Description:    " + status.getStatusDescription());
				System.out.println("Last poll date: " + status.getLastPollDate() );
				System.out.println("");
				Thread.sleep( pollPeriodMilliSeconds );

				System.out.println("endpoint: " + stub2.jobInfo(new VOID()).getEngineUrl() +" owner: " +  stub2.jobInfo(new VOID()).getOwner());
				
			}while( status.isCompleted()==false );
			
			//delete WS-resource
			if(destroyWSResources==true)
				stub2.destroy( new Destroy() );
			
			//print details retrieved from status()
			System.out.println("");
			System.out.println("Indexing Job has finished:");
			System.out.println("-----------------------------------------------------");
			System.out.println("Job Name:        " +     status.getJobName());
			System.out.println("Description:     " +     status.getStatusDescription());
			System.out.println("Input:			 " + 	 status.getInputLocation() );
			System.out.println("Output:          " +     status.getOutputLocation());
			System.out.println("Submited:        " +	 status.getSubmitDate());
			System.out.println("Last Poll:       " +	 status.getLastPollDate());
			System.out.println("Error:           " +	 status.getError());
			System.out.println("ErrorDetails:    " + 	 status.getErrorDetails());
			System.out.println("output ssid: 	 " + 	 status.getOutputArchiveStorageSystemId());
			System.out.println("stdout ssid: 	 " + 	 status.getStdOutStorageSystemId() );
			System.out.println("stderr ssid: 	 " + 	 status.getStdErrStorageSystemId() );
			
		}catch(Exception ex){
			ex.printStackTrace();
		}

	}
}
