/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.tcp;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.mirror.IMirror;
import gr.uoa.di.madgik.grs.proxy.tcp.mirror.TCPWriterMirror;
import gr.uoa.di.madgik.grs.registry.GRSRegistry;
import java.io.BufferedInputStream;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPConnectionHandler
implements ITCPConnectionManagerEntry {
    private static Logger logger = Logger.getLogger(TCPConnectionHandler.class.getName());

    public ITCPConnectionManagerEntry.NamedEntry GetName() {
        return ITCPConnectionManagerEntry.NamedEntry.gRS2;
    }

    public void HandleConnection(Socket socket) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not open object input stream from socket", e);
        }
        boolean success = false;
        String key = null;
        try {
            IMirror mirror;
            key = ois.readUTF();
            IBuffer buffer = GRSRegistry.Registry.getBuffer(key);
            if (buffer != null && (mirror = buffer.getMirror()) != null && mirror instanceof TCPWriterMirror) {
                if (((TCPWriterMirror)mirror).getState() != Thread.State.NEW) {
                    throw new GRS2ProxyMirrorInvalidOperationException("Mirroring already initiated");
                }
                ((TCPWriterMirror)mirror).setSocket(socket);
                ((TCPWriterMirror)mirror).setKey(key);
                ((TCPWriterMirror)mirror).setInputStream(ois);
                ((TCPWriterMirror)mirror).handle();
                success = true;
            }
        }
        catch (Exception ex) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Could not handle incoming mirroring request for key " + key, ex);
            }
            success = false;
        }
        if (!success) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

