/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.record;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;

public abstract class RecordDefinition {
    protected FieldDefinition[] Fields = null;
    protected IBuffer.TransportDirective directive = IBuffer.TransportDirective.Inherit;

    public RecordDefinition() {
        this.Fields = new FieldDefinition[0];
    }

    public RecordDefinition(FieldDefinition[] fieldDefinitions) {
        this.Fields = fieldDefinitions;
    }

    public void copyFrom(RecordDefinition other) throws GRS2RecordSerializationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        other.deflate(new DataOutputStream(out));
        this.inflate(new DataInputStream(new ByteArrayInputStream(out.toByteArray())));
    }

    public FieldDefinition getDefinition(int index) {
        return this.Fields[index];
    }

    public int getDefinition(String name) {
        for (int i = 0; i < this.Fields.length; ++i) {
            if (!this.Fields[i].getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public int getDefinitionSize() {
        return this.Fields.length;
    }

    public void setTransportDirective(IBuffer.TransportDirective directive) {
        this.directive = directive;
    }

    public IBuffer.TransportDirective getTransportDirective() {
        return this.directive;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RecordDefinition)) {
            return false;
        }
        if (this.Fields.length != ((RecordDefinition)obj).Fields.length) {
            return false;
        }
        if (!this.directive.equals((Object)((RecordDefinition)obj).directive)) {
            return false;
        }
        for (FieldDefinition thisField : this.Fields) {
            boolean found = false;
            for (FieldDefinition otherField : ((RecordDefinition)obj).Fields) {
                if (!thisField.equals(otherField)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return this.extendEquals(obj);
    }

    public abstract boolean extendEquals(Object var1);

    public void deflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeUTF(this.directive.toString());
            out.writeInt(this.Fields.length);
            for (FieldDefinition def : this.Fields) {
                out.writeUTF(def.getClass().getName());
                def.deflate(out);
            }
            this.extendDeflate(out);
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("Could not complete marshalling of definition", ex);
        }
    }

    public abstract void extendDeflate(DataOutput var1) throws GRS2RecordSerializationException;

    public void inflate(DataInput in) throws GRS2RecordSerializationException {
        try {
            this.directive = IBuffer.TransportDirective.valueOf(in.readUTF());
            int fieldsLength = in.readInt();
            this.Fields = new FieldDefinition[fieldsLength];
            for (int i = 0; i < fieldsLength; ++i) {
                String fieldDefType = in.readUTF();
                FieldDefinition def = (FieldDefinition)Class.forName(fieldDefType).newInstance();
                def.inflate(in);
                this.Fields[i] = def;
            }
            this.extendInflate(in);
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("Could not complete unmarshalling of definition", ex);
        }
    }

    public abstract void extendInflate(DataInput var1) throws GRS2RecordSerializationException;
}

