/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.record;

import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorException;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorProtocolErrorException;
import gr.uoa.di.madgik.grs.proxy.mirror.IMirror;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.IPumpable;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public abstract class Record
implements IPumpable {
    private int definitionIndex = -1;
    private IBuffer buffer = null;
    private long id = -1L;
    private Field[] fields = null;
    private boolean defaultField = false;
    private boolean remoteCopy = false;
    private IBuffer hiddenBuffer = null;
    private long hiddenId = -1L;
    private int hiddenDefinitionIndex = -1;
    private boolean hasBeenHidden = false;

    public long getID() {
        return this.id;
    }

    public RecordDefinition getDefinition() throws GRS2RecordDefinitionException, GRS2BufferException {
        if (this.buffer == null) {
            throw new GRS2RecordDefinitionException("Record not properly bind to buffer");
        }
        if (this.definitionIndex < 0 || this.definitionIndex >= this.buffer.getRecordDefinitions().length) {
            throw new GRS2RecordDefinitionException("Definition index not properly initialized");
        }
        return this.buffer.getRecordDefinitions()[this.definitionIndex];
    }

    public int getDefinitionIndex() {
        return this.definitionIndex;
    }

    public void setDefinitionIndex(int index) {
        this.definitionIndex = index;
    }

    public void setFields(Field[] fields) {
        this.fields = fields;
        this.defaultField = false;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public Field getField(String name) throws GRS2RecordDefinitionException, GRS2BufferException {
        int index = this.getDefinition().getDefinition(name);
        if (index < 0 || index >= this.fields.length) {
            return null;
        }
        return this.fields[index];
    }

    public Field getField(int index) {
        if (index < 0 || index >= this.fields.length) {
            return null;
        }
        return this.fields[index];
    }

    public void bind(IBuffer buffer) throws GRS2BufferException, GRS2RecordDefinitionException {
        this.buffer = buffer;
        if (this.definitionIndex < 0 && this.buffer.getRecordDefinitions().length == 1) {
            this.definitionIndex = 0;
        } else if (this.definitionIndex < 0 && this.buffer.getRecordDefinitions().length > 1) {
            throw new GRS2RecordDefinitionException("No definition index defined and default value cannot be infered");
        }
        if (this.definitionIndex < 0 || this.definitionIndex >= this.buffer.getRecordDefinitions().length) {
            throw new GRS2RecordDefinitionException("No definition found for index " + this.definitionIndex);
        }
        this.id = this.buffer.totalRecords() - 1L;
        if (this.fields == null) {
            this.fields = new Field[0];
            this.defaultField = true;
        }
        if (this.getDefinition().getDefinitionSize() != this.fields.length) {
            throw new GRS2RecordDefinitionException("Definition does not match record");
        }
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].setDefinitionIndex(i);
            this.fields[i].bind(this);
        }
        this.hiddenBuffer = this.buffer;
        this.hiddenId = this.id;
        this.hiddenDefinitionIndex = this.definitionIndex;
    }

    public void unbind() {
        this.buffer = null;
        this.id = -1L;
        this.definitionIndex = -1;
        if (this.defaultField) {
            this.fields = null;
            this.defaultField = false;
        }
    }

    public void hide() {
        this.hasBeenHidden = true;
        this.hiddenBuffer = this.buffer;
        this.buffer = null;
        this.hiddenDefinitionIndex = this.definitionIndex;
        this.definitionIndex = -1;
        this.hiddenId = this.id;
        this.id = -1L;
    }

    public void show() {
        this.buffer = this.hiddenBuffer;
        this.definitionIndex = this.hiddenDefinitionIndex;
        this.id = this.hiddenId;
    }

    public boolean isBoundTo(IBuffer buffer) {
        return this.buffer == buffer;
    }

    public void prebind(IBuffer buffer) {
        this.buffer = buffer;
    }

    public void markActivity() {
        this.buffer.markSimulateActivity();
    }

    public void setRemoteCopy(boolean remoteCopy) {
        this.remoteCopy = remoteCopy;
        if (this.fields != null) {
            for (Field f : this.fields) {
                f.setRemoteCopy(remoteCopy);
            }
        }
    }

    public boolean isRemoteCopy() {
        return this.remoteCopy;
    }

    public IBuffer.TransportDirective resolveTransportDirective() throws GRS2RecordDefinitionException, GRS2BufferException {
        RecordDefinition def = this.getDefinition();
        switch (def.getTransportDirective()) {
            case Full: 
            case Partial: {
                return def.getTransportDirective();
            }
            case Inherit: {
                return this.buffer.resolveTransportDirective();
            }
        }
        return IBuffer.TransportDirective.Full;
    }

    @Override
    public final void deflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeInt(this.definitionIndex);
            out.writeLong(this.id);
            out.writeBoolean(this.remoteCopy);
            this.extendDeflate(out);
            for (Field f : this.fields) {
                out.writeBoolean(true);
                out.writeUTF(f.getClass().getName());
                f.deflate(out);
            }
            out.writeBoolean(false);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("unable to deflate record", e);
        }
    }

    public final void send(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeInt(this.definitionIndex);
            out.writeLong(this.id);
            out.writeBoolean(this.remoteCopy);
            this.extendSend(out);
            for (Field f : this.fields) {
                out.writeBoolean(true);
                out.writeUTF(f.getClass().getName());
                f.send(out);
            }
            out.writeBoolean(false);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("unable to marshal record", e);
        }
    }

    @Override
    public final void inflate(DataInput in) throws GRS2RecordSerializationException {
        this.inflate(in, false);
    }

    @Override
    public final void inflate(DataInput in, boolean reset) throws GRS2RecordSerializationException {
        try {
            this.definitionIndex = in.readInt();
            this.id = in.readLong();
            this.remoteCopy = in.readBoolean();
            if (reset) {
                this.remoteCopy = false;
            }
            this.extendInflate(in, reset);
            ArrayList<Field> fs = new ArrayList<Field>();
            while (in.readBoolean()) {
                String fieldType = in.readUTF();
                Field f = (Field)Class.forName(fieldType).newInstance();
                f.prebind(this);
                f.inflate(in, reset);
                fs.add(f);
            }
            this.fields = fs.toArray(new Field[0]);
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to marshal record", e);
        }
    }

    public final void receive(DataInput in) throws GRS2RecordSerializationException {
        try {
            this.definitionIndex = in.readInt();
            this.id = in.readLong();
            this.remoteCopy = in.readBoolean();
            this.extendReceive(in);
            ArrayList<Field> fs = new ArrayList<Field>();
            while (in.readBoolean()) {
                String fieldType = in.readUTF();
                Field f = (Field)Class.forName(fieldType).newInstance();
                f.prebind(this);
                f.receive(in);
                fs.add(f);
            }
            this.fields = fs.toArray(new Field[0]);
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to marshal record", e);
        }
    }

    public final void makeLocal() {
        this.extendMakeLocal();
        for (Field f : this.fields) {
            f.makeLocal();
        }
        this.remoteCopy = false;
    }

    public abstract void extendSend(DataOutput var1) throws GRS2RecordSerializationException;

    public abstract void extendReceive(DataInput var1) throws GRS2RecordSerializationException;

    public abstract void extendDeflate(DataOutput var1) throws GRS2RecordSerializationException;

    public abstract void extendInflate(DataInput var1, boolean var2) throws GRS2RecordSerializationException;

    protected abstract void extendMakeLocal();

    public void dispose() {
        if (this.hasBeenHidden) {
            return;
        }
        this.extendDispose();
        if (this.fields != null) {
            for (Field f : this.fields) {
                f.dispose();
            }
        }
        this.fields = null;
        this.definitionIndex = -1;
        this.buffer = null;
    }

    public abstract void extendDispose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPartial(IBuffer.TransportOverride override, int fieldIndex) throws GRS2ProxyMirrorException {
        Object notify;
        IMirror mirror = this.buffer.getMirror();
        if (mirror == null) {
            return;
        }
        Object object = notify = new Object();
        synchronized (object) {
            long period = mirror.requestPartial(this.id, fieldIndex, override, notify);
            do {
                try {
                    notify.wait(period);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            } while (!mirror.pollPartial(this.id, fieldIndex));
        }
    }

    public void makeAvailable() throws GRS2RecordDefinitionException, GRS2ProxyMirrorException, GRS2BufferException {
        for (int i = 0; i < this.fields.length; ++i) {
            this.makeAvailable(i);
        }
    }

    public void makeAvailable(String fieldName) throws GRS2RecordDefinitionException, GRS2ProxyMirrorException, GRS2BufferException {
        this.makeAvailable(IBuffer.TransportOverride.Override, this.getDefinition().getDefinition(fieldName));
    }

    public void makeAvailable(int fieldIndex) throws GRS2RecordDefinitionException, GRS2ProxyMirrorException, GRS2BufferException {
        this.makeAvailable(IBuffer.TransportOverride.Override, fieldIndex);
    }

    private void makeAvailable(IBuffer.TransportOverride override, int fieldIndex) throws GRS2ProxyMirrorException, GRS2RecordDefinitionException, GRS2BufferException {
        if (fieldIndex < 0 || fieldIndex >= this.fields.length) {
            throw new GRS2RecordDefinitionException("Provided field index is not available");
        }
        Field f = this.fields[fieldIndex];
        if (f.isAvailable()) {
            return;
        }
        IBuffer.TransportDirective dir = f.resolveTransportDirective();
        if (dir == IBuffer.TransportDirective.Full) {
            return;
        }
        if (dir == IBuffer.TransportDirective.Inherit) {
            throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
        }
        this.requestPartial(override, fieldIndex);
    }
}

