/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.tcp.mirror;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorDisposedException;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorProtocolErrorException;
import gr.uoa.di.madgik.grs.proxy.mirror.IMirror;
import gr.uoa.di.madgik.grs.proxy.mirror.PartialRequestEntry;
import gr.uoa.di.madgik.grs.proxy.mirror.PartialRequestManager;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPReaderMirror
extends Thread
implements IMirror {
    private static Logger logger = Logger.getLogger(TCPReaderMirror.class.getName());
    public static final long LongMirrorPeriod = 100L;
    public static final long ShortMirrorPeriod = 50L;
    private String hostname = null;
    private int port = -1;
    private String key = null;
    private boolean overrideBufferCapacity = false;
    private int bufferCapacity = -1;
    private IMirror.MirroringState state = IMirror.MirroringState.Open;
    private Socket socket = null;
    private DataInputStream in;
    private DataOutputStream out;
    private IBuffer buffer = null;
    private GRS2ProxyMirrorProtocolErrorException initializationException = null;
    private final Object initializationLock = new Object();
    private boolean initializationCompleted = false;
    private long lastIterationRecords = 0L;
    private long lastPartialFields = 0L;
    private PartialRequestManager manager = new PartialRequestManager();

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void overrideBufferCapacity(int capacity) {
        this.overrideBufferCapacity = true;
        this.bufferCapacity = capacity;
    }

    @Override
    public IBuffer getBuffer() {
        return this.buffer;
    }

    public void handle() throws GRS2ProxyMirrorInvalidOperationException {
        if (this.state != IMirror.MirroringState.Open) {
            throw new GRS2ProxyMirrorInvalidOperationException("Invalid mirroring state");
        }
        if (this.key == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("No key defined");
        }
        if (this.hostname == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("No hostname defined");
        }
        if (this.port <= 0) {
            throw new GRS2ProxyMirrorInvalidOperationException("No port defined");
        }
        this.setDaemon(true);
        this.setName("reader mirror (" + this.key + ")");
        this.start();
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean purge) {
        if (this.state == IMirror.MirroringState.Purged) {
            return;
        }
        this.state = purge ? IMirror.MirroringState.Purged : IMirror.MirroringState.Close;
        if (purge) {
            try {
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.buffer != null) {
                    logger.log(Level.FINER, "Disposing buffer");
                }
                this.buffer.dispose();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.manager != null) {
                    this.manager.dispose();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitInitialization() {
        Object object = this.initializationLock;
        synchronized (object) {
            while (!this.initializationCompleted) {
                try {
                    this.initializationLock.wait();
                }
                catch (Exception exception) {}
            }
            return this.initializationException == null;
            {
            }
        }
    }

    public GRS2ProxyMirrorProtocolErrorException getInitializationError() {
        return this.initializationException;
    }

    @Override
    public boolean pollPartial(long recordIndex, int fieldIndex) throws GRS2ProxyMirrorDisposedException {
        if (this.state != IMirror.MirroringState.Open) {
            return true;
        }
        if (this.manager == null) {
            return true;
        }
        return !this.manager.requestExists(recordIndex, fieldIndex);
    }

    @Override
    public long requestPartial(long recordIndex, int fieldIndex, IBuffer.TransportOverride override, Object notify) throws GRS2ProxyMirrorInvalidOperationException, GRS2ProxyMirrorDisposedException {
        if (this.state != IMirror.MirroringState.Open) {
            throw new GRS2ProxyMirrorInvalidOperationException("Mirroring is closing. No additional request accepted");
        }
        if (this.manager == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("Mirroring is closing. No additional request accepted");
        }
        this.manager.block(recordIndex, fieldIndex, override, notify);
        return 50L;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void retrievePartialRequests() throws IOException, GRS2Exception {
        while (this.in.readBoolean()) {
            long recordIndex = this.in.readLong();
            int fieldIndex = this.in.readInt();
            IBuffer.TransportOverride override = IBuffer.TransportOverride.valueOf(this.in.readUTF());
            Record rec = this.buffer.locate(recordIndex);
            if (rec == null) {
                throw new GRS2ProxyMirrorInvalidOperationException("Invalid record index provided");
            }
            Field[] fields = rec.getFields();
            if (fields == null) {
                throw new GRS2ProxyMirrorInvalidOperationException("No fields to update");
            }
            if (fieldIndex < 0 || fieldIndex >= fields.length) {
                throw new GRS2ProxyMirrorInvalidOperationException("Invalid field index provided");
            }
            Field f = fields[fieldIndex];
            f.extendReceive(this.in, override);
            this.manager.unblock(recordIndex, fieldIndex);
        }
    }

    private void retrieveRecords() throws IOException, GRS2Exception, InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.lastIterationRecords = 0L;
        while (this.in.readBoolean()) {
            String recordType = this.in.readUTF();
            Record rec = (Record)Class.forName(recordType).newInstance();
            rec.prebind(this.buffer);
            rec.receive(this.in);
            rec.setRemoteCopy(true);
            this.buffer.put(rec);
            ++this.lastIterationRecords;
        }
    }

    private void retrieveEvents() throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, GRS2RecordSerializationException, GRS2BufferException {
        while (this.in.readBoolean()) {
            String eventType = this.in.readUTF();
            BufferEvent ev = (BufferEvent)Class.forName(eventType).newInstance();
            ev.inflate(this.in);
            this.buffer.emit(ev);
        }
    }

    private void flushEvents() throws IOException, GRS2BufferException, GRS2RecordSerializationException {
        BufferEvent event;
        while ((event = this.buffer.receive(BufferEvent.EventSource.Reader)) != null) {
            this.out.writeBoolean(true);
            this.out.writeUTF(event.getClass().getName());
            event.deflate(this.out);
        }
        this.out.writeBoolean(false);
        this.out.flush();
    }

    private boolean flushRequest() throws IOException {
        boolean doDispose = false;
        int needed = 0;
        try {
            if (this.state != IMirror.MirroringState.Open || this.buffer.getStatus() == IBuffer.Status.Dispose) {
                doDispose = true;
            } else {
                needed = this.buffer.getCapacity() - this.buffer.availableRecords();
            }
        }
        catch (Exception ex) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Could not check for needed state flushing info. Setting to dispose", ex);
            }
            doDispose = true;
        }
        this.out.writeBoolean(doDispose);
        this.out.writeInt(needed);
        boolean simulateActivity = this.buffer.getSimulateActivity();
        this.out.writeBoolean(simulateActivity);
        if (this.manager == null || doDispose) {
            this.out.writeInt(0);
        } else {
            PartialRequestEntry[] entries = this.manager.getEntries();
            this.out.writeInt(entries.length);
            this.lastPartialFields = entries.length;
            for (PartialRequestEntry entry : entries) {
                this.out.writeLong(entry.getRecordIndex());
                this.out.writeInt(entry.getFieldIndex());
                this.out.writeUTF(entry.getOverride().toString());
            }
        }
        this.out.flush();
        logger.log(Level.FINEST, "Flush request doDispose=" + doDispose + " mirroring state=" + (Object)((Object)this.state));
        return doDispose;
    }

    private void connectToWriter() throws UnknownHostException, IOException {
        this.socket = new Socket(this.hostname, this.port);
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.out.writeUTF(ITCPConnectionManagerEntry.NamedEntry.gRS2.toString());
        this.out.writeUTF(this.key);
        this.out.flush();
    }

    private void initializeBuffer() throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, GRS2Exception {
        String bufferType = this.in.readUTF();
        int capacity = this.in.readInt();
        int concurrentPartial = this.in.readInt();
        long inactivityTimeout = this.in.readLong();
        TimeUnit InactivityTimeUnit = TimeUnit.valueOf(this.in.readUTF());
        IBuffer.TransportDirective transportDirective = IBuffer.TransportDirective.valueOf(this.in.readUTF());
        int recordDefinitionsLength = this.in.readInt();
        RecordDefinition[] definitions = new RecordDefinition[recordDefinitionsLength];
        for (int i = 0; i < recordDefinitionsLength; ++i) {
            String recordDefType = this.in.readUTF();
            RecordDefinition def = (RecordDefinition)Class.forName(recordDefType).newInstance();
            def.inflate(this.in);
            definitions[i] = def;
        }
        this.buffer = (IBuffer)Class.forName(bufferType).newInstance();
        if (this.overrideBufferCapacity && this.bufferCapacity < capacity) {
            this.buffer.setCapacity(this.bufferCapacity);
        } else {
            this.buffer.setCapacity(capacity);
        }
        this.buffer.setConcurrentPartialCapacity(concurrentPartial);
        this.buffer.setInactivityTimeout(inactivityTimeout);
        this.buffer.setInactivityTimeUnit(InactivityTimeUnit);
        this.buffer.setTransportDirective(transportDirective);
        this.buffer.setRecordDefinitions(definitions);
        this.buffer.initialize();
    }
}

