/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy;

import gr.uoa.di.madgik.grs.proxy.GRS2ProxyException;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidArgumentException;
import gr.uoa.di.madgik.grs.proxy.IReaderProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalReaderProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalStoreReaderProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPReaderProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreReaderProxy;
import java.net.URI;

public class ProxyFactory {
    public static IReaderProxy getProxy(URI locator) throws GRS2ProxyException {
        IReaderProxy proxy = null;
        if (LocalReaderProxy.isOfType(locator)) {
            proxy = new LocalReaderProxy();
        } else if (TCPReaderProxy.isOfType(locator)) {
            proxy = new TCPReaderProxy();
        } else if (LocalStoreReaderProxy.isOfType(locator)) {
            proxy = new LocalStoreReaderProxy();
        } else if (TCPStoreReaderProxy.isOfType(locator)) {
            proxy = new TCPStoreReaderProxy();
        }
        if (proxy == null) {
            throw new GRS2ProxyInvalidArgumentException("Could not recognize provided locator");
        }
        proxy.fromLocator(locator);
        return proxy;
    }
}

