/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.bridge.xml;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.bridge.GCubeRecord;
import gr.uoa.di.madgik.grs.bridge.exceptions.GCubeBridgeException;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;

public class GCubeXMLRecord
extends GCubeRecord {
    public static final String DefaultValue = "none";
    private String id = "none";
    private String collection = "none";
    private String rank = "none";

    public GCubeXMLRecord() {
        this.setFields(new Field[]{new StringField()});
    }

    public GCubeXMLRecord(String payload) {
        this.setFields(new Field[]{new StringField(payload)});
    }

    public GCubeXMLRecord(String id, String collection) {
        this.setId(id);
        this.setCollection(collection);
        this.setFields(new Field[]{new StringField()});
    }

    public GCubeXMLRecord(String id, String collection, String payload) {
        this.setId(id);
        this.setCollection(collection);
        this.setFields(new Field[]{new StringField(payload)});
    }

    public GCubeXMLRecord(String id, String collection, String rank, String payload) {
        this.setId(id);
        this.setCollection(collection);
        this.setRank(rank);
        this.setFields(new Field[]{new StringField(payload)});
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    public String getRank() {
        return this.rank;
    }

    public void setPayload(String payload) throws GCubeBridgeException {
        try {
            this.getField("payload").setPayload(payload);
        }
        catch (GRS2Exception e) {
            throw new GCubeBridgeException("could not set the record's payload", e);
        }
    }

    public String getPayload() throws GCubeBridgeException {
        try {
            return this.getField("payload").getPayload();
        }
        catch (GRS2Exception e) {
            throw new GCubeBridgeException("could not retrieve the record's payload", e);
        }
    }

    @Override
    public String downgrade() throws GCubeBridgeException {
        String xml = this.getPayload();
        StringBuilder validXML = new StringBuilder("<RSRecord");
        validXML.append(" DocID=\"" + this.id + "\"");
        validXML.append(" CollID=\"" + this.collection + "\"");
        validXML.append(" RankID=\"" + this.rank + "\"");
        if (xml == null || xml.trim().length() == 0) {
            validXML.append("/>");
        } else {
            validXML.append(">");
            if (xml != null) {
                validXML.append(xml);
            }
            validXML.append("</RSRecord>");
        }
        return validXML.toString();
    }

    @Override
    public void upgrade(String record) throws GCubeBridgeException {
        if (!record.trim().startsWith("<RSRecord") || !record.trim().endsWith("</RSRecord>") && !record.trim().endsWith("/>")) {
            throw new GCubeBridgeException("record is not valid");
        }
        String payload = null;
        String attrsS = null;
        Hashtable<String, String> attrs = new Hashtable<String, String>();
        if (record.endsWith("/>")) {
            payload = null;
            attrsS = record.substring("<".length() + "RSRecord".length(), record.length() - "/>".length());
        } else {
            payload = record.substring(record.indexOf(">") + ">".length(), record.lastIndexOf("</RSRecord>"));
            attrsS = "<".length() + "RSRecord".length() <= record.indexOf(">") - ">".length() ? record.substring("<".length() + "RSRecord".length(), record.indexOf(">") - ">".length()) : "";
        }
        String[] attrsSA = attrsS.split("\"");
        try {
            for (int i = 0; i < attrsSA.length - 1; i += 2) {
                try {
                    attrs.put(attrsSA[i].trim().substring(0, attrsSA[i].trim().lastIndexOf("=")), attrsSA[i + 1]);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setPayload(payload != null ? payload : "");
        if (attrs.containsKey("DocID")) {
            this.id = (String)attrs.get("DocID");
        }
        if (attrs.containsKey("CollID")) {
            this.collection = (String)attrs.get("CollID");
        }
        if (attrs.containsKey("RankID")) {
            this.rank = (String)attrs.get("RankID");
        }
    }

    public StringField getField(String name) throws GRS2RecordDefinitionException, GRS2BufferException {
        return (StringField)super.getField(name);
    }

    public void extendSend(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeUTF(this.id);
            out.writeUTF(this.collection);
            out.writeUTF(this.rank);
        }
        catch (IOException ex) {
            throw new GRS2RecordSerializationException("Could not send record's contents", (Throwable)ex);
        }
    }

    public void extendReceive(DataInput in) throws GRS2RecordSerializationException {
        try {
            this.id = in.readUTF();
            this.collection = in.readUTF();
            this.rank = in.readUTF();
        }
        catch (IOException ex) {
            throw new GRS2RecordSerializationException("Could not receive record's contents", (Throwable)ex);
        }
    }

    public void extendDeflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeUTF(this.id);
            out.writeUTF(this.collection);
            out.writeUTF(this.rank);
        }
        catch (IOException ex) {
            throw new GRS2RecordSerializationException("Could not deflate record", (Throwable)ex);
        }
    }

    public void extendInflate(DataInput in, boolean reset) throws GRS2RecordSerializationException {
        try {
            this.id = in.readUTF();
            this.collection = in.readUTF();
            this.rank = in.readUTF();
        }
        catch (IOException ex) {
            throw new GRS2RecordSerializationException("Could not inflate record", (Throwable)ex);
        }
    }

    protected void extendMakeLocal() {
    }

    public void extendDispose() {
        this.id = null;
        this.collection = null;
        this.rank = null;
    }
}

