/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.writer;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.BufferFactory;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferInvalidOperationException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyException;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.registry.GRSRegistry;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import gr.uoa.di.madgik.grs.utils.ProgressiveTimeoutGenerator;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.GRS2WriterInvalidArgumentException;
import gr.uoa.di.madgik.grs.writer.GRS2WriterInvalidOperationException;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecordWriter<T extends Record>
implements IRecordWriter<T> {
    private static Logger logger = Logger.getLogger(RecordWriter.class.getName());
    public static int DefaultBufferCapacity = 50;
    public static int DefaultConcurrentPartialCapacity = 1;
    public static float DefaultThreshold = 0.5f;
    public static float DefaultMirrorBufferFactor = 0.5f;
    public static long DefaultInactivityTimeout = 300L;
    public static TimeUnit DefaultInactivityTimeUnit = TimeUnit.SECONDS;
    private IBuffer buffer = null;
    private URI locator = null;
    private Object immediateNotificationObject = null;

    public RecordWriter(IWriterProxy proxy, RecordDefinition[] definitions) throws GRS2WriterException {
        try {
            logger.log(Level.FINE, "Initializing record writer");
            this.buffer = BufferFactory.getBuffer();
            this.buffer.setRecordDefinitions(definitions);
            this.buffer.setCapacity(DefaultBufferCapacity);
            this.buffer.setConcurrentPartialCapacity(DefaultConcurrentPartialCapacity);
            this.buffer.setMirrorBuffer((int)Math.ceil((float)DefaultBufferCapacity * DefaultMirrorBufferFactor));
            this.buffer.setInactivityTimeout(DefaultInactivityTimeout);
            this.buffer.setInactivityTimeUnit(DefaultInactivityTimeUnit);
            this.immediateNotificationObject = this.buffer.getWriterImmediateNotificationObject();
            this.buffer.initialize();
            this.initLocator(proxy);
        }
        catch (GRS2Exception ex) {
            throw new GRS2WriterException("Could not initialize writer", ex);
        }
    }

    public RecordWriter(IWriterProxy proxy, RecordDefinition[] definitions, int capacity, int concurrentPartialCapacity, float mirrorSizeFactor) throws GRS2WriterException {
        try {
            logger.log(Level.FINE, "Initializing record writer");
            this.buffer = BufferFactory.getBuffer();
            this.buffer.setRecordDefinitions(definitions);
            this.buffer.setCapacity(capacity);
            this.buffer.setConcurrentPartialCapacity(concurrentPartialCapacity);
            this.buffer.setMirrorBuffer((int)Math.ceil((float)capacity * mirrorSizeFactor));
            this.buffer.setInactivityTimeout(DefaultInactivityTimeout);
            this.buffer.setInactivityTimeUnit(DefaultInactivityTimeUnit);
            this.immediateNotificationObject = this.buffer.getWriterImmediateNotificationObject();
            this.buffer.initialize();
            this.initLocator(proxy);
        }
        catch (GRS2Exception ex) {
            throw new GRS2WriterException("Could not initialize writer", ex);
        }
    }

    public RecordWriter(IWriterProxy proxy, RecordDefinition[] definitions, int capacity, int concurrentPartialCapacity, float mirrorSizeFactor, long inactivityTimeout, TimeUnit inactivityTimeUnit) throws GRS2WriterException {
        try {
            logger.log(Level.FINE, "Initializing record writer");
            this.buffer = BufferFactory.getBuffer();
            this.buffer.setRecordDefinitions(definitions);
            this.buffer.setCapacity(capacity);
            this.buffer.setConcurrentPartialCapacity(concurrentPartialCapacity);
            this.buffer.setMirrorBuffer((int)Math.ceil((float)capacity * mirrorSizeFactor));
            this.buffer.setInactivityTimeout(inactivityTimeout);
            this.buffer.setInactivityTimeUnit(inactivityTimeUnit);
            this.immediateNotificationObject = this.buffer.getWriterImmediateNotificationObject();
            this.buffer.initialize();
            this.initLocator(proxy);
        }
        catch (GRS2Exception ex) {
            throw new GRS2WriterException("Could not initialize writer", ex);
        }
    }

    public RecordWriter(IWriterProxy proxy, IRecordReader reader) throws GRS2WriterException {
        try {
            logger.log(Level.FINE, "Initializing record writer");
            this.buffer = BufferFactory.getBuffer();
            RecordDefinition[] defs = new RecordDefinition[reader.getRecordDefinitions().length];
            int i = 0;
            for (RecordDefinition def : reader.getRecordDefinitions()) {
                defs[i] = (RecordDefinition)def.getClass().newInstance();
                defs[i].copyFrom(def);
                ++i;
            }
            this.buffer.setRecordDefinitions(defs);
            this.buffer.setCapacity(reader.getCapacity());
            this.buffer.setConcurrentPartialCapacity(reader.getConcurrentPartialCapacity());
            this.buffer.setMirrorBuffer((int)Math.ceil((float)DefaultBufferCapacity * DefaultMirrorBufferFactor));
            this.buffer.setInactivityTimeout(DefaultInactivityTimeout);
            this.buffer.setInactivityTimeUnit(DefaultInactivityTimeUnit);
            this.immediateNotificationObject = this.buffer.getWriterImmediateNotificationObject();
            this.buffer.initialize();
            this.initLocator(proxy);
        }
        catch (Exception ex) {
            throw new GRS2WriterException("Could not initialize writer", ex);
        }
    }

    public RecordWriter(IWriterProxy proxy, IRecordReader reader, int capacity, int concurrentPartialCapacity, float mirrorSizeFactor) throws GRS2WriterException {
        try {
            logger.log(Level.FINE, "Initializing record writer");
            this.buffer = BufferFactory.getBuffer();
            RecordDefinition[] defs = new RecordDefinition[reader.getRecordDefinitions().length];
            int i = 0;
            for (RecordDefinition def : reader.getRecordDefinitions()) {
                defs[i] = (RecordDefinition)def.getClass().newInstance();
                defs[i].copyFrom(def);
                ++i;
            }
            this.buffer.setRecordDefinitions(defs);
            this.buffer.setCapacity(capacity);
            this.buffer.setConcurrentPartialCapacity(concurrentPartialCapacity);
            this.buffer.setMirrorBuffer((int)Math.ceil((float)capacity * mirrorSizeFactor));
            this.buffer.setInactivityTimeout(DefaultInactivityTimeout);
            this.buffer.setInactivityTimeUnit(DefaultInactivityTimeUnit);
            this.immediateNotificationObject = this.buffer.getWriterImmediateNotificationObject();
            this.buffer.initialize();
            this.initLocator(proxy);
        }
        catch (Exception ex) {
            throw new GRS2WriterException("Could not initialize writer", ex);
        }
    }

    public RecordWriter(IWriterProxy proxy, IRecordReader reader, int capacity, int concurrentPartialCapacity, float mirrorSizeFactor, long inactivityTimeout, TimeUnit inactivityTimeUnit) throws GRS2WriterException {
        try {
            logger.log(Level.FINE, "Initializing record writer");
            this.buffer = BufferFactory.getBuffer();
            RecordDefinition[] defs = new RecordDefinition[reader.getRecordDefinitions().length];
            int i = 0;
            for (RecordDefinition def : reader.getRecordDefinitions()) {
                defs[i] = (RecordDefinition)def.getClass().newInstance();
                defs[i].copyFrom(def);
                ++i;
            }
            this.buffer.setRecordDefinitions(defs);
            this.buffer.setCapacity(capacity);
            this.buffer.setConcurrentPartialCapacity(concurrentPartialCapacity);
            this.buffer.setMirrorBuffer((int)Math.ceil((float)capacity * mirrorSizeFactor));
            this.buffer.setInactivityTimeout(inactivityTimeout);
            this.buffer.setInactivityTimeUnit(inactivityTimeUnit);
            this.immediateNotificationObject = this.buffer.getWriterImmediateNotificationObject();
            this.buffer.initialize();
            this.initLocator(proxy);
        }
        catch (Exception ex) {
            throw new GRS2WriterException("Could not initialize writer", ex);
        }
    }

    @Override
    public void setBufferStore(IBufferStore store) throws GRS2WriterException {
        try {
            this.buffer.setBufferStore(store);
        }
        catch (GRS2Exception ex) {
            throw new GRS2WriterException("Could not set buffer store", ex);
        }
    }

    @Override
    public int getCapacity() throws GRS2WriterException {
        try {
            return this.buffer.getCapacity();
        }
        catch (GRS2Exception ex) {
            throw new GRS2WriterException("unable to retrieve capacity", ex);
        }
    }

    @Override
    public URI getLocator() throws GRS2WriterException {
        if (this.locator == null) {
            throw new GRS2WriterInvalidOperationException("Writer not properly initialized. No locator available");
        }
        return this.locator;
    }

    @Override
    public synchronized IBuffer.Status getStatus() {
        return this.buffer.getStatus();
    }

    @Override
    public synchronized int availableRecords() throws GRS2WriterException {
        try {
            return this.buffer.availableRecords();
        }
        catch (GRS2Exception ex) {
            throw new GRS2WriterException("Could not retrieve available number of records", ex);
        }
    }

    @Override
    public synchronized long totalRecords() throws GRS2WriterException {
        try {
            return this.buffer.totalRecords();
        }
        catch (GRS2Exception ex) {
            throw new GRS2WriterException("Could not retrieve total number of records", ex);
        }
    }

    @Override
    public synchronized boolean put(T record) throws GRS2WriterException {
        try {
            return this.buffer.put((Record)record);
        }
        catch (GRS2Exception ex) {
            throw new GRS2WriterException("Could not put record", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean put(T record, long timeout, TimeUnit unit) throws GRS2WriterException {
        try {
            boolean success = false;
            ProgressiveTimeoutGenerator ptf = new ProgressiveTimeoutGenerator(unit.toMillis(timeout));
            while (this.buffer.getStatus() == IBuffer.Status.Open && !(success = this.buffer.put((Record)record)) && ptf.hasNext()) {
                Object object = this.immediateNotificationObject;
                synchronized (object) {
                    try {
                        this.immediateNotificationObject.wait(ptf.next());
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            return success;
        }
        catch (GRS2Exception ex) {
            throw new GRS2WriterException("Could not put record", ex);
        }
    }

    private T doImport(T record, int newDefinitionIndex) throws GRS2Exception {
        ((Record)record).show();
        ((Record)record).makeAvailable();
        ((Record)record).unbind();
        ((Record)record).setDefinitionIndex(newDefinitionIndex);
        ((Record)record).makeLocal();
        return record;
    }

    @Override
    public boolean importRecord(T record) throws GRS2Exception {
        this.doImport(record, ((Record)record).getDefinitionIndex());
        return this.put(record);
    }

    @Override
    public boolean importRecord(T record, long timeout, TimeUnit unit) throws GRS2Exception {
        this.doImport(record, ((Record)record).getDefinitionIndex());
        return this.put(record, timeout, unit);
    }

    @Override
    public boolean importRecord(T record, int newDefinitionIndex) throws GRS2Exception {
        this.doImport(record, newDefinitionIndex);
        return this.put(record);
    }

    @Override
    public boolean importRecord(T record, int newDefinitionIndex, long timeout, TimeUnit unit) throws GRS2Exception {
        this.doImport(record, newDefinitionIndex);
        return this.put(record, timeout, unit);
    }

    @Override
    public synchronized void close() throws GRS2WriterException {
        try {
            this.buffer.close();
        }
        catch (GRS2Exception ex) {
            throw new GRS2WriterException("Could not close writer", ex);
        }
    }

    @Override
    public synchronized void dispose() {
        this.buffer.dispose();
        this.buffer = null;
    }

    @Override
    public synchronized void emit(BufferEvent event) throws GRS2WriterException, GRS2WriterInvalidArgumentException {
        if (event == null) {
            throw new GRS2WriterInvalidArgumentException("event cannot be null");
        }
        try {
            event.setSource(BufferEvent.EventSource.Writer);
            this.buffer.emit(event);
        }
        catch (GRS2BufferException e) {
            throw new GRS2WriterException("unable to emit event", e);
        }
    }

    @Override
    public synchronized BufferEvent receive() throws GRS2WriterException {
        try {
            return this.buffer.receive(BufferEvent.EventSource.Reader);
        }
        catch (GRS2BufferException e) {
            throw new GRS2WriterException("unable to receive event", e);
        }
    }

    private void initLocator(IWriterProxy proxy) throws GRS2BufferException, GRS2ProxyException {
        if (this.locator != null) {
            return;
        }
        if (this.buffer.getStatus() != IBuffer.Status.Open) {
            throw new GRS2BufferInvalidOperationException("Buffer is not open");
        }
        String key = GRSRegistry.Registry.add(this.buffer);
        this.buffer.setKey(key);
        proxy.setKey(key);
        this.buffer.setMirror(proxy.bind());
        this.locator = proxy.getLocator();
    }
}

