/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.record.field;

import gr.uoa.di.madgik.commons.utils.ZipUtils;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorProtocolErrorException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.URLFieldDefinition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class URLField
extends Field {
    private URL payload = null;
    private int marshaledSize = 0;
    private boolean marshaledCompleted = false;

    public URLField() {
    }

    public URLField(URL payload) {
        this.payload = payload;
    }

    public void setPayload(URL payload) {
        this.payload = payload;
    }

    public URL getPayload() {
        return this.payload;
    }

    @Override
    public URLFieldDefinition getFieldDefinition() throws GRS2RecordDefinitionException {
        if (!(super.getFieldDefinition() instanceof URLFieldDefinition)) {
            throw new GRS2RecordDefinitionException("Provided field definition is not of required type");
        }
        return (URLFieldDefinition)super.getFieldDefinition();
    }

    @Override
    public boolean isAvailable() {
        return this.marshaledCompleted || !this.isRemoteCopy();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.payload == null) {
            return null;
        }
        URLConnection urlc = this.payload.openConnection();
        return urlc.getInputStream();
    }

    @Override
    public void extendSend(DataOutput out, IBuffer.TransportOverride override) throws GRS2RecordSerializationException {
        try {
            IBuffer.TransportDirective dir = this.resolveTransportDirective();
            if (override == IBuffer.TransportOverride.Override) {
                dir = IBuffer.TransportDirective.Full;
            }
            if (this.marshaledCompleted) {
                throw new GRS2ProxyMirrorProtocolErrorException("More to marshal requested but full payload is already provided");
            }
            this.record.markActivity();
            if (this.payload == null) {
                this.marshaledCompleted = true;
                out.writeInt(-1);
                out.writeBoolean(this.marshaledCompleted);
            } else {
                if (dir == IBuffer.TransportDirective.Inherit) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
                }
                if (dir == IBuffer.TransportDirective.Partial) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
                }
                byte[] pb = this.payload.toString().getBytes(this.getFieldDefinition().getCharset());
                if (this.getFieldDefinition().isCompress()) {
                    pb = ZipUtils.ZipBytes((byte[])pb);
                }
                out.writeInt(pb.length);
                out.write(pb);
                this.marshaledSize += pb.length;
                this.marshaledCompleted = true;
                out.writeBoolean(this.marshaledCompleted);
                this.record.markActivity();
            }
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to marshal field", e);
        }
    }

    @Override
    public void extendReceive(DataInput in, IBuffer.TransportOverride override) throws GRS2RecordSerializationException {
        try {
            if (this.marshaledCompleted) {
                throw new GRS2ProxyMirrorProtocolErrorException("Marshaling of field is already completed");
            }
            IBuffer.TransportDirective dir = this.resolveTransportDirective();
            if (override == IBuffer.TransportOverride.Override) {
                dir = IBuffer.TransportDirective.Full;
            }
            if (dir == IBuffer.TransportDirective.Inherit) {
                throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
            }
            this.record.markActivity();
            int len = in.readInt();
            if (len < 0) {
                this.payload = null;
                this.marshaledSize = 0;
                this.marshaledCompleted = true;
                if (!in.readBoolean()) {
                    throw new GRS2ProxyMirrorProtocolErrorException("More to marshal detected alhough full payload was available");
                }
            } else {
                byte[] pb = new byte[len];
                in.readFully(pb);
                if (this.getFieldDefinition().isCompress()) {
                    pb = ZipUtils.UnzipBytes((byte[])pb);
                }
                this.payload = new URL(new String(pb, this.getFieldDefinition().getCharset()));
                this.marshaledSize += len;
                this.marshaledCompleted = true;
                if (!in.readBoolean()) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Partial transfer detected although full was resolved");
                }
                this.record.markActivity();
            }
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to unmarshal field", e);
        }
    }

    @Override
    public void extendDispose() {
        this.payload = null;
        this.marshaledSize = 0;
        this.marshaledCompleted = false;
    }

    @Override
    public void extendDeflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeUTF(this.getFieldDefinition().getCharset());
            if (this.payload == null) {
                out.writeInt(-1);
            } else {
                byte[] b = this.payload.toString().getBytes(this.getFieldDefinition().getCharset());
                out.writeInt(b.length);
                out.write(b);
            }
            out.writeInt(this.marshaledSize);
            out.writeBoolean(this.marshaledCompleted);
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("unable to deflate field", ex);
        }
    }

    @Override
    public void extendInflate(DataInput in, boolean reset) throws GRS2RecordSerializationException {
        try {
            String charset = in.readUTF();
            int len = in.readInt();
            if (len < 0) {
                this.payload = null;
            } else {
                byte[] b = new byte[len];
                in.readFully(b);
                this.payload = new URL(new String(b, charset));
            }
            this.marshaledSize = in.readInt();
            this.marshaledCompleted = in.readBoolean();
            if (reset) {
                this.marshaledSize = 0;
                this.marshaledCompleted = false;
            }
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("unable to inflate field", ex);
        }
    }

    @Override
    protected void extendMakeLocal() {
        this.marshaledSize = 0;
        this.marshaledCompleted = false;
    }
}

