/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.record.field;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import java.io.DataInput;
import java.io.DataOutput;

public class StringFieldDefinition
extends FieldDefinition {
    public static final String DefaultMimeType = "text/plain";
    public static final IBuffer.TransportDirective DefaultDirective = IBuffer.TransportDirective.Full;
    public static final String DefaultCharset = "UTF-8";
    private String charset = "UTF-8";

    public StringFieldDefinition() {
        this.setMimeType(DefaultMimeType);
        this.setTransportDirective(DefaultDirective);
    }

    public StringFieldDefinition(String name) {
        this.setMimeType(DefaultMimeType);
        this.setTransportDirective(DefaultDirective);
        this.setName(name);
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public void setTransportDirective(IBuffer.TransportDirective directive) {
    }

    @Override
    public IBuffer.TransportDirective getTransportDirective() {
        return DefaultDirective;
    }

    @Override
    public boolean extendEquals(Object obj) {
        if (!(obj instanceof StringFieldDefinition)) {
            return false;
        }
        return this.charset.equals(((StringFieldDefinition)obj).charset);
    }

    @Override
    public void extendDeflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeUTF(this.charset);
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("Could not complete marshalling of definition", ex);
        }
    }

    @Override
    public void extendInflate(DataInput in) throws GRS2RecordSerializationException {
        try {
            this.charset = in.readUTF();
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("Could not complete unmarshalling of definition", ex);
        }
    }
}

