/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.record.field;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import java.io.DataInput;
import java.io.DataOutput;

public class FileFieldDefinition
extends FieldDefinition {
    public static final String DefaultMimeType = "application/octet-stream";
    public static final IBuffer.TransportDirective DefaultDirective = IBuffer.TransportDirective.Inherit;
    public static final String DefaultCharset = "UTF-8";
    public static final int DefaultLocalBuffer = 102400;
    public static final boolean DefaultDeleteOnDispose = false;
    private String charset = "UTF-8";
    private int localBuffer = 102400;
    private boolean deleteOnDispose = false;

    public FileFieldDefinition() {
        this.setMimeType(DefaultMimeType);
        this.setTransportDirective(DefaultDirective);
    }

    public FileFieldDefinition(String name) {
        this.setMimeType(DefaultMimeType);
        this.setTransportDirective(DefaultDirective);
        this.setName(name);
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setLocalBuffer(int localBuffer) {
        this.localBuffer = localBuffer;
    }

    public int getLocalBuffer() {
        return this.localBuffer;
    }

    public void setDeleteOnDispose(boolean deleteOnDispose) {
        this.deleteOnDispose = deleteOnDispose;
    }

    public boolean getDeleteOnDispose() {
        return this.deleteOnDispose;
    }

    @Override
    public boolean extendEquals(Object obj) {
        if (!(obj instanceof FileFieldDefinition)) {
            return false;
        }
        if (!this.charset.equals(((FileFieldDefinition)obj).charset)) {
            return false;
        }
        return this.localBuffer == ((FileFieldDefinition)obj).localBuffer;
    }

    @Override
    public void extendDeflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeUTF(this.charset);
            out.writeInt(this.localBuffer);
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("Could not complete marshalling of definition", ex);
        }
    }

    @Override
    public void extendInflate(DataInput in) throws GRS2RecordSerializationException {
        try {
            this.charset = in.readUTF();
            this.localBuffer = in.readInt();
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("Could not complete unmarshalling of definition", ex);
        }
    }
}

