/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import gr.uoa.di.madgik.commons.channel.proxy.tcp.ChannelTCPConnManagerEntry;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.environment.accounting.AccountingSystem;
import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.environment.is.elements.ExtensionPair;
import gr.uoa.di.madgik.environment.is.elements.NodeInfo;
import gr.uoa.di.madgik.environment.jms.JMSProvider;
import gr.uoa.di.madgik.execution.engine.ExecutionEngine;
import gr.uoa.di.madgik.execution.engine.ExecutionEngineConfig;
import gr.uoa.di.madgik.execution.engine.QueueableExecutionEngine;
import gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver.ExecEngCallbackTCPConnManagerEntry;
import gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver.ExecEngTCPConnManagerEntry;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.is.InformationSystem;
import gr.uoa.di.madgik.notificationhandling.NotificationHandling;
import gr.uoa.di.madgik.ss.StorageSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.gcube.rest.commons.helpers.XMLConverter;
import org.gcube.rest.commons.resourceawareservice.resources.RunInstance;
import org.gcube.rest.resourcemanager.discovery.InformationCollector;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@Singleton
public class ServiceContext {
    private static Logger logger = LoggerFactory.getLogger(ServiceContext.class);
    public static final String PROPERTIES_FILE = "deploy.properties";
    public static final String ServiceClass = "Execution";
    public static final String ServiceName = "ExecutionEngineService";
    public static final String ENDPOINT_KEY = "resteasy-servlet";
    private static InformationCollector ic;
    private static ResourcePublisher<RunInstance> rp;
    private String scope = null;

    @Inject
    public ServiceContext(InformationCollector ic, ResourcePublisher<RunInstance> rp) throws Exception {
        ServiceContext.ic = ic;
        ServiceContext.rp = rp;
        this.initialize();
    }

    public String getScope() {
        return this.scope;
    }

    void initialize() throws Exception {
        Map map = this.readProperties();
        this.scope = (String)map.get("scope");
        EnvHintCollection Hints = new EnvHintCollection();
        Hints.AddHint(new NamedEnvHint("StorageSystemDeleteOnExit", new EnvHint(Boolean.TRUE.toString())));
        Hints.AddHint(new NamedEnvHint("StorageSystemLocalFileSystemBufferPath", new EnvHint(this.GetLocalFSBuffer(map))));
        Hints.AddHint(new NamedEnvHint("RetryOnErrorCount", new EnvHint(Integer.toString(this.GetRetryOnErrorTimes(map)))));
        Hints.AddHint(new NamedEnvHint("RetryOnErrorInterval", new EnvHint(Integer.toString(this.GetRetryOnErrorInterval(map)))));
        Hints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceClass", new EnvHint(ServiceClass)));
        Hints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceName", new EnvHint(ServiceName)));
        Hints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(this.scope)));
        this.InitExecutionEngineEnvironment(Hints, map);
        if (!Boolean.valueOf((String)map.get("test")).booleanValue()) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    public static void removeAllChildren(Node node) {
        Node child;
        logger.trace("node: " + node + " :" + XMLConverter.nodeToString((Node)node));
        while ((child = node.getFirstChild()) != null) {
            node.removeChild(child);
        }
    }

    static String createSerialization(String pe2ngPort, String hostname) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<doc>");
        strBuf.append("<element id=\"" + UUID.randomUUID() + "\">");
        strBuf.append("<dynamic>");
        strBuf.append("<entry key=\"pe2ng.port\">" + pe2ngPort + "</entry>");
        strBuf.append("<entry key=\"hostname\">" + hostname + "</entry>");
        strBuf.append("</dynamic>");
        strBuf.append("</element>");
        strBuf.append("</doc>");
        return strBuf.toString();
    }

    private void InitExecutionEngineEnvironment(EnvHintCollection Hints, Map<String, String> map) throws Exception {
        logger.info("Initalizing Engine Environment");
        logger.info("Initalizing TCPManager");
        List range = this.GetPortRanges(map);
        for (PortRange r : range) {
            logger.info("port range : " + r.GetStart() + "-" + r.GetEnd());
        }
        TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(this.getHostName(map), range, this.GetUseRandomPort(map).booleanValue()));
        if (((PortRange)range.get(0)).GetStart() == Integer.valueOf(this.getPe2ngPort()).intValue()) {
            logger.info("Registered port: " + this.getPe2ngPort());
        } else {
            logger.warn("Registered port: " + this.getPe2ngPort() + ". Start port was in use: " + ((PortRange)range.get(0)).GetStart());
        }
        logger.info("Registering entries");
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ExecEngTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ExecEngCallbackTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ChannelTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        logger.info("Initializing Execution Engine");
        ExecutionEngineConfig conf = new ExecutionEngineConfig(0, this.getHostName(map), Integer.valueOf(map.get("port")).intValue());
        ExecutionEngine.Init((ExecutionEngineConfig)conf);
        logger.info("Collecting Environment Hints");
        logger.info("Initializing Information System Provider");
        logger.info("Initializing Storage System Provider");
        StorageSystem.Init((String)this.GetStorageSystemProvider(map), (EnvHintCollection)Hints);
        logger.info("Initializing Accoutning System Provider");
        AccountingSystem.init((String)this.GetAccountingSystemProvider(map));
        JMSProvider.Init((String)this.GetJMSProvider(map), (EnvHintCollection)Hints, (String)this.GetJMSFallBack(map));
        String jmshost = this.GetJMSHost();
        if (jmshost != null) {
            Hints.AddHint(new NamedEnvHint("JMSHost", new EnvHint(this.GetJMSHost())));
            String notificationHandlingProvider = this.GetNotificationHandlingProvider(map);
            try {
                NotificationHandling.Init((String)notificationHandlingProvider, (EnvHintCollection)Hints);
            }
            catch (Exception e) {
                logger.warn("Notification Handler initialization failed", (Throwable)e);
            }
        }
        try {
            String id = this.getHostName(map);
            QueueableExecutionEngine.Init((ExecutionEngineConfig)new ExecutionEngineConfig(0, this.getHostName(map), Integer.valueOf(this.getPe2ngPort()).intValue()), (String)id);
        }
        catch (NoClassDefFoundError e) {
            logger.warn("Queuing mechanism is not supported cause class not found " + e.getMessage());
        }
    }

    void getTomcatPort() {
    }

    private void RegisterInfo(EnvHintCollection Hints) throws Exception {
        logger.info("Registering Node");
        NodeInfo nfo = new NodeInfo();
        nfo.DynamicExtensions.put("pe2ng.port", new ExtensionPair("pe2ng.port", Integer.toString(TCPConnectionManager.GetConnectionManagerPort())));
        InformationSystem.RegisterNode((NodeInfo)nfo, (EnvHintCollection)Hints);
        logger.info("Registering boundary listener");
    }

    private String GetLocalFSBuffer(Map<String, String> map) {
        String tmpObj = map.get("localFSBuffer");
        if (tmpObj == null) {
            return "";
        }
        return tmpObj.toString();
    }

    private int GetRetryOnErrorInterval(Map<String, String> map) {
        String tmpObj = map.get("retryOnErrorInterval");
        if (tmpObj == null) {
            return 0;
        }
        try {
            return Integer.parseInt(tmpObj.toString().trim());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private int GetRetryOnErrorTimes(Map<String, String> map) {
        String tmpObj = map.get("retryOnErrorTimes");
        if (tmpObj == null) {
            return 0;
        }
        try {
            return Integer.parseInt(tmpObj.toString().trim());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private String GetInformationSystemProvider(Map<String, String> map) {
        String informationProviderObj = map.get("providerInformationName");
        if (informationProviderObj == null) {
            return null;
        }
        return informationProviderObj.toString();
    }

    private String GetStorageSystemProvider(Map<String, String> map) {
        String storageProviderObj = map.get("providerStorageName");
        if (storageProviderObj == null) {
            return null;
        }
        return storageProviderObj.toString();
    }

    private String GetAccountingSystemProvider(Map<String, String> map) {
        String accountingProviderObj = map.get("providerAccountingName");
        if (accountingProviderObj == null) {
            return null;
        }
        return accountingProviderObj.toString();
    }

    private String GetNotificationHandlingProvider(Map<String, String> map) {
        String JMSProviderObj = map.get("NotificationHandlingProviderName");
        if (JMSProviderObj == null) {
            return null;
        }
        return JMSProviderObj.toString();
    }

    private String GetJMSProvider(Map<String, String> map) {
        String JMSProviderObj = map.get("providerJMSName");
        if (JMSProviderObj == null) {
            return null;
        }
        return JMSProviderObj.toString();
    }

    private String GetJMSFallBack(Map<String, String> map) {
        String JMSProviderObj = map.get("fallbackJMS");
        if (JMSProviderObj == null) {
            return null;
        }
        return JMSProviderObj.toString();
    }

    private String GetJMSHost() {
        try {
            return JMSProvider.getJMSPRovider();
        }
        catch (EnvironmentInformationSystemException e) {
            return null;
        }
    }

    private List<PortRange> GetPortRanges(Map<String, String> map) {
        String portRangesObj = map.get("portRanges");
        logger.info("port ranges retrieved is " + portRangesObj);
        if (portRangesObj == null) {
            return new ArrayList<PortRange>();
        }
        String portRangesStr = portRangesObj.toString();
        String[] rangePairs = portRangesStr.trim().split("-");
        ArrayList<PortRange> ranges = new ArrayList<PortRange>();
        for (String pair : rangePairs) {
            String[] pairSplit = pair.trim().split(",");
            if (pairSplit.length != 2) {
                return new ArrayList<PortRange>();
            }
            String pairStart = pairSplit[0].trim();
            if (!pairStart.startsWith("{")) {
                return new ArrayList<PortRange>();
            }
            pairStart = pairStart.substring(1).trim();
            String pairEnd = pairSplit[1].trim();
            if (!pairEnd.endsWith("}")) {
                return new ArrayList<PortRange>();
            }
            pairEnd = pairEnd.substring(0, pairEnd.length() - 1).trim();
            int beginPair = 0;
            int endPair = 0;
            try {
                beginPair = Integer.parseInt(pairStart.trim());
            }
            catch (Exception ex) {
                return new ArrayList<PortRange>();
            }
            try {
                endPair = Integer.parseInt(pairEnd.trim());
            }
            catch (Exception ex) {
                return new ArrayList<PortRange>();
            }
            ranges.add(new PortRange(beginPair, endPair));
        }
        return ranges;
    }

    private Boolean GetUseRandomPort(Map<String, String> map) {
        String portRandomObj = map.get("useRandomPort");
        if (portRandomObj == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(portRandomObj.toString().trim());
        }
        catch (Exception ex) {
            return false;
        }
    }

    String getHostName(Map<String, String> map) {
        return map.get("hostname");
    }

    String getPe2ngPort() {
        return String.valueOf(TCPConnectionManager.GetConnectionManagerPort());
    }

    private Map<String, String> readProperties() throws FileNotFoundException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties prop = new Properties();
        InputStream is = ServiceContext.class.getResourceAsStream("/deploy.properties");
        prop.load(is);
        for (String key : prop.stringPropertyNames()) {
            String value = prop.getProperty(key);
            if (value == null) continue;
            map.put(key, value.trim());
        }
        logger.info("properties read : " + map);
        return map;
    }

    static /* synthetic */ String access$000(ServiceContext x0) {
        return x0.scope;
    }

    static /* synthetic */ InformationCollector access$100() {
        return ic;
    }

    static /* synthetic */ Logger access$200() {
        return logger;
    }

    static /* synthetic */ ResourcePublisher access$300() {
        return rp;
    }
}

