/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.invocable;

import gr.uoa.di.madgik.commons.channel.events.ChannelPayloadStateEvent;
import gr.uoa.di.madgik.commons.channel.events.ISerializable;
import gr.uoa.di.madgik.commons.channel.events.ObjectPayloadChannelEvent;
import gr.uoa.di.madgik.commons.channel.proxy.ChannelLocatorFactory;
import gr.uoa.di.madgik.commons.channel.proxy.IChannelLocator;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.utils.FileUtils;
import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.commons.utils.ZipUtils;
import gr.uoa.di.madgik.environment.exception.EnvironmentSerializationException;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.execution.engine.ExecutionEngine;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.plan.ExecutionPlan;
import gr.uoa.di.madgik.execution.plan.PlanConfig;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.attachment.ExecutionAttachment;
import gr.uoa.di.madgik.execution.plan.element.invocable.BoundaryConfig;
import gr.uoa.di.madgik.execution.plan.element.invocable.NozzleEventPayload;
import gr.uoa.di.madgik.execution.plan.element.invocable.NozzleHandler;
import gr.uoa.di.madgik.execution.plan.element.invocable.callback.CallbackManager;
import gr.uoa.di.madgik.execution.plan.element.invocable.callback.CallbackRegistryEntry;
import gr.uoa.di.madgik.execution.plan.element.variable.VariableCollection;
import gr.uoa.di.madgik.execution.utils.BoundaryIsolationInfo;
import gr.uoa.di.madgik.execution.utils.ExceptionUtils;
import gr.uoa.di.madgik.execution.utils.PlanElementUtils;
import gr.uoa.di.madgik.execution.utils.ValueCollection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundaryHandler
extends Thread
implements Observer {
    private static Logger logger = LoggerFactory.getLogger(BoundaryHandler.class);
    private Socket socket = null;
    private final Object synchCompletion = new Object();
    private NozzleHandler NzlHandler = null;
    private ExecutionHandle Handle = null;
    public boolean Completed = false;
    public boolean Successful = false;
    public boolean WeirdCompletion = false;
    public ExecutionException Error = null;
    private IPlanElement PlanToSend = null;
    private VariableCollection VarsToSend = null;
    private EnvHintCollection HintsToSend = null;
    private String ID = null;
    private String Name = null;
    private BoundaryConfig Config = null;
    private BoundaryIsolationInfo IsolationToSend = null;
    private PlanConfig PlanConfigToSend = null;
    private Set<ExecutionAttachment> Attachments = new HashSet<ExecutionAttachment>();

    public BoundaryHandler(Socket socket) {
        this.socket = socket;
        this.setName(BoundaryHandler.class.getName());
        this.setDaemon(true);
    }

    public BoundaryHandler(IPlanElement PlanToSend, VariableCollection VarsToSend, EnvHintCollection HintsToSend, ExecutionHandle Handle, String ID, String Name, BoundaryConfig Config, BoundaryIsolationInfo IsolationToSend, PlanConfig PlanConfigToSend, Set<ExecutionAttachment> Attachments) {
        this.PlanToSend = PlanToSend;
        this.VarsToSend = VarsToSend;
        this.HintsToSend = HintsToSend;
        this.Handle = Handle;
        this.ID = ID;
        this.Name = Name;
        this.Config = Config;
        this.IsolationToSend = IsolationToSend;
        this.PlanConfigToSend = PlanConfigToSend;
        this.Attachments = Attachments;
    }

    public void BoundarySideProtocol() throws Exception {
        if (this.socket == null || !this.isDaemon()) {
            throw new ExecutionInternalErrorException("Handler not correctly initialized for engine side protocol");
        }
        this.start();
    }

    public String EngineSideProtocol() throws ExecutionInternalErrorException, IOException, ExecutionRunTimeException, EnvironmentSerializationException, ExecutionSerializationException, Exception {
        if (this.PlanToSend == null || this.IsolationToSend == null || this.PlanConfigToSend == null || this.VarsToSend == null || this.Handle == null || this.ID == null || this.Name == null || this.Config == null) {
            throw new ExecutionInternalErrorException("Handler not correctly initialized for engine side protocol");
        }
        Socket clientSock = null;
        NozzleHandler Handler = null;
        CallbackRegistryEntry entryToCallback = null;
        DataOutputStream dout = null;
        FilterInputStream din = null;
        try {
            if (this.PlanConfigToSend.ModeOfConnection == PlanConfig.ConnectionMode.Callback) {
                entryToCallback = new CallbackRegistryEntry();
                entryToCallback.ID = UUID.randomUUID().toString();
                CallbackManager.RegisterCallback(entryToCallback);
            }
            if (!this.Handle.GetPlan().Config.ChokeProgressReporting) {
                this.Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.ID, "Contacting remote boundary element"));
            }
            clientSock = new Socket(this.Config.HostName, this.Config.Port);
            logger.debug("Opening connection to " + this.Config.HostName + ":" + this.Config.Port);
            Handler = new NozzleHandler();
            IChannelLocator locator = Handler.CreateInletNozzle(this.Config.NozzleConfig, this.Handle);
            dout = new DataOutputStream(new BufferedOutputStream(clientSock.getOutputStream()));
            din = new DataInputStream(new BufferedInputStream(clientSock.getInputStream()));
            if (!this.Handle.GetPlan().Config.ChokeProgressReporting) {
                this.Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.ID, "Sending assembled info to remote boundary element"));
            }
            dout.writeUTF(ITCPConnectionManagerEntry.NamedEntry.ExecutionEngine.toString());
            logger.debug("Sending locator : " + locator.ToURI());
            this.WriteArray(ZipUtils.ZipString((String)this.PlanToSend.ToXML()), dout);
            this.WriteArray(ZipUtils.ZipString((String)this.VarsToSend.ToXML()), dout);
            this.WriteArray(ZipUtils.ZipString((String)this.HintsToSend.ToXML()), dout);
            this.WriteArray(ZipUtils.ZipString((String)this.PlanConfigToSend.ToXML()), dout);
            this.WriteArray(ZipUtils.ZipString((String)this.IsolationToSend.ToXML()), dout);
            this.WriteArray(ZipUtils.ZipString((String)locator.ToURI().toString()), dout);
            dout.writeInt(this.Attachments.size());
            for (ExecutionAttachment at : this.Attachments) {
                this.WriteArray(ZipUtils.ZipString((String)at.ToXML()), dout);
                if (at.LocationType != ExecutionAttachment.AttachmentLocation.LocalFile) continue;
                at.WriteLocalToStream(dout);
            }
            if (this.PlanConfigToSend.ModeOfConnection == PlanConfig.ConnectionMode.Callback) {
                logger.debug("Sending info on callback");
                dout.writeBoolean(true);
                dout.writeUTF(entryToCallback.ID);
                dout.writeUTF(TCPConnectionManager.GetConnectionManagerHostName());
                dout.writeInt(TCPConnectionManager.GetConnectionManagerPort());
            } else {
                dout.writeBoolean(false);
            }
            dout.flush();
            if (this.PlanConfigToSend.ModeOfConnection == PlanConfig.ConnectionMode.Callback) {
                logger.debug("Closing original socket");
                dout.flush();
                dout.close();
                din.close();
                clientSock.close();
                entryToCallback.WaitForCallback(this.PlanConfigToSend.ConnectionCallbackTimeout);
                if (entryToCallback.Sock == null) {
                    throw new ExecutionRunTimeException("There was a timeout waiting for a callback from the remote boundary node");
                }
                clientSock = entryToCallback.Sock;
                dout = new DataOutputStream(clientSock.getOutputStream());
                din = new DataInputStream(clientSock.getInputStream());
                logger.debug("Opened Callback socket");
            }
            this.Completed = ((DataInputStream)din).readBoolean();
            this.Successful = ((DataInputStream)din).readBoolean();
            this.WeirdCompletion = ((DataInputStream)din).readBoolean();
            boolean excIncluded = ((DataInputStream)din).readBoolean();
            if (excIncluded) {
                this.Error = ExceptionUtils.FromXML(ZipUtils.UnzipString((byte[])this.ReadArray((DataInputStream)din)));
            }
            String ssIDsUpdate = ZipUtils.UnzipString((byte[])this.ReadArray((DataInputStream)din));
            String varsUpdate = ZipUtils.UnzipString((byte[])this.ReadArray((DataInputStream)din));
            dout.close();
            din.close();
            logger.debug("Received Updated variables : " + varsUpdate);
            if (varsUpdate == null || varsUpdate.trim().length() == 0) {
                throw new ExecutionInternalErrorException("Protocol error contacting remote boundary element");
            }
            this.Handle.GetPlan().CleanUpSS.Merge(new ValueCollection(ssIDsUpdate));
            String string = varsUpdate;
            return string;
        }
        catch (ExecutionInternalErrorException ex) {
            throw ex;
        }
        catch (UnknownHostException ex) {
            throw ex;
        }
        catch (ExecutionSerializationException ex) {
            throw ex;
        }
        catch (EnvironmentSerializationException ex) {
            throw ex;
        }
        catch (ExecutionRunTimeException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            logger.debug("Cleaning up");
            if (entryToCallback != null) {
                try {
                    CallbackManager.UnregisterCallback(entryToCallback);
                }
                catch (Exception ex) {}
            }
            try {
                if (dout != null) {
                    dout.flush();
                }
            }
            catch (Exception ex) {}
            try {
                if (dout != null) {
                    dout.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (din != null) {
                    din.close();
                }
            }
            catch (Exception ex) {}
            if (clientSock != null) {
                try {
                    clientSock.close();
                }
                catch (Exception ex) {}
            }
            if (Handler != null) {
                try {
                    Handler.Dispose();
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block113: {
            this.NzlHandler = new NozzleHandler();
            boolean UseCallback = false;
            String CallbackID = null;
            String CallbackHostName = null;
            int CallbackPort = 0;
            HashSet<ExecutionAttachment> atts = new HashSet<ExecutionAttachment>();
            DataOutputStream dout = null;
            FilterInputStream din = null;
            dout = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            din = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            logger.debug("Receiving boundary plan info");
            String RootXML = ZipUtils.UnzipString((byte[])this.ReadArray((DataInputStream)din));
            String VariablesXML = ZipUtils.UnzipString((byte[])this.ReadArray((DataInputStream)din));
            String EnvXML = ZipUtils.UnzipString((byte[])this.ReadArray((DataInputStream)din));
            String ConfigXML = ZipUtils.UnzipString((byte[])this.ReadArray((DataInputStream)din));
            String IsolationXML = ZipUtils.UnzipString((byte[])this.ReadArray((DataInputStream)din));
            String LocatorSerialiazation = ZipUtils.UnzipString((byte[])this.ReadArray((DataInputStream)din));
            int AttachmentsCount = ((DataInputStream)din).readInt();
            for (int i = 0; i < AttachmentsCount; ++i) {
                ExecutionAttachment at = new ExecutionAttachment();
                at.FromXML(ZipUtils.UnzipString((byte[])this.ReadArray((DataInputStream)din)));
                if (at.LocationType == ExecutionAttachment.AttachmentLocation.LocalFile) {
                    at.WriteLocalFromStream((DataInputStream)din);
                }
                atts.add(at);
            }
            UseCallback = ((DataInputStream)din).readBoolean();
            if (UseCallback) {
                logger.debug("Reading callback info");
                CallbackID = ((DataInputStream)din).readUTF();
                CallbackHostName = ((DataInputStream)din).readUTF();
                CallbackPort = ((DataInputStream)din).readInt();
                dout.flush();
                dout.close();
                din.close();
                this.socket.close();
            }
            ExecutionPlan Plan = new ExecutionPlan();
            BoundaryIsolationInfo isolatenfo = new BoundaryIsolationInfo();
            IChannelLocator loc = null;
            try {
                Plan.Root = PlanElementUtils.GetPlanElement(XMLUtils.Deserialize((String)RootXML).getDocumentElement());
                Plan.Variables = new VariableCollection(VariablesXML);
                Plan.EnvHints = new EnvHintCollection(EnvXML);
                Plan.Config = new PlanConfig(ConfigXML);
                isolatenfo.FromXML(IsolationXML);
                loc = ChannelLocatorFactory.GetLocator((URI)new URI(LocatorSerialiazation));
            }
            catch (Exception ex) {
                logger.warn("Could not complete population of incoming info", (Throwable)ex);
                logger.warn("Plan: " + RootXML);
                if (UseCallback) {
                    logger.debug("Opening callback socket to respond");
                    this.socket = new Socket(CallbackHostName, CallbackPort);
                    dout = new DataOutputStream(this.socket.getOutputStream());
                    din = new DataInputStream(this.socket.getInputStream());
                    dout.writeUTF(ITCPConnectionManagerEntry.NamedEntry.ExecutionEngineCallback.toString());
                    dout.writeUTF(CallbackID);
                    dout.flush();
                }
                dout.writeBoolean(true);
                dout.writeBoolean(false);
                dout.writeBoolean(false);
                dout.writeBoolean(true);
                this.WriteArray(ZipUtils.ZipString((String)ExceptionUtils.ToXML(ExceptionUtils.GetTransformedExecutionException(ex))), dout);
                this.WriteArray(ZipUtils.ZipString((String)Plan.CleanUpSS.ToXML()), dout);
                this.WriteArray(ZipUtils.ZipString((String)Plan.Variables.ToXML()), dout);
            }
            for (ExecutionAttachment at : atts) {
                if (at.LocationType != ExecutionAttachment.AttachmentLocation.StorageSystem) continue;
                at.WriteLocalFromStorage(Plan.EnvHints);
            }
            this.NzlHandler.CreateOutletNozzle(loc);
            try {
                this.Handle = ExecutionEngine.Submit(Plan);
            }
            catch (Exception ex) {
                logger.warn("Could not submit execution", (Throwable)ex);
                if (UseCallback) {
                    logger.debug("Opening callback socket to respond");
                    this.socket = new Socket(CallbackHostName, CallbackPort);
                    dout = new DataOutputStream(this.socket.getOutputStream());
                    din = new DataInputStream(this.socket.getInputStream());
                    dout.writeUTF(ITCPConnectionManagerEntry.NamedEntry.ExecutionEngineCallback.toString());
                    dout.writeUTF(CallbackID);
                    dout.flush();
                }
                dout.writeBoolean(true);
                dout.writeBoolean(false);
                dout.writeBoolean(false);
                dout.writeBoolean(true);
                this.WriteArray(ZipUtils.ZipString((String)ExceptionUtils.ToXML(ExceptionUtils.GetTransformedExecutionException(ex))), dout);
                this.WriteArray(ZipUtils.ZipString((String)Plan.CleanUpSS.ToXML()), dout);
                this.WriteArray(ZipUtils.ZipString((String)Plan.Variables.ToXML()), dout);
            }
            try {
                this.Handle.SetIsolationInfo(isolatenfo);
                this.Handle.InitializeIsolation();
            }
            catch (Exception ex) {
                logger.warn("Could not initialize isolation", (Throwable)ex);
                if (UseCallback) {
                    logger.debug("Opening callback socket to respond");
                    this.socket = new Socket(CallbackHostName, CallbackPort);
                    dout = new DataOutputStream(this.socket.getOutputStream());
                    din = new DataInputStream(this.socket.getInputStream());
                    dout.writeUTF(ITCPConnectionManagerEntry.NamedEntry.ExecutionEngineCallback.toString());
                    dout.writeUTF(CallbackID);
                    dout.flush();
                }
                dout.writeBoolean(true);
                dout.writeBoolean(false);
                dout.writeBoolean(false);
                dout.writeBoolean(true);
                this.WriteArray(ZipUtils.ZipString((String)ExceptionUtils.ToXML(ExceptionUtils.GetTransformedExecutionException(ex))), dout);
                this.WriteArray(ZipUtils.ZipString((String)Plan.CleanUpSS.ToXML()), dout);
                this.WriteArray(ZipUtils.ZipString((String)Plan.Variables.ToXML()), dout);
            }
            for (ExecutionAttachment at : atts) {
                at.MoveTmpToRestore(this.Handle);
            }
            this.Handle.RegisterObserver(this);
            Object object = this.synchCompletion;
            synchronized (object) {
                ExecutionEngine.Execute(this.Handle);
                try {
                    this.synchCompletion.wait();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.Completed = true;
            this.Successful = true;
            this.WeirdCompletion = false;
            if (!this.Handle.IsCompleted()) {
                this.Completed = false;
            } else if (this.Handle.IsCompletedWithSuccess()) {
                this.Successful = true;
            } else if (this.Handle.IsCompletedWithError()) {
                this.Successful = false;
                this.Error = this.Handle.GetCompletionError();
            } else {
                this.WeirdCompletion = true;
            }
            if (UseCallback) {
                logger.debug("Opening callback socket to respond");
                this.socket = new Socket(CallbackHostName, CallbackPort);
                dout = new DataOutputStream(this.socket.getOutputStream());
                din = new DataInputStream(this.socket.getInputStream());
                dout.writeUTF(ITCPConnectionManagerEntry.NamedEntry.ExecutionEngineCallback.toString());
                dout.writeUTF(CallbackID);
                dout.flush();
            }
            dout.writeBoolean(this.Completed);
            dout.writeBoolean(this.Successful);
            dout.writeBoolean(this.WeirdCompletion);
            if (this.Error == null) {
                dout.writeBoolean(false);
            } else {
                dout.writeBoolean(true);
                this.WriteArray(ZipUtils.ZipString((String)ExceptionUtils.ToXML(this.Error)), dout);
            }
            this.WriteArray(ZipUtils.ZipString((String)Plan.CleanUpSS.ToXML()), dout);
            this.WriteArray(ZipUtils.ZipString((String)Plan.Variables.ToXML()), dout);
            dout.flush();
            try {
                if (dout != null) {
                    dout.flush();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                if (dout != null) {
                    dout.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                if (din != null) {
                    din.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exx) {
                    // empty catch block
                }
            }
            if (this.NzlHandler != null) {
                try {
                    this.NzlHandler.Dispose();
                }
                catch (Exception exx) {
                    // empty catch block
                }
            }
            for (ExecutionAttachment at : atts) {
                if (at.tmpFile != null) {
                    try {
                        FileUtils.CleanUp((File)at.tmpFile);
                    }
                    catch (Exception ex) {
                        logger.warn("Couldn not cleanup tmp stored attachement " + at.tmpFile, (Throwable)ex);
                    }
                }
                if (!at.CleanUpRestored) continue;
                try {
                    if (at.RestoreLocationValue == null) continue;
                    File f = this.Handle.GetIsolatedFile(new File(at.RestoreLocationValue));
                    FileUtils.CleanUp((File)f);
                }
                catch (Exception ex) {
                    logger.warn("Couldn not cleanup attachement " + at.RestoreLocationValue, (Throwable)ex);
                }
            }
            try {
                if (this.Handle != null) {
                    this.Handle.FinalizeIsolation();
                }
            }
            catch (Exception ex) {
                logger.warn("Could not finalize isolation", (Throwable)ex);
            }
            if (this.Handle != null) {
                try {
                    this.Handle.Dispose();
                }
                catch (Exception exx) {}
            }
            break block113;
            catch (Exception ex) {
                logger.warn("Could not complete boundary side handler protocol", (Throwable)ex);
                try {
                    if (dout != null) {
                        dout.flush();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                try {
                    if (dout != null) {
                        dout.close();
                    }
                }
                catch (Exception ex3) {
                    // empty catch block
                }
                try {
                    if (din != null) {
                        din.close();
                    }
                }
                catch (Exception ex4) {
                    // empty catch block
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (Exception exx) {
                        // empty catch block
                    }
                }
                if (this.NzlHandler != null) {
                    try {
                        this.NzlHandler.Dispose();
                    }
                    catch (Exception exx) {
                        // empty catch block
                    }
                }
                for (ExecutionAttachment at : atts) {
                    if (at.tmpFile != null) {
                        try {
                            FileUtils.CleanUp((File)at.tmpFile);
                        }
                        catch (Exception ex5) {
                            logger.warn("Couldn not cleanup tmp stored attachement " + at.tmpFile, (Throwable)ex5);
                        }
                    }
                    if (!at.CleanUpRestored) continue;
                    try {
                        if (at.RestoreLocationValue == null) continue;
                        File f = this.Handle.GetIsolatedFile(new File(at.RestoreLocationValue));
                        FileUtils.CleanUp((File)f);
                    }
                    catch (Exception ex6) {
                        logger.warn("Couldn not cleanup attachement " + at.RestoreLocationValue, (Throwable)ex6);
                    }
                }
                try {
                    if (this.Handle != null) {
                        this.Handle.FinalizeIsolation();
                    }
                }
                catch (Exception ex7) {
                    logger.warn("Could not finalize isolation", (Throwable)ex7);
                }
                if (this.Handle != null) {
                    try {
                        this.Handle.Dispose();
                    }
                    catch (Exception exx) {}
                }
                catch (Throwable throwable) {
                    try {
                        if (dout != null) {
                            dout.flush();
                        }
                    }
                    catch (Exception ex8) {
                        // empty catch block
                    }
                    try {
                        if (dout != null) {
                            dout.close();
                        }
                    }
                    catch (Exception ex9) {
                        // empty catch block
                    }
                    try {
                        if (din != null) {
                            din.close();
                        }
                    }
                    catch (Exception ex10) {
                        // empty catch block
                    }
                    if (this.socket != null) {
                        try {
                            this.socket.close();
                        }
                        catch (Exception exx) {
                            // empty catch block
                        }
                    }
                    if (this.NzlHandler != null) {
                        try {
                            this.NzlHandler.Dispose();
                        }
                        catch (Exception exx) {
                            // empty catch block
                        }
                    }
                    for (ExecutionAttachment at : atts) {
                        if (at.tmpFile != null) {
                            try {
                                FileUtils.CleanUp((File)at.tmpFile);
                            }
                            catch (Exception ex11) {
                                logger.warn("Couldn not cleanup tmp stored attachement " + at.tmpFile, (Throwable)ex11);
                            }
                        }
                        if (!at.CleanUpRestored) continue;
                        try {
                            if (at.RestoreLocationValue == null) continue;
                            File f = this.Handle.GetIsolatedFile(new File(at.RestoreLocationValue));
                            FileUtils.CleanUp((File)f);
                        }
                        catch (Exception ex12) {
                            logger.warn("Couldn not cleanup attachement " + at.RestoreLocationValue, (Throwable)ex12);
                        }
                    }
                    try {
                        if (this.Handle != null) {
                            this.Handle.FinalizeIsolation();
                        }
                    }
                    catch (Exception ex13) {
                        logger.warn("Could not finalize isolation", (Throwable)ex13);
                    }
                    if (this.Handle != null) {
                        try {
                            this.Handle.Dispose();
                        }
                        catch (Exception exx) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    private byte[] ReadArray(DataInputStream din) throws IOException {
        int length = din.readInt();
        byte[] buf = new byte[length];
        din.readFully(buf);
        return buf;
    }

    private void WriteArray(byte[] buf, DataOutputStream dout) throws IOException {
        dout.writeInt(buf.length);
        dout.write(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        logger.debug("Caught event from local engine");
        if (o == null || arg == null) {
            return;
        }
        if (!o.getClass().getName().equals(arg.getClass().getName())) {
            return;
        }
        if (!(arg instanceof ExecutionStateEvent)) {
            return;
        }
        boolean emitEvent = true;
        logger.debug("Caught event is " + (Object)((Object)((ExecutionStateEvent)arg).GetEventName()));
        switch (((ExecutionStateEvent)arg).GetEventName()) {
            case ExecutionCompleted: {
                emitEvent = false;
                Object object = this.synchCompletion;
                synchronized (object) {
                    this.synchCompletion.notify();
                    break;
                }
            }
            case ExecutionCancel: 
            case ExecutionPause: 
            case ExecutionResume: 
            case ExecutionStarted: {
                emitEvent = false;
                break;
            }
            case ExecutionPerformance: 
            case ExecutionExternalProgress: 
            case ExecutionProgress: {
                emitEvent = true;
                break;
            }
            default: {
                logger.warn("Received unrecognized event type " + ((ExecutionStateEvent)arg).GetEventName().toString());
            }
        }
        logger.debug("Caught event from local engine can be emitted (" + emitEvent + ") (" + (this.NzlHandler == null) + ") = (" + (emitEvent && this.NzlHandler != null) + ")");
        if (emitEvent && this.NzlHandler != null) {
            try {
                logger.debug("Emiting Caught event " + ((ExecutionStateEvent)arg).GetEventName().toString());
                this.NzlHandler.Emitt((ChannelPayloadStateEvent)new ObjectPayloadChannelEvent((ISerializable)new NozzleEventPayload((ExecutionStateEvent)arg)));
            }
            catch (Exception ex) {
                logger.warn("Problem emitting event " + (Object)((Object)((ExecutionStateEvent)arg).GetEventName()) + " back to engine", (Throwable)ex);
            }
        }
    }
}

