/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.filter;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.DataTypeArray;
import gr.uoa.di.madgik.execution.datatype.DataTypeConvertable;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.IObjectConverter;
import gr.uoa.di.madgik.execution.plan.element.filter.ParameterFilterBase;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import gr.uoa.di.madgik.execution.utils.ExceptionUtils;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParameterObjectConvertableFilter
extends ParameterFilterBase {
    public String FilteredVariableName = null;
    public boolean StoreOutput = false;
    public String StoreOutputVariableName = null;

    @Override
    public Set<String> GetInputVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.FilteredVariableName);
        return vars;
    }

    @Override
    public Set<String> GetStoreOutputVariableName() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.StoreOutputVariableName);
        return vars;
    }

    private boolean IsDataTypeValidForFiltering(NamedDataType ndt) throws ExecutionValidationException {
        if (ndt.Value instanceof DataTypeConvertable) {
            return true;
        }
        return ndt.Value instanceof DataTypeArray && DataTypeUtils.GetComponentDataTypeOfArrayInitializingCode(((DataTypeArray)ndt.Value).GetArrayClassCode()).equals((Object)IDataType.DataTypes.Convertable);
    }

    private Class<?> FindComponentType(Object array) throws ExecutionValidationException, ExecutionRunTimeException {
        if (!array.getClass().isArray()) {
            return array.getClass();
        }
        Class<?> arrCompType = null;
        if (array.getClass().getComponentType().isArray()) {
            for (int i = 0; i < Array.getLength(array); ++i) {
                Class<?> foundCompType = this.FindComponentType(Array.get(array, i));
                if (foundCompType == null) continue;
                arrCompType = foundCompType;
                break;
            }
        } else {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (Array.get(array, i) == null) continue;
                if (!(Array.get(array, i) instanceof DataTypeConvertable)) {
                    throw new ExecutionValidationException("Array's value (" + Array.get(array, i) + ") is not of the supported ones");
                }
                arrCompType = this.ProcessConvertable((DataTypeConvertable)Array.get(array, i)).getClass();
                break;
            }
        }
        return arrCompType;
    }

    private Object CopyArray(Object source, Class<?> ComponentType) throws ExecutionValidationException, ArrayIndexOutOfBoundsException, IllegalArgumentException, ExecutionRunTimeException {
        if (!source.getClass().isArray()) {
            throw new ExecutionValidationException("Cannot copy arrays if source is not array");
        }
        Object arr = null;
        if (source.getClass().getComponentType().isArray()) {
            int[] dims = new int[DataTypeUtils.CountDimentionsOfObjectArrayCode(source.getClass().getName())];
            dims[0] = Array.getLength(source);
            arr = Array.newInstance(ComponentType, dims);
            for (int i = 0; i < Array.getLength(source); ++i) {
                Array.set(arr, i, this.CopyArray(Array.get(source, i), ComponentType));
            }
        } else {
            arr = Array.newInstance(ComponentType, Array.getLength(source));
            for (int i = 0; i < Array.getLength(source); ++i) {
                if (Array.get(source, i) == null) {
                    Array.set(arr, i, null);
                    continue;
                }
                if (!(Array.get(source, i) instanceof DataTypeConvertable)) {
                    throw new ExecutionValidationException("Array's value is not of the supported ones");
                }
                Array.set(arr, i, this.ProcessConvertable((DataTypeConvertable)Array.get(source, i)));
            }
        }
        return arr;
    }

    private Object ProcessConvertable(DataTypeConvertable ndt) throws ExecutionRunTimeException {
        if (ndt.GetConverter() == null || ndt.GetConverter().trim().length() == 0) {
            throw new ExecutionRunTimeException("No converter defined");
        }
        Object o = null;
        try {
            o = Class.forName(ndt.GetConverter()).newInstance();
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not instantiate external filter", ex);
        }
        if (!(o instanceof IObjectConverter)) {
            throw new ExecutionRunTimeException("Privided external filter is not of needed type");
        }
        try {
            Object converted = ((IObjectConverter)o).Convert(DataTypeUtils.GetValueAsString(ndt.GetConvertedValue()));
            return converted;
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not convert using external filter", ex);
        }
    }

    @Override
    public Object Process(ExecutionHandle Handle) throws ExecutionRunTimeException {
        NamedDataType ndt = Handle.GetPlan().Variables.Get(this.FilteredVariableName);
        try {
            if (!this.IsDataTypeValidForFiltering(ndt)) {
                throw new ExecutionValidationException("Object filter cann only be applied to Convertable objects or arrays of them");
            }
        }
        catch (Exception ex) {
            ExceptionUtils.ThrowTransformedRunTimeException(ex);
        }
        if (ndt.Value instanceof DataTypeConvertable) {
            return this.ProcessConvertable((DataTypeConvertable)ndt.Value);
        }
        if (ndt.Value instanceof DataTypeArray) {
            Object valArray = null;
            Object array = ((DataTypeArray)ndt.Value).GetValue();
            if (!array.getClass().isArray()) {
                throw new ExecutionRunTimeException("Object filter cann only be applied to Convertable objects or arrays of them");
            }
            try {
                Class<?> componentType = this.FindComponentType(array);
                if (componentType == null && ((DataTypeArray)ndt.Value).GetDefaultComponentType() != null) {
                    componentType = Class.forName(((DataTypeArray)ndt.Value).GetDefaultComponentType());
                } else if (componentType == null) {
                    throw new ExecutionValidationException("Cannot instantiate an array of convertables if no element is present and no default component type is set because no type can be infered");
                }
                valArray = this.CopyArray(array, componentType);
            }
            catch (Exception ex) {
                ExceptionUtils.ThrowTransformedRunTimeException(ex);
            }
            return valArray;
        }
        throw new ExecutionRunTimeException("Object filter cann only be applied to Convertable objects or arrays of them");
    }

    @Override
    public Object ProcessOnLine(Object OnLineFilteredValue, Set<NamedDataType> AdditionalValueProviders, ExecutionHandle Handle) throws ExecutionRunTimeException {
        throw new ExecutionRunTimeException("On line filtering is not supported");
    }

    @Override
    public boolean StoreOutput() {
        return this.StoreOutput;
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.FilteredVariableName == null || this.FilteredVariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Expected parameter name not provided");
        }
        if (this.StoreOutput && (this.StoreOutputVariableName == null || this.StoreOutputVariableName.trim().length() == 0)) {
            throw new ExecutionValidationException("No output variable name defined to store output");
        }
        this.TokenMappingValidate();
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.Validate();
        if (!Handle.GetPlan().Variables.Contains(this.FilteredVariableName)) {
            throw new ExecutionValidationException("Needed parameter not found");
        }
        NamedDataType ndt = Handle.GetPlan().Variables.Get(this.FilteredVariableName);
        if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.FilteredVariableName)) {
            throw new ExecutionValidationException("Needed variable not available");
        }
        if (!this.IsDataTypeValidForFiltering(ndt)) {
            throw new ExecutionValidationException("Filtered variable is not of expected type");
        }
        if (this.StoreOutput) {
            for (String storeVarName : this.GetStoreOutputVariableName()) {
                if (Handle.GetPlan().Variables.Contains(storeVarName)) continue;
                throw new ExecutionValidationException("Needed parameter to store output not present");
            }
        }
    }

    @Override
    public boolean SupportsOnLineFiltering() {
        return false;
    }

    @Override
    public void ValidateForOnlineFiltering() throws ExecutionValidationException {
        throw new ExecutionValidationException("On line filtering is not supported");
    }

    @Override
    public void ValidatePreExecutionForOnlineFiltering(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.ValidateForOnlineFiltering();
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            Element tmp;
            if (!(XMLUtils.AttributeExists((Element)((Element)XML), (String)"type").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"order").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutput").booleanValue())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!ParameterFilterBase.FilterType.valueOf(XMLUtils.GetAttribute((Element)((Element)XML), (String)"type")).equals((Object)this.GetFilterType())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.Order = Integer.parseInt(XMLUtils.GetAttribute((Element)((Element)XML), (String)"order"));
            this.StoreOutput = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutput"));
            if (this.StoreOutput) {
                if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutputName").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.StoreOutputVariableName = XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutputName");
            }
            if ((tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"filteredVariable")) == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.FilteredVariableName = XMLUtils.GetChildText((Node)tmp);
            this.TokenMappingFromXML(XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        String outputvarString = "";
        if (this.StoreOutputVariableName != null) {
            outputvarString = "storeOutputName=\"" + this.StoreOutputVariableName + "\"";
        }
        buf.append("<filter type=\"" + this.GetFilterType().toString() + "\" order=\"" + this.GetOrder() + "\" storeOutput=\"" + Boolean.toString(this.StoreOutput) + "\" " + outputvarString + ">");
        buf.append("<filteredVariable>" + this.FilteredVariableName + "</filteredVariable>");
        buf.append(this.TokenMappingToXML());
        buf.append("</filter>");
        return buf.toString();
    }

    @Override
    public ParameterFilterBase.FilterType GetFilterType() {
        return ParameterFilterBase.FilterType.ObjectConvertable;
    }
}

