/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PlanConfig {
    private static final Set<IPlanElement.PlanElementType> SupportedRestrictActionTypes = new HashSet<IPlanElement.PlanElementType>();
    public static final int DefaultConcurrentActionsPerBoundary = 0;
    public static final float DefaultUtilization = 1.0f;
    public static final int DefaultPassBy = 0;
    public static final ConnectionMode DefaultModeOfConnection = ConnectionMode.KeepAlive;
    public static final long DefaultConnectionCallbackTimeout = 3600000L;
    public int ConcurrentActionsPerBoundary = 0;
    public float Utilization = 1.0f;
    public int PassedBy = 0;
    public List<IPlanElement.PlanElementType> RestrictActionTypes = new ArrayList<IPlanElement.PlanElementType>();
    public ConnectionMode ModeOfConnection = DefaultModeOfConnection;
    public long ConnectionCallbackTimeout = 3600000L;
    public boolean ChokeProgressReporting = false;
    public boolean ChokePerformanceReporting = false;

    public PlanConfig() {
    }

    public PlanConfig(String XML) throws ExecutionSerializationException {
        this.FromXML(XML);
    }

    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<config>");
        buf.append("<concurrentActionsPerBoundary value=\"" + this.ConcurrentActionsPerBoundary + "\"/>");
        buf.append("<utilization value=\"" + this.Utilization + "\"/>");
        buf.append("<passedBy value=\"" + this.PassedBy + "\"/>");
        buf.append("<restrictTypes>");
        for (IPlanElement.PlanElementType t : this.RestrictActionTypes) {
            if (!SupportedRestrictActionTypes.contains((Object)t)) continue;
            buf.append("<restrict name=\"" + t.toString() + "\"/>");
        }
        buf.append("</restrictTypes>");
        buf.append("<connectionMode value=\"" + (Object)((Object)this.ModeOfConnection) + "\"/>");
        buf.append("<chokeProgressReporting value=\"" + this.ChokeProgressReporting + "\"/>");
        buf.append("<chokePerformanceReporting value=\"" + this.ChokePerformanceReporting + "\"/>");
        buf.append("</config>");
        return buf.toString();
    }

    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            Element acts = XMLUtils.GetChildElementWithName((Node)XML, (String)"concurrentActionsPerBoundary");
            if (acts == null) {
                throw new ExecutionSerializationException("Invalid serailzation provided");
            }
            if (!XMLUtils.AttributeExists((Element)acts, (String)"value").booleanValue()) {
                throw new ExecutionSerializationException("Invalid serailzation provided");
            }
            this.ConcurrentActionsPerBoundary = DataTypeUtils.GetValueAsInteger(XMLUtils.GetAttribute((Element)acts, (String)"value"));
            Element util = XMLUtils.GetChildElementWithName((Node)XML, (String)"utilization");
            if (util == null) {
                throw new ExecutionSerializationException("Invalid serailzation provided");
            }
            if (!XMLUtils.AttributeExists((Element)util, (String)"value").booleanValue()) {
                throw new ExecutionSerializationException("Invalid serailzation provided");
            }
            this.Utilization = DataTypeUtils.GetValueAsFloat(XMLUtils.GetAttribute((Element)util, (String)"value"));
            Element passedBy = XMLUtils.GetChildElementWithName((Node)XML, (String)"passedBy");
            if (passedBy == null) {
                throw new ExecutionSerializationException("Invalid serailzation provided");
            }
            if (!XMLUtils.AttributeExists((Element)passedBy, (String)"value").booleanValue()) {
                throw new ExecutionSerializationException("Invalid serailzation provided");
            }
            this.PassedBy = DataTypeUtils.GetValueAsInteger(XMLUtils.GetAttribute((Element)passedBy, (String)"value"));
            Element restrlstTypesElem = XMLUtils.GetChildElementWithName((Node)XML, (String)"restrictTypes");
            if (restrlstTypesElem == null) {
                throw new ExecutionSerializationException("Invalid serailzation provided");
            }
            List restrelemlst = XMLUtils.GetChildElementsWithName((Node)restrlstTypesElem, (String)"restrict");
            if (restrelemlst == null) {
                throw new ExecutionSerializationException("Invalid serailzation provided");
            }
            this.RestrictActionTypes.clear();
            for (Element restr : restrelemlst) {
                if (!XMLUtils.AttributeExists((Element)restr, (String)"name").booleanValue()) {
                    throw new ExecutionSerializationException("Invalid serailzation provided");
                }
                IPlanElement.PlanElementType t = IPlanElement.PlanElementType.valueOf(XMLUtils.GetAttribute((Element)restr, (String)"name"));
                if (!SupportedRestrictActionTypes.contains((Object)t)) continue;
                this.RestrictActionTypes.add(t);
            }
            Element connectionModeElem = XMLUtils.GetChildElementWithName((Node)XML, (String)"connectionMode");
            if (connectionModeElem == null) {
                throw new ExecutionSerializationException("Invalid serailzation provided");
            }
            if (!XMLUtils.AttributeExists((Element)connectionModeElem, (String)"value").booleanValue()) {
                throw new ExecutionSerializationException("Invalid serailzation provided");
            }
            this.ModeOfConnection = ConnectionMode.valueOf(XMLUtils.GetAttribute((Element)connectionModeElem, (String)"value"));
            Element chokeProgressReportingElem = XMLUtils.GetChildElementWithName((Node)XML, (String)"chokeProgressReporting");
            if (chokeProgressReportingElem == null) {
                throw new ExecutionSerializationException("Invalid serailzation provided");
            }
            if (!XMLUtils.AttributeExists((Element)chokeProgressReportingElem, (String)"value").booleanValue()) {
                throw new ExecutionSerializationException("Invalid serailzation provided");
            }
            this.ChokeProgressReporting = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)chokeProgressReportingElem, (String)"value"));
            Element chokePerformanceReportingElem = XMLUtils.GetChildElementWithName((Node)XML, (String)"chokePerformanceReporting");
            if (chokePerformanceReportingElem == null) {
                throw new ExecutionSerializationException("Invalid serailzation provided");
            }
            if (!XMLUtils.AttributeExists((Element)chokePerformanceReportingElem, (String)"value").booleanValue()) {
                throw new ExecutionSerializationException("Invalid serailzation provided");
            }
            this.ChokePerformanceReporting = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)chokePerformanceReportingElem, (String)"value"));
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not retrieve configuration elements", ex);
        }
    }

    static {
        SupportedRestrictActionTypes.add(IPlanElement.PlanElementType.Boundary);
        SupportedRestrictActionTypes.add(IPlanElement.PlanElementType.Shell);
        SupportedRestrictActionTypes.add(IPlanElement.PlanElementType.WSSOAP);
        SupportedRestrictActionTypes.add(IPlanElement.PlanElementType.WSREST);
        SupportedRestrictActionTypes.add(IPlanElement.PlanElementType.POJO);
    }

    public static enum ConnectionMode {
        KeepAlive,
        Callback;

    }
}

