/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.PlanElementBase;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.utils.BackgroundExecution;
import gr.uoa.di.madgik.execution.utils.PlanElementUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FlowPlanElement
extends PlanElementBase
implements Iterable<IPlanElement> {
    private static final Logger logger = LoggerFactory.getLogger(FlowPlanElement.class);
    private String ID = UUID.randomUUID().toString();
    private String Name = FlowPlanElement.class.getSimpleName();
    public List<IPlanElement> ElementCollection = new ArrayList<IPlanElement>();
    private List<BackgroundExecution> workers = new ArrayList<BackgroundExecution>();
    private final Object synchWorker = new Object();

    @Override
    public Iterator<IPlanElement> iterator() {
        return this.ElementCollection.iterator();
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!IPlanElement.PlanElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetPlanElementType())) {
                throw new ExecutionSerializationException("plan element type missmatch");
            }
            this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            this.Name = XMLUtils.GetAttribute((Element)XML, (String)"name");
            Element listnode = XMLUtils.GetChildElementWithName((Node)XML, (String)"list");
            if (listnode == null) {
                throw new ExecutionSerializationException("Not valid serialization");
            }
            List lstmembers = XMLUtils.GetChildElementsWithName((Node)listnode, (String)"planElement");
            this.ElementCollection.clear();
            for (Element lstm : lstmembers) {
                this.ElementCollection.add(PlanElementUtils.GetPlanElement(lstm));
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String GetID() {
        return this.ID;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public IPlanElement.PlanElementType GetPlanElementType() {
        return IPlanElement.PlanElementType.Flow;
    }

    @Override
    public IPlanElement Locate(String ID) {
        if (this.ID.equals(ID)) {
            return this;
        }
        for (IPlanElement elem : this) {
            IPlanElement e = elem.Locate(ID);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    @Override
    public Set<IPlanElement> LocateActionElements() {
        HashSet<IPlanElement> acts = new HashSet<IPlanElement>();
        for (IPlanElement elem : this) {
            acts.addAll(elem.LocateActionElements());
        }
        return acts;
    }

    @Override
    public void SetName(String Name) {
        this.Name = Name;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<planElement type=\"" + this.GetPlanElementType().toString() + "\" id=\"" + this.GetID() + "\" name=\"" + this.GetName() + "\">");
        buf.append("<list>");
        for (IPlanElement elem : this) {
            buf.append(elem.ToXML());
        }
        buf.append("</list>");
        buf.append("</planElement>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.ElementCollection == null || this.ElementCollection.size() == 0) {
            throw new ExecutionValidationException("Element collection not set");
        }
        for (IPlanElement elem : this) {
            elem.Validate();
        }
    }

    @Override
    public IContingencyReaction.ReactionType[] SupportedContingencyTriggers() {
        return new IContingencyReaction.ReactionType[0];
    }

    @Override
    public boolean SupportsContingencyTriggers() {
        return false;
    }

    @Override
    public List<ContingencyTrigger> GetContingencyTriggers() {
        return new ArrayList<ContingencyTrigger>();
    }

    @Override
    public void SetContingencyResourcePick(ExecutionHandle Handle, String Pick) throws ExecutionRunTimeException {
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (IPlanElement elem : this.ElementCollection) {
            vars.addAll(elem.GetModifiedVariableNames());
        }
        return vars;
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (IPlanElement elem : this.ElementCollection) {
            vars.addAll(elem.GetNeededVariableNames());
        }
        return vars;
    }

    @Override
    public Logger GetExtenderLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ExecuteExtender(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionInternalErrorException, ExecutionCancelException, ExecutionBreakException {
        this.StartClock(PlanElementBase.ClockType.Total);
        this.StartClock(PlanElementBase.ClockType.Init);
        int TotalSteps = this.ElementCollection.size() + 2;
        logger.debug("Starting");
        this.CheckStatus(Handle);
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1, TotalSteps, "Starting Execution of " + this.Name));
        }
        Object object = this.synchWorker;
        synchronized (object) {
            this.StopClock(PlanElementBase.ClockType.Init);
            this.StartClock(PlanElementBase.ClockType.Children);
            for (int i = 0; i < this.ElementCollection.size(); ++i) {
                if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                    Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), "Starting Execution of sub element " + (i + 1) + " of " + this.ElementCollection.size()));
                }
                BackgroundExecution bg = new BackgroundExecution(this.ElementCollection.get(i), Handle, this.synchWorker);
                this.workers.add(bg);
                Thread t = new Thread(bg);
                t.setName(BackgroundExecution.class.getName());
                t.setDaemon(true);
                t.start();
            }
            int numberOfPreviousCompletedWorkers = 0;
            while (true) {
                int countCompleted = 0;
                for (BackgroundExecution bg : this.workers) {
                    if (!bg.ExecutionCompleted) continue;
                    ++countCompleted;
                }
                if (countCompleted > numberOfPreviousCompletedWorkers) {
                    if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                        Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1 + countCompleted, TotalSteps, "Completed Execution of a sub element (" + countCompleted + " finished of " + this.ElementCollection.size() + ")"));
                    }
                    numberOfPreviousCompletedWorkers = countCompleted;
                }
                if (countCompleted >= this.workers.size()) break;
                try {
                    this.synchWorker.wait();
                }
                catch (Exception ex) {}
            }
        }
        this.StopClock(PlanElementBase.ClockType.Children);
        this.StartClock(PlanElementBase.ClockType.Finilization);
        for (BackgroundExecution bg : this.workers) {
            if (bg.Error == null) continue;
            if (bg.Error instanceof ExecutionRunTimeException) {
                throw (ExecutionRunTimeException)bg.Error;
            }
            if (bg.Error instanceof ExecutionInternalErrorException) {
                throw (ExecutionInternalErrorException)bg.Error;
            }
            if (bg.Error instanceof ExecutionCancelException) {
                throw (ExecutionCancelException)bg.Error;
            }
            if (bg.Error instanceof ExecutionBreakException) {
                throw (ExecutionBreakException)bg.Error;
            }
            ExecutionRunTimeException rt = new ExecutionRunTimeException(bg.Error.getMessage());
            rt.SetCause(bg.Error);
            throw rt;
        }
        this.workers.clear();
        this.StopClock(PlanElementBase.ClockType.Finilization);
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), TotalSteps, TotalSteps, "Finishing Execution of " + this.Name));
        }
        logger.debug("Exiting");
        this.StopClock(PlanElementBase.ClockType.Total);
        if (!Handle.GetPlan().Config.ChokePerformanceReporting) {
            Handle.EmitEvent(this.GetPerformanceEvent());
        }
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Validate();
    }
}

