/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.variable;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.ParameterFilterBase;
import gr.uoa.di.madgik.execution.plan.element.variable.IInputParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.IParameter;
import gr.uoa.di.madgik.execution.utils.ParameterUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilteredInParameter
implements IInputParameter {
    public List<ParameterFilterBase> Filters = new ArrayList<ParameterFilterBase>();

    private Set<String> GetFilterInputVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (ParameterFilterBase filter : this.Filters) {
            vars.addAll(filter.GetInputVariableNames());
        }
        return vars;
    }

    @Override
    public boolean CanSuggestParameterValueType(ExecutionHandle Handle) {
        return false;
    }

    @Override
    public Class<?> SuggestParameterValueType(ExecutionHandle Handle) {
        return null;
    }

    @Override
    public Object GetParameterValue(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionValidationException {
        Collections.sort(this.Filters);
        Object val = null;
        for (ParameterFilterBase filter : this.Filters) {
            val = filter.Process(Handle);
            if (!filter.StoreOutput()) continue;
            for (String storeOutputVarName : filter.GetStoreOutputVariableName()) {
                Handle.GetPlan().Variables.Update(storeOutputVarName, val);
            }
        }
        return val;
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.Filters == null || this.Filters.size() == 0) {
            throw new ExecutionValidationException("No filters have been defined");
        }
        for (ParameterFilterBase filter : this.Filters) {
            filter.Validate();
        }
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.Validate();
        for (ParameterFilterBase filter : this.Filters) {
            filter.ValidatePreExecution(Handle, ExcludeAvailableConstraint);
        }
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"direction").booleanValue() || !XMLUtils.AttributeExists((Element)((Element)XML), (String)"process").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!IParameter.ParameterDirectionType.valueOf(XMLUtils.GetAttribute((Element)((Element)XML), (String)"direction")).equals((Object)this.GetDirectionType())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!IParameter.ParameterProcessType.valueOf(XMLUtils.GetAttribute((Element)((Element)XML), (String)"process")).equals((Object)this.GetProcessType())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            List fltrs = XMLUtils.GetChildElementsWithName((Node)XML, (String)"filter");
            this.Filters.clear();
            for (Element fltr : fltrs) {
                this.Filters.add(ParameterUtils.GetParameterFilter(fltr));
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
    }

    @Override
    public IParameter.ParameterDirectionType GetDirectionType() {
        return IParameter.ParameterDirectionType.In;
    }

    @Override
    public IParameter.ParameterProcessType GetProcessType() {
        return IParameter.ParameterProcessType.Filter;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<param direction=\"" + this.GetDirectionType().toString() + "\" process=\"" + this.GetProcessType().toString() + "\">");
        for (ParameterFilterBase filter : this.Filters) {
            buf.append(filter.ToXML());
        }
        buf.append("</param>");
        return buf.toString();
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (ParameterFilterBase filter : this.Filters) {
            if (!filter.StoreOutput()) continue;
            vars.addAll(filter.GetStoreOutputVariableName());
        }
        return vars;
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (String s : this.GetFilterInputVariableNames()) {
            vars.add(s);
        }
        for (ParameterFilterBase filter : this.Filters) {
            if (!filter.StoreOutput()) continue;
            vars.addAll(filter.GetStoreOutputVariableName());
        }
        return vars;
    }
}

