/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.contingency;

import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.plan.element.PlanElementBase;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyReactionRetry;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReactionHandler;
import gr.uoa.di.madgik.execution.utils.ExceptionUtils;

public class ReactionRetryHandler
implements IContingencyReactionHandler {
    private ContingencyReactionRetry Reaction = null;

    @Override
    public void SetReactionToHandle(IContingencyReaction Reaction) throws ExecutionInternalErrorException {
        if (!(Reaction instanceof ContingencyReactionRetry)) {
            throw new ExecutionInternalErrorException("Reaction type set not of the expected type");
        }
        this.Reaction = (ContingencyReactionRetry)Reaction;
    }

    @Override
    public IContingencyReaction GetReactionToHandle() {
        return this.Reaction;
    }

    @Override
    public void Handle(String ID, Exception ex, ExecutionHandle Handle, PlanElementBase PlanElement) throws ExecutionRunTimeException, ExecutionInternalErrorException, ExecutionCancelException, ExecutionBreakException {
        boolean successfulRetry = true;
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(ID, "Applying reaction handler " + this.GetReactionToHandle().GetReactionType().toString()));
        }
        for (int i = 0; i < this.Reaction.NumberOfRetries; ++i) {
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(ID, "Applying reaction handler " + this.GetReactionToHandle().GetReactionType().toString() + " after waiting for a period of " + this.Reaction.RetryInterval + " milliseconds"));
            }
            try {
                if (this.Reaction.RetryInterval > 0L) {
                    Thread.sleep(this.Reaction.RetryInterval);
                }
            }
            catch (Exception exx) {
                // empty catch block
            }
            try {
                PlanElement.ExecuteWithStateAwareness(Handle);
            }
            catch (Exception exx) {
                successfulRetry = false;
            }
            if (successfulRetry) break;
        }
        if (!successfulRetry) {
            ExceptionUtils.ThrowTransformedException(ex);
        }
    }
}

