/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.accounting.record;

import java.util.Date;
import java.util.Map;
import java.util.UUID;

public abstract class ExecutionUsageRecord {
    private String id = UUID.randomUUID().toString();
    private String consumerId;
    private Date createTime;
    private Date startTime;
    private Date endTime;
    protected String resourceType;
    private String resourceScope;
    private String resourceOwner;
    private Map<String, String> resourceProperties;

    public ExecutionUsageRecord(String consumerId, Date startTime, Date endTime, String scope, String owner, Map<String, String> props) {
        this.consumerId = consumerId;
        this.createTime = new Date();
        this.startTime = startTime;
        this.endTime = endTime;
        this.resourceScope = scope;
        this.resourceOwner = owner;
        this.resourceProperties = props;
    }

    public String toString() {
        return "ExecutionUsageRecord [id=" + this.id + ", consumerId=" + this.consumerId + ", createTime=" + this.createTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", resourceType=" + this.resourceType + ", recourceScope=" + this.resourceScope + ", resourceOwner=" + this.resourceOwner + ", resourceProperties=" + this.resourceProperties + "]";
    }

    public String getId() {
        return this.id;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceScope() {
        return this.resourceScope;
    }

    public String getResourceOwner() {
        return this.resourceOwner;
    }

    public Map<String, String> getResourceProperties() {
        return this.resourceProperties;
    }
}

