/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.is.elements;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemSerializationException;
import gr.uoa.di.madgik.environment.is.elements.ExtensionPair;
import gr.uoa.di.madgik.environment.is.elements.IInformationSystemElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodeInfo
implements IInformationSystemElement {
    private static final long serialVersionUID = 6956949451207441009L;
    public String ID = UUID.randomUUID().toString();
    public Map<String, ExtensionPair> StaticExtensions = new HashMap<String, ExtensionPair>();
    public Map<String, ExtensionPair> DynamicExtensions = new HashMap<String, ExtensionPair>();

    @Override
    public Map<String, ExtensionPair> getStaticInfo() {
        return this.StaticExtensions;
    }

    @Override
    public Map<String, ExtensionPair> getDynamicInfo() {
        return this.DynamicExtensions;
    }

    public String getExtension(String key) {
        if (this.StaticExtensions.containsKey(key)) {
            return this.StaticExtensions.get((Object)key).Value;
        }
        if (this.DynamicExtensions.containsKey(key)) {
            return this.DynamicExtensions.get((Object)key).Value;
        }
        return null;
    }

    @Override
    public String ToXML(boolean includeStatic, boolean includeDynamic) throws EnvironmentInformationSystemSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<element id=\"" + this.ID + "\">");
        buf.append("<static>");
        if (includeStatic) {
            for (ExtensionPair entry : this.StaticExtensions.values()) {
                buf.append("<entry key=\"" + entry.Key + "\">" + entry.Value + "</entry>");
            }
        }
        buf.append("</static>");
        buf.append("<dynamic>");
        if (includeDynamic) {
            for (ExtensionPair entry : this.DynamicExtensions.values()) {
                buf.append("<entry key=\"" + entry.Key + "\">" + entry.Value + "</entry>");
            }
        }
        buf.append("</dynamic>");
        buf.append("</element>");
        return buf.toString();
    }

    @Override
    public void FromXML(String xml) throws EnvironmentInformationSystemSerializationException {
        try {
            Document doc = XMLUtils.Deserialize((String)xml);
            this.FromXML(doc.getDocumentElement());
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemSerializationException("Could not parse provided info", ex);
        }
    }

    @Override
    public void FromXML(Element xml) throws EnvironmentInformationSystemSerializationException {
        try {
            Element dynamicElement;
            this.StaticExtensions.clear();
            this.DynamicExtensions.clear();
            if (!XMLUtils.AttributeExists((Element)xml, (String)"id").booleanValue()) {
                throw new EnvironmentInformationSystemSerializationException("No id provided for element");
            }
            this.ID = XMLUtils.GetAttribute((Element)xml, (String)"id");
            Element staticElement = XMLUtils.GetChildElementWithName((Node)xml, (String)"static");
            if (staticElement != null) {
                List mapElem = XMLUtils.GetChildElementsWithName((Node)staticElement, (String)"entry");
                for (Element elem : mapElem) {
                    ExtensionPair pair = new ExtensionPair();
                    pair.Key = XMLUtils.GetAttribute((Element)elem, (String)"key");
                    pair.Value = XMLUtils.GetChildText((Node)elem);
                    if (pair.Key == null || pair.Key.trim().length() == 0) continue;
                    this.StaticExtensions.put(pair.Key, pair);
                }
            }
            if ((dynamicElement = XMLUtils.GetChildElementWithName((Node)xml, (String)"dynamic")) != null) {
                List mapElem = XMLUtils.GetChildElementsWithName((Node)dynamicElement, (String)"entry");
                for (Element elem : mapElem) {
                    ExtensionPair pair = new ExtensionPair();
                    pair.Key = XMLUtils.GetAttribute((Element)elem, (String)"key");
                    pair.Value = XMLUtils.GetChildText((Node)elem);
                    if (pair.Key == null || pair.Key.trim().length() == 0) continue;
                    this.DynamicExtensions.put(pair.Key, pair);
                }
            }
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemSerializationException("Could not parse provided info", ex);
        }
    }
}

