/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.cms.elements.part;

import gr.uoa.di.madgik.cms.elements.DocumentProperty;
import gr.uoa.di.madgik.cms.elements.document.Document;
import gr.uoa.di.madgik.environment.exception.EnvironmentContentManagementSystemException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;

public abstract class DocumentPart {
    public String id;
    public String name;
    public int order;
    public byte[] content;
    public String contentLocator;
    private InputStream inboundContentStream;
    public String schemaName;
    public String schemaUri;
    public String creationTime;
    public String lastUpdate;
    public Document document;
    public String language;
    public long length;
    public String mimeType;
    public String type;
    public DocumentPart previous;
    public Map<String, DocumentProperty> properties;

    public abstract InputStream ResolveContent() throws Exception;

    public InputStream GetContentStream() throws EnvironmentContentManagementSystemException {
        try {
            if (this.inboundContentStream != null) {
                return this.inboundContentStream;
            }
            if (this.contentLocator != null) {
                if (this.contentLocator == null) {
                    return null;
                }
                return new URI(this.contentLocator).toURL().openStream();
            }
            if (this.content != null) {
                ByteArrayInputStream ins = new ByteArrayInputStream(this.content);
                return ins;
            }
            return null;
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not get content stream for document", e);
        }
    }

    public void SetInboundContentStream(InputStream is) {
        this.inboundContentStream = is;
    }
}

