/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.securitymanager.task;

import java.util.ArrayList;
import java.util.Properties;
import java.util.TimerTask;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vomanagement.vomsapi.VOMSAttributeManager;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfiguration;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfigurationProperty;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIFactory;
import org.gcube.vomanagement.vomsapi.impl.utils.VOMSServerBean;
import org.gcube.vomanagement.vomsapi.securitymanager.task.VomsProxyConsumer;
import org.gcube.vomanagement.vomsapi.securitymanager.task.bean.VOMSServerInformationBean;
import org.gridforum.jgss.ExtendedGSSCredential;

public class VomsProxyTask
extends TimerTask {
    private GCUBELog logger = new GCUBELog(this.getClass());
    private ExtendedGSSCredential serviceCredential;
    private ExtendedGSSCredential attributedCredential;
    private VomsProxyConsumer consumer;
    private VOMSAttributeManager attributeManager;
    private int lifetime;
    private final String TASK_NAME_PREFIX = "VOMS_PROXY_RENEWAL";
    public static final int STANDARD_LIFETIME_SEC = 28800;
    public String name;

    public VomsProxyTask(String serviceName, ExtendedGSSCredential serviceCredential, VOMSServerInformationBean configurationBean, VomsProxyConsumer consumer, int lifetime) throws Exception {
        this.logger.debug((Object)"initialising voms proxy credential renewer");
        this.consumer = consumer;
        this.serviceCredential = serviceCredential;
        this.attributeManager = this.generateVOMSAttributeManager(configurationBean);
        this.lifetime = lifetime <= 0 ? -1 : lifetime;
        this.name = "VOMS_PROXY_RENEWAL_" + serviceName;
        this.logger.debug((Object)("lifetime = " + this.lifetime));
    }

    public VomsProxyTask(String serviceName, ExtendedGSSCredential serviceCredential, VOMSServerInformationBean configurationBean, VomsProxyConsumer consumer) throws Exception {
        this(serviceName, serviceCredential, configurationBean, consumer, -1);
    }

    @Override
    public void run() {
        try {
            this.attributedCredential = this.attributeManager.generateAttributedCredentials(this.serviceCredential);
            this.consumer.setVomsProxyCredentials(this.attributedCredential);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to generate the service identity assertion", (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public long getTimerPeriod() {
        long baseTimer = this.lifetime == -1 ? 28800L : (long)this.lifetime;
        this.logger.debug((Object)("Base timer = " + baseTimer));
        return baseTimer / 2L * 1000L;
    }

    private VOMSAttributeManager generateVOMSAttributeManager(VOMSServerInformationBean configurationBean) throws Exception {
        this.logger.debug((Object)"Generating credential manager");
        this.logger.debug((Object)"Generating properties structure");
        Properties props = new Properties();
        props.setProperty(VOMSAPIConfigurationProperty.VOMS_HOST.toString(), configurationBean.getVomsHost());
        props.setProperty(VOMSAPIConfigurationProperty.VO_NAME.toString(), configurationBean.getVoName());
        props.setProperty(VOMSAPIConfigurationProperty.VOMS_PORT.toString(), configurationBean.getVomsAdminPort());
        props.setProperty(VOMSAPIConfigurationProperty.RUNS_IN_WS_CORE.toString(), "true");
        this.logger.debug((Object)"Properties structure generated");
        this.logger.debug((Object)"Generating Credential Manager");
        VOMSAPIConfiguration vomsApiConfiguration = new VOMSAPIConfiguration(props);
        vomsApiConfiguration.setCredentials(configurationBean.getVomsAdminCredentials());
        VOMSAPIFactory factory = new VOMSAPIFactory(new VOMSAPIConfiguration(props));
        VOMSServerBean serverBean = configurationBean.getVomsServerBean();
        if (serverBean != null) {
            ArrayList<VOMSServerBean> serverList = new ArrayList<VOMSServerBean>();
            serverList.add(configurationBean.getVomsServerBean());
            factory.setServerList(serverList);
        }
        VOMSAttributeManager vomsManager = factory.getVOMSAttributeManager();
        this.logger.debug((Object)"Credential Manager generated");
        return vomsManager;
    }
}

