/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.um.rest.utils;

import it.eng.rdlab.soa3.um.rest.bean.UserModel;
import it.eng.rdlab.soa3.um.rest.conf.ConfigurationManager;
import it.eng.rdlab.um.beans.GenericModel;
import it.eng.rdlab.um.beans.GenericModelWrapper;
import it.eng.rdlab.um.ldap.configuration.LdapConfiguration;
import it.eng.rdlab.um.ldap.service.LdapManager;
import it.eng.rdlab.um.ldap.user.bean.LdapUserModel;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    static Logger logger = Logger.getLogger((String)Utils.class.getName());

    public static String organizationDNBuilder(String organizationName) {
        if (organizationName == null || organizationName.trim().length() == 0) {
            return ConfigurationManager.getInstance().getLdapBase();
        }
        StringBuilder distinguishedNameBuilder = new StringBuilder("dc=");
        distinguishedNameBuilder.append(organizationName).append(",").append(ConfigurationManager.getInstance().getLdapBase());
        logger.debug((Object)("dn = " + distinguishedNameBuilder.toString()));
        return distinguishedNameBuilder.toString();
    }

    public static String userDNBuilder(String userId, String organizationName) {
        StringBuilder distinguishedNameBuilder = new StringBuilder("uid=");
        distinguishedNameBuilder.append(userId).append(",ou=").append("people").append(",").append(Utils.organizationDNBuilder((String)organizationName));
        logger.debug((Object)("dn = " + distinguishedNameBuilder.toString()));
        return distinguishedNameBuilder.toString();
    }

    public static String roleDNBuilder(String roleId, String organizationName) {
        StringBuilder distinguishedNameBuilder = new StringBuilder("cn=");
        distinguishedNameBuilder.append(roleId).append(",ou=").append("roles").append(",").append(Utils.organizationDNBuilder((String)organizationName));
        logger.debug((Object)("dn = " + distinguishedNameBuilder.toString()));
        return distinguishedNameBuilder.toString();
    }

    public static String groupDNBuilder(String groupId, String organizationName) {
        StringBuilder distinguishedNameBuilder = new StringBuilder("cn=");
        distinguishedNameBuilder.append(groupId).append(",ou=").append("groups").append(",").append(Utils.organizationDNBuilder((String)organizationName));
        logger.debug((Object)("dn = " + distinguishedNameBuilder.toString()));
        return distinguishedNameBuilder.toString();
    }

    public static String getOrganizationNameFromDN(String organizationDn) {
        try {
            String organizationName = organizationDn.substring(organizationDn.indexOf(61) + 1, organizationDn.indexOf(","));
            logger.debug((Object)("Organization name = " + organizationName));
            return organizationName;
        }
        catch (Exception e) {
            logger.error((Object)"Invalid organization DN", (Throwable)e);
            return null;
        }
    }

    public static void initLdap(String adminUsername, String adminPassword, String ldapUrl) throws NamingException {
        LdapConfiguration configuration = new LdapConfiguration();
        configuration.setUrl(ldapUrl);
        configuration.setUserDn(adminUsername);
        configuration.setPassword(adminPassword);
        LdapManager.initInstance((LdapConfiguration)configuration);
    }

    public static UserModel convertUserModel(LdapUserModel ldapUserModel) {
        String certDN;
        UserModel model = new UserModel();
        model.setUserId(ldapUserModel.getUserId());
        String email = new GenericModelWrapper((GenericModel)ldapUserModel).getStringParameter("mail");
        if (email.length() > 0) {
            model.setEmail(email);
        }
        if ((certDN = new GenericModelWrapper((GenericModel)ldapUserModel).getStringParameter("givenName")).length() > 0) {
            model.setCertDN(certDN);
        }
        model.setFirstname(ldapUserModel.getCN());
        model.setLastname(ldapUserModel.getSN());
        if (ldapUserModel.getPassword() != null) {
            model.setPassword(new String(ldapUserModel.getPassword()));
        }
        return model;
    }

    public static String generatePeopleDN(String organizationName) {
        StringBuilder builder = new StringBuilder("ou=");
        builder.append("people").append(",").append(Utils.organizationDNBuilder((String)organizationName));
        return builder.toString();
    }

    public static String generateGroupsDN(String organizationName) {
        StringBuilder builder = new StringBuilder("ou=");
        builder.append("groups").append(",").append(Utils.organizationDNBuilder((String)organizationName));
        return builder.toString();
    }

    public static String generateRolesDN(String organizationName) {
        StringBuilder builder = new StringBuilder("ou=");
        builder.append("roles").append(",").append(Utils.organizationDNBuilder((String)organizationName));
        return builder.toString();
    }

    public static ObjectMapper getMapper() {
        ObjectMapper mapper = new ObjectMapper();
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        mapper.getDeserializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        mapper.getSerializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        return mapper;
    }
}

