/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.um.rest.jaxrs;

import com.sun.jersey.api.core.HttpContext;
import it.eng.rdlab.soa3.um.rest.bean.RoleModel;
import it.eng.rdlab.soa3.um.rest.conf.ConfigurationManager;
import it.eng.rdlab.soa3.um.rest.exceptions.UMJSONParserException;
import it.eng.rdlab.soa3.um.rest.impl.RoleManagerImpl;
import it.eng.rdlab.soa3.um.rest.jaxrs.bean.RoleJaxbBean;
import it.eng.rdlab.soa3.um.rest.jaxrs.bean.RolesJaxbBean;
import it.eng.rdlab.soa3.um.rest.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;

@Path(value="/rolemanager")
public class RoleManager {
    private RoleManagerImpl roleManager;
    private ConfigurationManager cm;
    private String AdminDN = "";
    private String AdminPass = "";
    private Log logger = LogFactory.getLog(this.getClass());

    public RoleManager() throws Exception {
        this.cm = ConfigurationManager.getInstance();
        this.AdminDN = this.cm.getLdapUserDN();
        this.AdminPass = this.cm.getLdapPwd();
        this.roleManager = new RoleManagerImpl(this.cm.getLdapUrl());
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/{organizationName}")
    public Response createRole(@PathParam(value="organizationName") String organizationName, RoleJaxbBean roleBean, @Context HttpContext context) {
        String roleName = roleBean.getRoleName();
        this.logger.debug((Object)roleName);
        String roleId = this.roleManager.createRole(roleName, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        if (roleId == null) {
            this.logger.error((Object)("Role was not created" + roleName));
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Role  " + roleName + " was not created, check if the role already exists")).build());
        }
        this.logger.debug((Object)("Role has been created successfully " + roleName));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Role has been created successfully ").build();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response createRole(RoleJaxbBean rolebean, @Context HttpContext context) {
        return this.createRole(null, rolebean, context);
    }

    @GET
    @Path(value="/roles/{organizationName}")
    @Produces(value={"application/json"})
    public String getRoles(@PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        List roles = this.roleManager.listRolesByOrganization(organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        Iterator rolesIter = roles.iterator();
        ArrayList<String> roleNames = new ArrayList<String>();
        while (rolesIter.hasNext()) {
            RoleModel current = (RoleModel)rolesIter.next();
            roleNames.add(current.getRoleName());
        }
        try {
            String response = Utils.getMapper().writeValueAsString((Object)new RolesJaxbBean(roleNames));
            return response;
        }
        catch (JsonGenerationException e) {
            this.logger.error((Object)"get roles unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to generate JSON ", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)"get roles unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to map JSON ", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"get roles unsuccessful due to json parse error  ");
            throw new UMJSONParserException("IO Exception while parsing JSON ", (Throwable)e);
        }
    }

    @GET
    @Path(value="/roles/")
    @Produces(value={"application/json"})
    public String getRoles(@Context HttpContext context) {
        return this.getRoles(null, context);
    }

    @GET
    @Path(value="/users/{username}/{organizationName}")
    @Produces(value={"application/json"})
    public String getRolesOfUser(@PathParam(value="username") String username, @PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        List roles = this.roleManager.listRolesByUser(username, organizationName, this.AdminDN, this.AdminPass);
        Iterator usersIter = roles.iterator();
        ArrayList<String> roleNames = new ArrayList<String>();
        while (usersIter.hasNext()) {
            roleNames.add(((RoleModel)usersIter.next()).getRoleName());
        }
        try {
            String response = Utils.getMapper().writeValueAsString((Object)new RolesJaxbBean(roleNames));
            return response;
        }
        catch (JsonGenerationException e) {
            this.logger.error((Object)"get roles unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to generate JSON ", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)"get roles unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to map JSON ", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"get roles unsuccessful due to json parse error  ");
            throw new UMJSONParserException("IO Exception while parsing JSON ", (Throwable)e);
        }
    }

    @GET
    @Path(value="/users/{username}")
    @Produces(value={"application/json"})
    public String getRolesOfUser(@PathParam(value="username") String username, @Context HttpContext context) {
        return this.getRolesOfUser(username, null, context);
    }
}

