/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.um.rest.jaxrs;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.util.Base64;
import it.eng.rdlab.soa3.um.rest.bean.UserModel;
import it.eng.rdlab.soa3.um.rest.conf.ConfigurationManager;
import it.eng.rdlab.soa3.um.rest.exceptions.UMJSONParserException;
import it.eng.rdlab.soa3.um.rest.impl.UserManagerImpl;
import it.eng.rdlab.soa3.um.rest.jaxrs.bean.CredentialsJaxbBean;
import it.eng.rdlab.soa3.um.rest.jaxrs.bean.GroupJaxbBean;
import it.eng.rdlab.soa3.um.rest.jaxrs.bean.RoleJaxbBean;
import it.eng.rdlab.soa3.um.rest.jaxrs.bean.UserJaxbBean;
import it.eng.rdlab.soa3.um.rest.jaxrs.bean.UsersJaxbBean;
import it.eng.rdlab.soa3.um.rest.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;

@Path(value="/usermanager")
public class UserManager {
    private UserManagerImpl userManager;
    private ConfigurationManager cm;
    private Log logger = LogFactory.getLog(this.getClass());

    public UserManager() throws Exception {
        this.cm = ConfigurationManager.getInstance();
        this.userManager = new UserManagerImpl(this.cm.getLdapUrl());
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response createUser(UserJaxbBean userJaxbBean, @Context HttpContext context) {
        String userName;
        String organizationName;
        this.logger.debug((Object)"Creating new user...");
        UserManagerImpl userManager = new UserManagerImpl(this.cm.getLdapUrl());
        String username = userJaxbBean.getUsername();
        UserModel userModel = new UserModel(username, userJaxbBean.getFirstname(), userJaxbBean.getLastname(), userJaxbBean.getPassword());
        if (userJaxbBean.getCertificateDN() != null) {
            userModel.setCertDN(userJaxbBean.getCertificateDN());
        }
        if ((organizationName = userJaxbBean.getOrganizationName()) == null || organizationName.length() == 0) {
            this.logger.debug((Object)("Organization Name is null. Set organization to " + this.cm.getLdapDummyRoot()));
            organizationName = this.cm.getLdapDummyRoot();
        }
        if ((userName = userManager.createUser(userModel, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd())) == null) {
            this.logger.error((Object)("User was not created" + username));
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("User  " + username + " was not created")).build());
        }
        this.logger.debug((Object)("User has been created successfully " + username));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"User has been created successfully ").build();
    }

    @PUT
    @Path(value="/{username}/{organizationName:[^;/]*}")
    @Consumes(value={"application/json"})
    public Response changePassword(@PathParam(value="username") String userName, CredentialsJaxbBean credsBean, @PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        this.logger.debug((Object)"Changing password..");
        int responseCode = this.userManager.changePassword(userName, credsBean.getOldpassword(), credsBean.getNewpassword(), organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        switch (responseCode) {
            case 0: {
                this.logger.debug((Object)("User change password successful " + userName));
                return Response.status((Response.Status)Response.Status.OK).entity((Object)"User change password successful  ").build();
            }
            case 1: {
                this.logger.error((Object)("User password cannot be changed for user " + userName + " because the current password provided is not correct"));
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("user  " + userName + " password cannot be changed  because the current password provided is not correct ")).build());
            }
            case 2: {
                this.logger.error((Object)("User password cannot be changed for user " + userName + " because the current password is equal to the new password"));
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("For user  " + userName + " password cannot be changed  because the current password  is equal to the new password ")).build());
            }
            case 3: {
                this.logger.error((Object)("User password cannot be changed for user " + userName + " because the new password value is invalid"));
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("For user  " + userName + " password cannot be changed   because the  new password value is invalid")).build());
            }
            case 4: {
                this.logger.error((Object)("User password cannot be changed for user " + userName + " because the user is not present"));
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("For user  " + userName + " password cannot be changed  because the user is not present ")).build());
            }
        }
        this.logger.error((Object)("User password cannot be changed for user " + userName + " due to internal server error"));
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("For user  " + userName + " due to internal server error ")).build());
    }

    @PUT
    @Path(value="/update")
    @Consumes(value={"application/json"})
    public Response updateUser(UserJaxbBean userJaxbBean, @Context HttpContext context) {
        this.logger.debug((Object)"Updating user...");
        this.logger.debug((Object)"Trying to update all the fields but password");
        if (userJaxbBean.getPassword() != null) {
            this.logger.warn((Object)"For updating password use the specific REST call");
        }
        UserManagerImpl userManager = new UserManagerImpl(this.cm.getLdapUrl());
        String username = userJaxbBean.getUsername();
        UserModel userModel = new UserModel(username, userJaxbBean.getFirstname(), userJaxbBean.getLastname(), null);
        if (userJaxbBean.getCertificateDN() != null) {
            userModel.setCertDN(userJaxbBean.getCertificateDN());
        }
        if (userJaxbBean.getOrganizationName() == null || userJaxbBean.getOrganizationName().length() == 0) {
            this.logger.debug((Object)("Organization Name is null. Set organization to " + this.cm.getLdapDummyRoot()));
            userJaxbBean.setOrganizationName(this.cm.getLdapDummyRoot());
        }
        if (!userManager.updateUser(userModel, userJaxbBean.getOrganizationName(), this.cm.getLdapUserDN(), this.cm.getLdapPwd())) {
            this.logger.error((Object)("User was not updated" + username));
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)("User  " + username + " was not updated")).build());
        }
        this.logger.debug((Object)("User has been updated successfully " + username));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"User has been updated successfully ").build();
    }

    @GET
    @Path(value="/{username}/{organizationName:[^;/]*}")
    public Response getUser(@PathParam(value="username") String username, @PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        UserModel user;
        this.logger.debug((Object)"Getting user");
        if (organizationName == null || organizationName.isEmpty()) {
            organizationName = this.cm.getLdapDummyRoot();
        }
        if ((user = this.userManager.getUser(username, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd())) == null) {
            this.logger.error((Object)("user not present " + username));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("User  " + username + " is not present under organization " + organizationName)).build();
        }
        try {
            UserJaxbBean responseBean = new UserJaxbBean(user.getUserId(), user.getFirstname(), user.getLastname(), user.getPassword());
            responseBean.setCertificateDN(user.getCertDN());
            if (organizationName != null && organizationName.trim().length() > 0) {
                responseBean.setOrganizationName(organizationName);
            }
            String value = Utils.getMapper().writeValueAsString((Object)responseBean);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)value).build();
        }
        catch (JsonGenerationException e) {
            this.logger.error((Object)"get user unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to generate JSON ", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)"get user unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to map JSON ", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"get user unsuccessful due to json parse error  ");
            throw new UMJSONParserException("IO Exception while parsing JSON ", (Throwable)e);
        }
    }

    @GET
    @Path(value="/users/{organizationName}")
    public String getUsers(@PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        this.logger.debug((Object)"getting users...");
        List users = this.userManager.listUsersByOrganizationAndAttributes(organizationName, null, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        Iterator usersIter = users.iterator();
        ArrayList<String> userNames = new ArrayList<String>();
        while (usersIter.hasNext()) {
            userNames.add(((UserModel)usersIter.next()).getUserId());
        }
        try {
            String response = Utils.getMapper().writeValueAsString((Object)new UsersJaxbBean(userNames));
            return response;
        }
        catch (JsonGenerationException e) {
            this.logger.error((Object)"get users unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to generate JSON ", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)"get users unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to map JSON ", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"get users unsuccessful due to json parse error  ");
            throw new UMJSONParserException("IO Exception while parsing JSON ", (Throwable)e);
        }
    }

    @GET
    @Path(value="/users")
    public String getUsers(@Context HttpContext context) {
        return this.getUsers(this.cm.getLdapDummyRoot(), context);
    }

    @GET
    @Path(value="/certificate/{certificateDN}/{organizationName:[^;/]*}")
    public Response getUserByDN(@PathParam(value="certificateDN") String certificateDN, @PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        this.logger.debug((Object)"getting users...");
        if (certificateDN == null || certificateDN.trim().isEmpty()) {
            this.logger.error((Object)"DN null");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"DN null").build();
        }
        certificateDN = Base64.base64Decode((String)certificateDN);
        this.logger.debug((Object)("DN = " + certificateDN));
        if (organizationName == null || organizationName.trim().isEmpty()) {
            organizationName = this.cm.getLdapDummyRoot();
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("givenName", certificateDN);
        List users = this.userManager.listUsersByOrganizationAndAttributes(organizationName, attributes, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        if (users == null || users.isEmpty()) {
            this.logger.error((Object)("User associated with dn " + certificateDN + " under organization " + organizationName + " not present "));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No user associated with dn " + certificateDN + " under organization " + organizationName + " found")).build();
        }
        if (users.size() > 1) {
            this.logger.warn((Object)("More than an user is registered with DN " + certificateDN + " using the first one"));
        } else {
            this.logger.debug((Object)"User found");
        }
        UserModel user = (UserModel)users.get(0);
        String value = user.getUserId();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)value).build();
    }

    @DELETE
    @Path(value="/{username}/{organizationName:[^;/]*}")
    public Response deleteUser(@PathParam(value="username") String username, @PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        if (this.userManager.getUser(username, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd()) != null) {
            this.logger.debug((Object)"User exists");
            boolean isDeleted = this.userManager.deleteUser(username, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
            if (isDeleted) {
                this.logger.debug((Object)("User " + username + " has been deleted"));
                return Response.status((Response.Status)Response.Status.OK).entity((Object)("User " + username + " has been deleted")).build();
            }
            this.logger.error((Object)("User " + username + " cannot be deleted"));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("User " + username + " cannot be deleted")).build();
        }
        this.logger.debug((Object)("User " + username + " doesn't exist"));
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("User " + username + " doesn't exist")).build();
    }

    @DELETE
    @Path(value="/users/{organizationName}")
    public Response deleteAllUsers(@PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        boolean isDeleted = this.userManager.deleteUsers(organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        if (isDeleted) {
            this.logger.debug((Object)("Delete all users successful: " + isDeleted));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"all users deleted successfully ").build();
        }
        this.logger.error((Object)"Delete  all user unsuccessful ");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" all users cannot be deleted  ").build();
    }

    @DELETE
    @Path(value="/users")
    public Response deleteAllUsers(@Context HttpContext context) {
        return this.deleteAllUsers(null, context);
    }

    @PUT
    @Path(value="/roles/{username}/{organizationName:[^;/]*}")
    @Consumes(value={"application/json"})
    public Response assignDismissRole(RoleJaxbBean roleBean, @PathParam(value="username") String userName, @PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        this.logger.debug((Object)"Assign/dismiss a role to an user");
        String role = roleBean.getRoleName();
        List users = this.userManager.listUsersByRole(role, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        boolean isAssigned = false;
        boolean isSuccess = false;
        Iterator usersIter = users.iterator();
        while (usersIter.hasNext() && !isAssigned) {
            isAssigned = userName.equals(((UserModel)usersIter.next()).getUserId());
        }
        String operation = null;
        if (!isAssigned) {
            operation = "assigned";
            this.logger.debug((Object)"assigning role to user ..");
            isSuccess = this.userManager.assignRoleToUser(role, userName, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        } else {
            operation = "dismissed";
            this.logger.debug((Object)"dismissing role from user ..");
            isSuccess = this.userManager.dismissRoleToUser(role, userName, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        }
        if (!isSuccess) {
            this.logger.error((Object)("User was not " + operation + " " + role));
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)("User  " + userName + " was not " + operation + " " + role)).build());
        }
        this.logger.debug((Object)("User successfully " + operation + " role " + role));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)("User " + operation + " role successfully ")).build();
    }

    @PUT
    @Path(value="/groups/{username}")
    @Consumes(value={"application/json"})
    public Response assignDismissGroup(GroupJaxbBean groupBean, @PathParam(value="username") String userName, @Context HttpContext context) {
        this.logger.debug((Object)"Assign/dismiss user to a group");
        String groupName = groupBean.getGroupName();
        String organizationName = groupBean.getOrganizationName();
        List users = this.userManager.listUsersByGroup(groupName, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        boolean isPresent = false;
        boolean isSuccess = false;
        String operation = null;
        Iterator usersIter = users.iterator();
        while (usersIter.hasNext() && !isPresent) {
            isPresent = userName.equals(((UserModel)usersIter.next()).getUserId());
        }
        if (!isPresent) {
            this.logger.debug((Object)"adding user to group ...");
            isSuccess = this.userManager.addUserToGroup(userName, groupName, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
            operation = "assigned to";
        } else {
            this.logger.debug((Object)"remove user from group ..");
            isSuccess = this.userManager.removeUserFromGroup(userName, groupName, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
            operation = "dismissed from";
        }
        if (!isSuccess) {
            this.logger.error((Object)("User was not " + operation + " group" + groupName));
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)("User  " + userName + " was not " + operation + " group " + groupName)).build());
        }
        this.logger.debug((Object)("User successfully " + operation + " group " + groupName));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)("User " + operation + " group successfully ")).build();
    }

    @GET
    @Path(value="/roles/{roleName}/organization/{organizationName}")
    public String getUsersWithRole(@PathParam(value="roleName") String roleName, @PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        this.logger.debug((Object)"Listing users with a role...");
        List users = this.userManager.listUsersByRole(roleName, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        ArrayList<String> userNames = new ArrayList<String>();
        Iterator usersIter = users.iterator();
        while (usersIter.hasNext()) {
            userNames.add(((UserModel)usersIter.next()).getUserId());
        }
        try {
            String value = Utils.getMapper().writeValueAsString((Object)new UsersJaxbBean(userNames));
            return value;
        }
        catch (JsonGenerationException e) {
            this.logger.error((Object)"get organizations unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to generate JSON ", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)"get organizations unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to map JSON ", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"get organizations unsuccessful due to json parse error  ");
            throw new UMJSONParserException("IO Exception while parsing JSON ", (Throwable)e);
        }
    }

    @GET
    @Path(value="/roles/{roleName}")
    public String getUsersWithRole(@PathParam(value="roleName") String roleName, @Context HttpContext context) {
        return this.getUsersWithRole(roleName, null, context);
    }

    @GET
    @Path(value="/groups/{groupName}/{organizationName}")
    public String getUsersWithGroup(@PathParam(value="groupName") String groupName, @PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        List users = this.userManager.listUsersByGroup(groupName, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        ArrayList<String> userNames = new ArrayList<String>();
        Iterator usersIter = users.iterator();
        while (usersIter.hasNext()) {
            userNames.add(((UserModel)usersIter.next()).getUserId());
        }
        try {
            String value = Utils.getMapper().writeValueAsString((Object)new UsersJaxbBean(userNames));
            return value;
        }
        catch (JsonGenerationException e) {
            this.logger.error((Object)"get groups unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to generate JSON ", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)"get groups unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to map JSON ", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"get groups unsuccessful due to json parse error  ");
            throw new UMJSONParserException("IO Exception while parsing JSON ", (Throwable)e);
        }
    }

    @GET
    @Path(value="/groups/{groupName}")
    public String getUsersWithGroup(@PathParam(value="groupName") String groupName, @Context HttpContext context) {
        return this.getUsersWithGroup(groupName, null, context);
    }
}

