/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.utils;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XMLUtils {
    public static String document2String(Document document) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.transform(new DOMSource(document), new StreamResult(baos));
        return baos.toString();
    }

    public static String element2String(Element element) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.transform(new DOMSource(element), new StreamResult(baos));
        return baos.toString();
    }

    public static Document string2Document(String xmlString) throws Exception {
        System.out.println(xmlString);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
        return doc;
    }

    public static Element createElement(Document rootDocument, String elementName, String textValue, String namespace) {
        Element response;
        Log logger = LogFactory.getLog(XMLUtils.class);
        logger.debug((Object)"Creating element...");
        Element element = response = namespace == null ? rootDocument.createElement(elementName) : rootDocument.createElementNS(elementName, namespace);
        if (textValue != null) {
            logger.debug((Object)("Text value = " + textValue));
            Text text = rootDocument.createTextNode(textValue);
            response.appendChild(text);
        }
        logger.debug((Object)"Element created");
        return response;
    }

    public static Element createNullElement(Document rootDocument, String elementName, String namespace) {
        Log logger = LogFactory.getLog(XMLUtils.class);
        logger.debug((Object)"Creating null element...");
        Element element = namespace == null ? rootDocument.createElement(elementName) : rootDocument.createElementNS(namespace, elementName);
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
        logger.debug((Object)"Null element created");
        return element;
    }
}

