/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.impl;

import it.eng.rdlab.soa3.connector.utils.SoapUtils;
import it.eng.rdlab.soa3.connector.utils.XMLUtils;
import it.eng.rdlab.soa3.pm.connector.beans.AttributeBean;
import it.eng.rdlab.soa3.pm.connector.beans.Obligation;
import it.eng.rdlab.soa3.pm.connector.beans.Status;
import it.eng.rdlab.soa3.pm.connector.interfaces.PolicyAdder;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PolicyAdderImpl
implements PolicyAdder {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String url;

    public PolicyAdderImpl() {
    }

    public PolicyAdderImpl(String url) {
        this();
        this.setUrl(url);
    }

    public void setUrl(String url) {
        this.url = url + "/";
    }

    private Status sendRequestForBooleanResponse(String url, Document requestDocument, String responseTag) {
        SOAPMessage message = null;
        try {
            this.logger.debug("Generating soap message");
            message = SoapUtils.generateSoapMessage((Document)requestDocument);
            this.logger.debug("Soap Message generated");
        }
        catch (Exception se) {
            this.logger.error("Unable to generate soap message", (Throwable)se);
            return new Status(2, 1);
        }
        SOAPMessage response = null;
        try {
            this.logger.debug("Sending message");
            response = SoapUtils.performCall((SOAPMessage)message, (String)url);
            this.logger.debug("Soap Message generated");
            SOAPBody responseBody = response.getSOAPBody();
            NodeList nodeList = responseBody.getElementsByTagName(responseTag);
            if (nodeList.getLength() > 0) {
                Element returnElement = (Element)nodeList.item(0);
                String result = returnElement.getTextContent();
                this.logger.debug("Result = " + result);
                if (result != null && result.equalsIgnoreCase("true")) {
                    return new Status(0, 0);
                }
            }
            return new Status(0, 1);
        }
        catch (Exception ge) {
            this.logger.error("Error in sending the message", (Throwable)ge);
            return new Status(1, 1);
        }
    }

    @Override
    public Status addNewRule(String alias, List<AttributeBean> subjectAttributes, String action, String resource, boolean permitted, Obligation obligation, boolean moveAfter) {
        try {
            if (obligation == null) {
                obligation = new Obligation();
            }
            String url = this.url + "HighLevelPolicyManagementService";
            this.logger.debug("Url = " + url);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document requestDocument = builder.newDocument();
            Element root = requestDocument.createElementNS("http://org.glite.authz/wsdl/pap/services/highlevel_policy_management", "addRule");
            this.logger.debug("Creating alias element...");
            Element aliasElement = alias == null ? XMLUtils.createNullElement((Document)requestDocument, (String)"alias", null) : XMLUtils.createElement((Document)requestDocument, (String)"alias", (String)alias, null);
            root.appendChild(aliasElement);
            this.logger.debug("Alias element created and appended");
            this.logger.debug("Creating isPermit element with value " + permitted + "...");
            Element isPermit = permitted ? XMLUtils.createElement((Document)requestDocument, (String)"isPermit", (String)"true", null) : XMLUtils.createElement((Document)requestDocument, (String)"isPermit", (String)"false", null);
            root.appendChild(isPermit);
            this.logger.debug("IsPermit element created and appended");
            this.logger.debug("Creating attribute list");
            Element attributeList = requestDocument.createElement("attributeList");
            for (AttributeBean attributeBean : subjectAttributes) {
                String key = attributeBean.getId();
                String value = attributeBean.getValue();
                this.logger.debug("Adding attribute " + key + " with value " + value);
                Element policyId = requestDocument.createElement("policyId");
                Text attribute = requestDocument.createTextNode(key + "=" + value);
                policyId.appendChild(attribute);
                attributeList.appendChild(policyId);
                this.logger.debug("Attribute added");
            }
            root.appendChild(attributeList);
            this.logger.debug("Attribute list created");
            this.logger.debug("Creating action value");
            root.appendChild(XMLUtils.createElement((Document)requestDocument, (String)"actionValue", (String)action, null));
            this.logger.debug("Action value created");
            this.logger.debug("Creating resource value");
            root.appendChild(XMLUtils.createElement((Document)requestDocument, (String)"resourceValue", (String)resource, null));
            this.logger.debug("Resource value created");
            this.logger.debug("Creating action identifier value");
            root.appendChild(XMLUtils.createNullElement((Document)requestDocument, (String)"actionIdentifier", null));
            this.logger.debug("Action rule value created");
            this.logger.debug("Creating action identifier value");
            root.appendChild(XMLUtils.createNullElement((Document)requestDocument, (String)"ruleIdentifier", null));
            this.logger.debug("Rule identifier value created");
            this.logger.debug("Creating obligation value");
            if (obligation.getValue() == null) {
                root.appendChild(XMLUtils.createNullElement((Document)requestDocument, (String)"obligationValue", null));
            } else {
                root.appendChild(XMLUtils.createElement((Document)requestDocument, (String)"obligationScope", (String)obligation.getValue(), null));
            }
            this.logger.debug("Obligation value created");
            this.logger.debug("Creating obligation scope");
            root.appendChild(XMLUtils.createElement((Document)requestDocument, (String)"obligationScope", (String)obligation.getObligationScope(), null));
            this.logger.debug("Obligation scope created");
            this.logger.debug("Creating moveAfter element with value " + moveAfter + "...");
            Element moveAfterElement = moveAfter ? XMLUtils.createElement((Document)requestDocument, (String)"moveAfter", (String)"true", null) : XMLUtils.createElement((Document)requestDocument, (String)"moveAfter", (String)"false", null);
            root.appendChild(moveAfterElement);
            this.logger.debug("MoveAfter element created and appended");
            requestDocument.appendChild(root);
            SOAPMessage message = null;
            try {
                this.logger.debug("Generating soap message");
                message = SoapUtils.generateSoapMessage((Document)requestDocument);
                this.logger.debug("Soap Message generated");
            }
            catch (Exception se) {
                this.logger.error("Unable to generate soap message", (Throwable)se);
                return new Status(2, 1);
            }
            SOAPMessage response = null;
            try {
                this.logger.debug("Sending message");
                response = SoapUtils.performCall((SOAPMessage)message, (String)url);
                this.logger.debug("Soap Message generated");
                SOAPBody responseBody = response.getSOAPBody();
                NodeList nodeList = responseBody.getElementsByTagName("addRuleReturn");
                if (nodeList.getLength() > 0) {
                    Element returnElement = (Element)nodeList.item(0);
                    String policyId = returnElement.getTextContent();
                    this.logger.debug("Policy Id = " + policyId);
                    Status responseStatus = new Status(0, 0);
                    responseStatus.setInfo(policyId);
                    return responseStatus;
                }
                this.logger.debug("Response false");
                return new Status(0, 1);
            }
            catch (Exception ge) {
                this.logger.error("Error in sending the message", (Throwable)ge);
                return new Status(1, 1);
            }
        }
        catch (ParserConfigurationException e) {
            this.logger.error("Unable to create the request", (Throwable)e);
            return new Status(2, 1);
        }
    }

    @Override
    public Status addXACMLPolicy(String alias, int index, String policySetId, String policyIdPrefix, PolicyType xacmlPolicy) {
        return this.addXACMLPolicySet(alias, index, xacmlPolicy.getDOM());
    }

    @Override
    public Status addXACMLPolicySet(String alias, int index, PolicySetType xacmlPolicySet) {
        return this.addXACMLPolicySet(alias, index, xacmlPolicySet.getDOM());
    }

    @Override
    public Status updateXACMLPolicy(String alias, int version, PolicyType xacmlPolicy) {
        return this.updateXACMLPolicy(alias, version, xacmlPolicy.getDOM());
    }

    @Override
    public Status addXACMLPolicy(String alias, int index, String policySetId, String policyIdPrefix, Element xacmlPolicy) {
        try {
            this.logger.debug("Policy class " + xacmlPolicy.getClass());
            String url = this.url + "XACMLPolicyManagementService";
            this.logger.debug("Url = " + url);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document requestDocument = builder.newDocument();
            Element root = requestDocument.createElementNS("http://services.pap.authz.glite.org", "ser:addPolicy");
            this.logger.debug("Creating alias element...");
            Element aliasElement = alias == null ? XMLUtils.createNullElement((Document)requestDocument, (String)"alias", null) : XMLUtils.createElement((Document)requestDocument, (String)"alias", (String)alias, null);
            root.appendChild(aliasElement);
            this.logger.debug("Alias element created and appended");
            this.logger.debug("Creating index value");
            root.appendChild(XMLUtils.createElement((Document)requestDocument, (String)"index", (String)String.valueOf(index), null));
            this.logger.debug("Index value created");
            this.logger.debug("Creating policy set id");
            root.appendChild(XMLUtils.createElement((Document)requestDocument, (String)"policySetId", (String)policySetId, null));
            this.logger.debug("Policy set id created");
            this.logger.debug("Creating policy prefix");
            root.appendChild(XMLUtils.createElement((Document)requestDocument, (String)"policyIdPrefix", (String)policyIdPrefix, null));
            this.logger.debug("Document class " + requestDocument.getClass());
            Node policyElementNode = requestDocument.adoptNode(xacmlPolicy);
            this.logger.debug("Policy ELement " + policyElementNode);
            root.appendChild(policyElementNode);
            this.logger.debug("Policy element added");
            this.logger.debug("MoveAfter element created and appended");
            requestDocument.appendChild(root);
            return this.sendRequestForBooleanResponse(url, requestDocument, "addPolicyResponse");
        }
        catch (ParserConfigurationException e) {
            this.logger.error("Unable to create the request", (Throwable)e);
            return new Status(2, 1);
        }
    }

    @Override
    public Status addXACMLPolicySet(String alias, int index, Element xacmlPolicySet) {
        try {
            String url = this.url + "XACMLPolicyManagementService";
            this.logger.debug("Url = " + url);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document requestDocument = builder.newDocument();
            Element root = requestDocument.createElementNS("http://services.pap.authz.glite.org", "ser:addPolicySet");
            this.logger.debug("Creating alias element...");
            Element aliasElement = alias == null ? XMLUtils.createNullElement((Document)requestDocument, (String)"alias", null) : XMLUtils.createElement((Document)requestDocument, (String)"alias", (String)alias, null);
            root.appendChild(aliasElement);
            this.logger.debug("Alias element created and appended");
            this.logger.debug("Creating index value");
            root.appendChild(XMLUtils.createElement((Document)requestDocument, (String)"index", (String)String.valueOf(index), null));
            Node policyElementNode = requestDocument.adoptNode(xacmlPolicySet);
            root.appendChild(policyElementNode);
            this.logger.debug("Policy set element added");
            requestDocument.appendChild(root);
            return this.sendRequestForBooleanResponse(url, requestDocument, "addPolicySetResponse");
        }
        catch (ParserConfigurationException e) {
            this.logger.error("Unable to create the request", (Throwable)e);
            return new Status(2, 1);
        }
    }

    @Override
    public Status updateXACMLPolicy(String alias, int version, Element policy) {
        try {
            this.logger.debug("Policy element class " + policy.getClass());
            String url = this.url + "XACMLPolicyManagementService";
            this.logger.debug("Url = " + url);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document requestDocument = builder.newDocument();
            Element root = requestDocument.createElementNS("http://services.pap.authz.glite.org", "ser:updatePolicy");
            this.logger.debug("Creating alias element...");
            Element aliasElement = alias == null ? XMLUtils.createNullElement((Document)requestDocument, (String)"alias", null) : XMLUtils.createElement((Document)requestDocument, (String)"alias", (String)alias, null);
            root.appendChild(aliasElement);
            this.logger.debug("Alias element created and appended");
            this.logger.debug("Creating version value");
            root.appendChild(XMLUtils.createElement((Document)requestDocument, (String)"version", (String)String.valueOf(version), null));
            Node policyElementNode = requestDocument.adoptNode(policy);
            this.logger.debug("Document  class " + requestDocument.getClass());
            this.logger.debug("Policy node " + policyElementNode);
            root.appendChild(policyElementNode);
            this.logger.debug("Policy element added");
            this.logger.debug("MoveAfter element created and appended");
            requestDocument.appendChild(root);
            return this.sendRequestForBooleanResponse(url, requestDocument, "updatePolicyReturn");
        }
        catch (ParserConfigurationException e) {
            this.logger.error("Unable to create the request", (Throwable)e);
            return new Status(2, 1);
        }
    }
}

