/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.connector.utils;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SoapUtils {
    public static String soapMessage2String(SOAPMessage soapMessage) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        soapMessage.writeTo((OutputStream)baos);
        String soapMessageString = new String(baos.toByteArray());
        return soapMessageString;
    }

    public static SOAPMessage generateSoapMessage(Document document) throws Exception {
        Logger logger = LoggerFactory.getLogger(SoapUtils.class);
        logger.debug("Generating soap message");
        Element queryElement = document.getDocumentElement();
        SOAPMessage soapmsg = MessageFactory.newInstance().createMessage();
        SOAPFactory sf = SOAPFactory.newInstance();
        SOAPElement bodyelement = sf.createElement(queryElement);
        logger.debug("Query Element added");
        soapmsg.getSOAPBody().addChildElement(bodyelement);
        soapmsg.saveChanges();
        logger.debug("Message completed");
        String soapString = SoapUtils.soapMessage2String(soapmsg);
        logger.debug("Message = " + soapString);
        return soapmsg;
    }

    public static SOAPMessage performCall(SOAPMessage message, String url) throws UnsupportedOperationException, SOAPException {
        return SoapUtils.performCall(message, url, true);
    }

    public static SOAPMessage performCall(SOAPMessage message, String url, boolean useSecurityManager) throws UnsupportedOperationException, SOAPException {
        Logger logger = LoggerFactory.getLogger(SoapUtils.class);
        logger.debug("url = " + url);
        SOAPConnection conn = SOAPConnectionFactory.newInstance().createConnection();
        return conn.call(message, (Object)url);
    }

    public static void main(String[] args) throws Exception {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        FileInputStream is = new FileInputStream("/etc/argus-security/hostcert.pem");
        X509Certificate cert = (X509Certificate)factory.generateCertificate(is);
        System.out.println(cert.getIssuerDN());
    }
}

