/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Properties;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.config.ContainerConfig;

public class ConfigurationManager {
    private final String SECURITY_ENABLED_DEFAULT = "false";
    private final String SOA3_DEFAULT_URL = "https://localhost";
    private final String CREDENTIAL_PROPAGATION_DEFAULT_POLICY = "true";
    private final String DEFAULT_SECURITY_CONFIGURATION = "defaultSecurityConfiguration";
    private GCUBELog log;
    private Properties properties;
    private HashMap<String, Properties> serviceSecurityConfiguration = new HashMap();
    private static ConfigurationManager instance;

    private ConfigurationManager(boolean defaultConfiguration) {
        this.log = new GCUBELog((Object)this);
        this.properties = new Properties();
        if (defaultConfiguration) {
            this.loadDefaultProperties();
        }
    }

    public static ConfigurationManager getInstance() {
        if (instance == null) {
            instance = new ConfigurationManager(true);
        }
        return instance;
    }

    private void loadDefaultProperties() {
        String pathToDefaultSecurityConfiguration = ContainerConfig.getConfig().getOption("defaultSecurityConfiguration");
        this.log.debug((Object)("Security configuration path " + pathToDefaultSecurityConfiguration));
        pathToDefaultSecurityConfiguration = GHNContext.getContext().getLocation() + File.separatorChar + pathToDefaultSecurityConfiguration;
        this.log.debug((Object)("Absolute path = " + pathToDefaultSecurityConfiguration));
        try {
            this.properties.load(new FileInputStream(pathToDefaultSecurityConfiguration));
        }
        catch (Exception e) {
            this.log.warn((Object)"Unable to load default properties", (Throwable)e);
        }
    }

    public boolean isSecurityEnabled(String serviceName) {
        String stringResponse = this.getProperty(serviceName, "SECURITY_ENABLED", "false");
        this.log.debug((Object)("Security enabled " + stringResponse));
        return this.getBooleanValue(stringResponse);
    }

    public String getServerUrl(String serviceName) {
        String response = this.getProperty(serviceName, "SERVER_URL", "https://localhost");
        this.log.debug((Object)("SOA3 Url = " + response));
        return response;
    }

    public boolean getCredentialPropagationPolicy(String serviceName) {
        String stringResponse = this.getProperty(serviceName, "CREDENTIAL_PROPAGATION_POLICY", "true");
        this.log.debug((Object)("Credential propagation " + stringResponse));
        return this.getBooleanValue(stringResponse);
    }

    private String getProperty(String serviceName, String propertyName, String defaultValue) {
        String stringResponse = null;
        this.log.debug((Object)("Service Name = " + serviceName));
        if (serviceName != null) {
            Properties serviceProperties = this.serviceSecurityConfiguration.get(serviceName);
            this.log.debug((Object)("Service Properties = " + serviceProperties));
            stringResponse = serviceProperties != null ? serviceProperties.getProperty(propertyName, this.properties.getProperty(propertyName, defaultValue)) : this.properties.getProperty(propertyName, defaultValue);
        } else {
            stringResponse = this.properties.getProperty(propertyName, defaultValue);
        }
        this.log.debug((Object)("String response = " + stringResponse));
        return stringResponse;
    }

    private boolean getBooleanValue(String stringValue) {
        return stringValue != null && stringValue.equalsIgnoreCase("true");
    }

    public void setServiceProperties(String serviceName, Properties serviceProperties) {
        this.serviceSecurityConfiguration.put(serviceName, serviceProperties);
    }

    public boolean servicePropertiesSet(String serviceName) {
        return this.serviceSecurityConfiguration.containsKey(serviceName);
    }
}

