package org.gcube.security.soa3.connector.integration.server;

import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.Set;

import javax.net.ssl.SSLContext;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.security.GCUBESecurityController;
import org.gcube.common.core.security.GCUBEServiceAuthorizationController;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.security.soa3.configuration.ConfigurationManager;
import org.gcube.security.soa3.connector.SOA3SecurityController;
import org.gcube.security.soa3.connector.integration.utils.Utils;

/**
 * 
 * Implementation of {@link GCUBEServiceAuthorizationController} to integrate the old security management system of gCube with the new one. 
 * It will become deprecated soon
 * 
 * @author Ciro Formisano (ENG)
 *
 */
public class SOA3IntegrationSecurityController implements GCUBEServiceAuthorizationController 
{

	private GCUBELog log;
	private GCUBESecurityController controller;
	private boolean isSecurityEnabled = false;
	
	public SOA3IntegrationSecurityController() 
	{
		this.log = new GCUBELog(this);
		this.controller = new SOA3SecurityController();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void initialise(GCUBEServiceContext ctxt, GCUBEServiceSecurityManager securityManager) throws Exception 
	{
		String serviceName = ctxt.getName();
		
		if (!ConfigurationManager.getInstance().servicePropertiesSet(serviceName)) Utils.setServiceProperties(ctxt,serviceName);

		log.debug("Initializing the controller");
		this.controller.init(ctxt);
		this.isSecurityEnabled = ConfigurationManager.getInstance().isSecurityEnabled(ctxt.getName());
		log.debug("Init completed");
		
		if (this.log.isDebugEnabled())
		{
			Provider[] provs = Security.getProviders();
			
			for (Provider p : provs)
			{
				this.log.debug("name "+p.getName());
				this.log.debug("version "+p.getVersion());
				Set<Provider.Service> services = p.getServices();
				
				if (services!=null && !services.isEmpty())
				{
					this.log.debug("Services:");
					
					for (Provider.Service s : services)
					{
						this.log.debug(s.getAlgorithm());
					}
					
					this.log.debug("********************");
					
				}
			}
			
			this.log.debug("#############################################################");
			
			try
			{
			
				this.log.debug("Default SSL context");
				SSLContext context = SSLContext.getDefault();
				Provider sslProvider = context.getProvider();
				this.log.debug("name "+sslProvider.getName());
				this.log.debug("version "+sslProvider.getVersion());
				Set<Provider.Service> services = sslProvider.getServices();
			
				if (services!=null && !services.isEmpty())
				{
					this.log.debug("Services:");
					
					for (Provider.Service s : services)
					{
						this.log.debug(s.getAlgorithm());
					}
					
					this.log.debug("********************");
					
				}
				
			} catch (Exception e)
			{
				this.log.error("Error in reading the sslContext",e);
			}
			
		}		

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isSecurityEnabled() 
	{
		return isSecurityEnabled;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void authoriseCall(Map<String, Object> parameters) throws GCUBEException 
	{
		log.debug("Checking the privileges...");
		
		
		if (!this.controller.checkAccess(parameters))
		{
			log.debug("Access not granted");
			throw new GCUBEUnrecoverableException("Security exception: the requirer is not authorized to perform the selected operation");
		}
		log.debug("Access granted");
	
	}

}
