/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.xacml;

import it.eng.rdlab.soa3.connector.utils.XMLUtils;
import it.eng.rdlab.soa3.pm.connector.beans.DateCondition;
import it.eng.rdlab.soa3.pm.connector.beans.DateTimeCondition;
import it.eng.rdlab.soa3.pm.connector.beans.Obligation;
import it.eng.rdlab.soa3.pm.connector.beans.TimeCondition;
import it.eng.rdlab.soa3.pm.connector.beans.TimeRelatedCondition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.xacml.policy.ApplyType;
import org.opensaml.xacml.policy.AttributeAssignmentType;
import org.opensaml.xacml.policy.AttributeDesignatorType;
import org.opensaml.xacml.policy.AttributeValueType;
import org.opensaml.xacml.policy.ConditionType;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.ExpressionType;
import org.opensaml.xacml.policy.ObligationType;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XACMLManager {
    public static final String RULE_COMBALG_DENY_OVERRIDS = "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:deny-overrides";
    public static final String RULE_COMBALG_FIRST_APPLICABLE = "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable";
    public static final String RULE_COMBALG_PERMIT_OVERRIDS = "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:permit-overrides";
    public static final String COMB_ALG_FIRST_APPLICABLE = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:first-applicable";
    public static final String COMB_ALG_ORDERED_DENY_OVERRIDS = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:ordered-deny-overrides";
    public static final String COMB_ALG_ORDERED_PERMIT_OVERRIDS = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:ordered-permit-overrides";
    private static Log log = LogFactory.getLog(XACMLManager.class);

    private static XMLObject getObject(String objectString) throws Exception {
        Document doc = XMLUtils.string2Document((String)objectString);
        Element policyElement = doc.getDocumentElement();
        UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(policyElement);
        return unmarshaller.unmarshall(policyElement);
    }

    public static PolicyType[] getPolicesFromString(String policyString) {
        try {
            Document doc = XMLUtils.string2Document((String)policyString);
            Element policiesElement = doc.getDocumentElement();
            NodeList policyNodes = policiesElement.getElementsByTagNameNS("urn:oasis:names:tc:xacml:2.0:policy:schema:os", "Policy");
            PolicyType[] policyTypeArray = new PolicyType[policyNodes.getLength()];
            for (int i = 0; i < policyNodes.getLength(); ++i) {
                Element policy = (Element)policyNodes.item(i);
                UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
                Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(policy);
                policyTypeArray[i] = (PolicyType)unmarshaller.unmarshall(policy);
            }
            return policyTypeArray;
        }
        catch (Exception e) {
            log.error((Object)"Unable to create Policy array ", (Throwable)e);
            return null;
        }
    }

    public static PolicySetType[] getPolicySetsFromString(String policySetsString) {
        try {
            Document doc = XMLUtils.string2Document((String)policySetsString);
            Element policySetsElement = doc.getDocumentElement();
            NodeList policySetNodes = policySetsElement.getElementsByTagNameNS("urn:oasis:names:tc:xacml:2.0:policy:schema:os", "PolicySet");
            PolicySetType[] policySetsTypeArray = new PolicySetType[policySetNodes.getLength()];
            for (int i = 0; i < policySetNodes.getLength(); ++i) {
                Element policySet = (Element)policySetNodes.item(i);
                UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
                Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(policySet);
                policySetsTypeArray[i] = (PolicySetType)unmarshaller.unmarshall(policySet);
            }
            return policySetsTypeArray;
        }
        catch (Exception e) {
            log.error((Object)"Unable to create Policy array ", (Throwable)e);
            return null;
        }
    }

    public static PolicyType getPolicyFromString(String policyString) {
        try {
            return (PolicyType)XACMLManager.getObject(policyString);
        }
        catch (Exception e) {
            log.error((Object)"Unable to create Policy Element", (Throwable)e);
            return null;
        }
    }

    public static PolicySetType getPolicySetFromString(String policySetString) {
        try {
            return (PolicySetType)XACMLManager.getObject(policySetString);
        }
        catch (Exception e) {
            log.error((Object)"Unable to create Policy Element", (Throwable)e);
            return null;
        }
    }

    public static Element policy2Element(PolicyType policy) {
        try {
            MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)policy);
            return marshaller.marshall((XMLObject)policy);
        }
        catch (Exception e) {
            log.error((Object)"Unable to marshall the policy", (Throwable)e);
            return null;
        }
    }

    public static ObligationType generateObligation(Obligation obligation) {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        ObligationType obligationType = (ObligationType)builderFactory.getBuilder(ObligationType.DEFAULT_ELEMENT_QNAME).buildObject(ObligationType.DEFAULT_ELEMENT_QNAME);
        obligationType.setObligationId(obligation.getValue());
        if (obligation.isFulfillOn()) {
            obligationType.setFulfillOn(EffectType.Permit);
        } else {
            obligationType.setFulfillOn(EffectType.Deny);
        }
        Map<String, Map<String, String>> attributeMap = obligation.getAttributes();
        Set<String> keySet = attributeMap.keySet();
        for (String datatype : keySet) {
            log.debug((Object)("Setting elements of datatype " + datatype));
            Map<String, String> attributes = attributeMap.get(datatype);
            Set<String> attributeNames = attributes.keySet();
            for (String attributeName : attributeNames) {
                String attributeValue = attributes.get(attributeName);
                log.debug((Object)("Attribute id = " + attributeName));
                log.debug((Object)("Attribute value = " + attributeValue));
                AttributeAssignmentType attribute = (AttributeAssignmentType)builderFactory.getBuilder(AttributeAssignmentType.DEFAULT_ELEMENT_NAME).buildObject(AttributeAssignmentType.DEFAULT_ELEMENT_NAME);
                attribute.setDataType(datatype);
                attribute.setAttributeId(attributeName);
                attribute.setValue(attributeValue);
                obligationType.getAttributeAssignments().add(attribute);
            }
        }
        return obligationType;
    }

    private static ApplyType generateAtomicTimeRelatedCondition(TimeRelatedCondition condition, Date time, String functionID, String attributeID, String dataType, String format) {
        log.debug((Object)("Generating atomic time condition " + condition));
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        ApplyType functionApply = (ApplyType)builderFactory.getBuilder(ApplyType.DEFAULT_ELEMENT_NAME).buildObject(ApplyType.DEFAULT_ELEMENT_NAME);
        functionApply.setFunctionId(condition.getCondition());
        ApplyType currentTimeApply = (ApplyType)builderFactory.getBuilder(ApplyType.DEFAULT_ELEMENT_NAME).buildObject(ApplyType.DEFAULT_ELEMENT_NAME);
        currentTimeApply.setFunctionId(functionID);
        AttributeDesignatorType envAttributeDesignator = (AttributeDesignatorType)builderFactory.getBuilder(AttributeDesignatorType.ENVIRONMENT_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME).buildObject(AttributeDesignatorType.ENVIRONMENT_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME);
        envAttributeDesignator.setAttribtueId(attributeID);
        envAttributeDesignator.setDataType(dataType);
        currentTimeApply.getExpressions().add(envAttributeDesignator);
        AttributeValueType attributeValue = (AttributeValueType)builderFactory.getBuilder(AttributeValueType.DEFAULT_ELEMENT_NAME).buildObject(AttributeValueType.DEFAULT_ELEMENT_NAME);
        attributeValue.setDataType(dataType);
        String timeExpression = XACMLManager.formatTime(time, format);
        log.debug((Object)("Time expression " + timeExpression));
        attributeValue.setValue(timeExpression);
        functionApply.getExpressions().add(currentTimeApply);
        functionApply.getExpressions().add(attributeValue);
        return functionApply;
    }

    public static ApplyType generateAtomicTimeCondition(TimeCondition condition, Date time) {
        return XACMLManager.generateAtomicTimeRelatedCondition(condition, time, "urn:oasis:names:tc:xacml:1.0:function:time-one-and-only", "urn:oasis:names:tc:xacml:1.0:environment:current-time", "http://www.w3.org/2001/XMLSchema#time", "HH:mm:ss");
    }

    public static ApplyType generateAtomicDateCondition(DateCondition condition, Date time) {
        return XACMLManager.generateAtomicTimeRelatedCondition(condition, time, "urn:oasis:names:tc:xacml:1.0:function:date-one-and-only", "urn:oasis:names:tc:xacml:1.0:environment:current-date", "http://www.w3.org/2001/XMLSchema#date", "yyyy-MM-dd");
    }

    public static ApplyType generateAtomicDateTimeCondition(DateTimeCondition condition, Date time) {
        return XACMLManager.generateAtomicTimeRelatedCondition(condition, time, "urn:oasis:names:tc:xacml:1.0:function:dateTime-one-and-only", "urn:oasis:names:tc:xacml:1.0:environment:current-dateTime", "http://www.w3.org/2001/XMLSchema#dateTime", "yyyy-MM-dd'T'HH:mm:ss");
    }

    public static ConditionType generateComplexTimeComparison(Date upperTime, Date lowerTime, boolean upperEqual, boolean lowerEqual) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        log.debug((Object)("The current time must be between " + format.format(lowerTime) + " and " + format.format(upperTime) + " upper equal " + upperEqual + "lower equal " + lowerEqual));
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        ConditionType condition = (ConditionType)builderFactory.getBuilder(ConditionType.DEFAULT_ELEMENT_NAME).buildObject(ConditionType.DEFAULT_ELEMENT_NAME);
        ApplyType functionAnd = (ApplyType)builderFactory.getBuilder(ApplyType.DEFAULT_ELEMENT_NAME).buildObject(ApplyType.DEFAULT_ELEMENT_NAME);
        functionAnd.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:and");
        log.debug((Object)"Generating upper time function...");
        TimeCondition upperTimeCondition = upperEqual ? new TimeCondition(TimeCondition.LESSER_EQUAL) : new TimeCondition(TimeCondition.LESSER);
        ApplyType upperLimit = XACMLManager.generateAtomicTimeCondition(upperTimeCondition, upperTime);
        log.debug((Object)"Upper time function generated");
        log.debug((Object)"Generating upper time function...");
        TimeCondition lowerTimeCondition = lowerEqual ? new TimeCondition(TimeCondition.GREATER_EQUAL) : new TimeCondition(TimeCondition.GREATER);
        ApplyType lowerLimit = XACMLManager.generateAtomicTimeCondition(lowerTimeCondition, lowerTime);
        log.debug((Object)"Lower time function generated");
        functionAnd.getExpressions().add(upperLimit);
        functionAnd.getExpressions().add(lowerLimit);
        condition.setExpression((ExpressionType)functionAnd);
        log.debug((Object)"Condition type generated");
        return condition;
    }

    public static ConditionType generateComplexDateComparison(Date upperDate, Date lowerDate, boolean upperEqual, boolean lowerEqual) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        log.debug((Object)("The current time must be between " + format.format(lowerDate) + " and " + format.format(upperDate) + " upper equal " + upperEqual + "lower equal " + lowerEqual));
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        ConditionType condition = (ConditionType)builderFactory.getBuilder(ConditionType.DEFAULT_ELEMENT_NAME).buildObject(ConditionType.DEFAULT_ELEMENT_NAME);
        ApplyType functionAnd = (ApplyType)builderFactory.getBuilder(ApplyType.DEFAULT_ELEMENT_NAME).buildObject(ApplyType.DEFAULT_ELEMENT_NAME);
        functionAnd.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:and");
        log.debug((Object)"Generating upper time function...");
        DateCondition upperDateCondition = upperEqual ? new DateCondition(DateCondition.LESSER_EQUAL) : new DateCondition(DateCondition.LESSER);
        ApplyType upperLimit = XACMLManager.generateAtomicDateCondition(upperDateCondition, upperDate);
        log.debug((Object)"Upper time function generated");
        log.debug((Object)"Generating upper time function...");
        DateCondition lowerDateCondition = lowerEqual ? new DateCondition(DateCondition.GREATER_EQUAL) : new DateCondition(DateCondition.GREATER);
        ApplyType lowerLimit = XACMLManager.generateAtomicDateCondition(lowerDateCondition, lowerDate);
        log.debug((Object)"Lower time function generated");
        functionAnd.getExpressions().add(upperLimit);
        functionAnd.getExpressions().add(lowerLimit);
        condition.setExpression((ExpressionType)functionAnd);
        log.debug((Object)"Condition type generated");
        return condition;
    }

    public static ConditionType generateComplexDateTimeComparison(Date upperDateTime, Date lowerDateTime, boolean upperEqual, boolean lowerEqual) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        log.debug((Object)("The current time must be between " + format.format(lowerDateTime) + " and " + format.format(upperDateTime) + " upper equal " + upperEqual + "lower equal " + lowerEqual));
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        ConditionType condition = (ConditionType)builderFactory.getBuilder(ConditionType.DEFAULT_ELEMENT_NAME).buildObject(ConditionType.DEFAULT_ELEMENT_NAME);
        ApplyType functionAnd = (ApplyType)builderFactory.getBuilder(ApplyType.DEFAULT_ELEMENT_NAME).buildObject(ApplyType.DEFAULT_ELEMENT_NAME);
        functionAnd.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:and");
        log.debug((Object)"Generating upper time function...");
        DateTimeCondition upperDateTimeCondition = upperEqual ? new DateTimeCondition(DateTimeCondition.LESSER_EQUAL) : new DateTimeCondition(DateTimeCondition.LESSER);
        ApplyType upperLimit = XACMLManager.generateAtomicDateTimeCondition(upperDateTimeCondition, upperDateTime);
        log.debug((Object)"Upper time function generated");
        log.debug((Object)"Generating upper time function...");
        DateTimeCondition lowerDateTimeCondition = lowerEqual ? new DateTimeCondition(DateTimeCondition.GREATER_EQUAL) : new DateTimeCondition(DateTimeCondition.GREATER);
        ApplyType lowerLimit = XACMLManager.generateAtomicDateTimeCondition(lowerDateTimeCondition, lowerDateTime);
        log.debug((Object)"Lower time function generated");
        functionAnd.getExpressions().add(upperLimit);
        functionAnd.getExpressions().add(lowerLimit);
        condition.setExpression((ExpressionType)functionAnd);
        log.debug((Object)"Condition type generated");
        return condition;
    }

    private static String formatTime(Date date, String format) {
        SimpleDateFormat timeFormat = new SimpleDateFormat(format + "Z");
        StringBuilder timeString = new StringBuilder(timeFormat.format(date));
        timeString.insert(timeString.length() - 2, ':');
        return timeString.toString();
    }

    public static void main(String[] args) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        StringBuilder timeString = new StringBuilder(format.format(new Date()));
        timeString.insert(timeString.length() - 2, ':');
        System.out.println(timeString.toString());
    }
}

