/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.integration;

import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.security.soa3.connector.integration.utils.Utils;
import org.w3c.dom.Element;

public class TokenCredentials
implements SecurityCredentials {
    private GCUBELog log;
    private String type;
    private String value;

    public TokenCredentials(String type, String binaryTokenValue) {
        this.log = new GCUBELog((Object)this);
        this.type = type;
        this.value = binaryTokenValue;
    }

    public TokenCredentials(Element token) {
        this.type = token.getAttribute("EncodingType");
        this.value = token.getAttribute("Id");
    }

    public String getCredentialsAsString() throws Exception {
        return this.type + " " + this.value;
    }

    public Object getCredentialsAsObject() {
        try {
            return Utils.generateBinaryTokenElement(this.type, this.value);
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to produce security token", (Throwable)e);
            return null;
        }
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }
}

