/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.integration;

import javax.xml.soap.SOAPException;
import org.apache.axis.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.security.soa3.connector.integration.utils.Utils;
import org.gcube.soa3.connector.common.security.Credentials;
import org.gcube.soa3.connector.common.security.messages.MessageManager;

public class StubMessageManager
implements MessageManager {
    private Log log = LogFactory.getLog(this.getClass());
    private Stub stub;

    public StubMessageManager(Stub stub) {
        this.stub = stub;
    }

    public void setCredentials(Credentials credentials) {
        this.log.debug((Object)"Setting credentials..");
        credentials.prepareCredentials();
        String headerString = credentials.getHeaderString();
        this.log.debug((Object)("Header string = " + headerString));
        if (headerString != null) {
            this.log.debug((Object)"Inserting credentials string into the header");
            try {
                this.log.debug((Object)"Inserting the header in the message");
                this.stub.setHeader(Utils.generateSoapHeaderBinaryTokenElement(credentials.getAuthenticationType(), headerString));
                this.log.debug((Object)"Header added");
            }
            catch (SOAPException e) {
                this.log.error((Object)"Unable to generate token security header", (Throwable)e);
            }
        } else {
            this.log.debug((Object)"No headers to be inserted in the message");
        }
    }
}

