/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.integration;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.common.security.Credentials;
import org.gcube.soa3.connector.common.security.messages.MessageManager;

public class StubMessageManager
implements MessageManager {
    private Log log = LogFactory.getLog(this.getClass());
    private Stub stub;
    public static final String BINARY_SECURITY_TOKEN_LABEL = "BinarySecurityToken";
    public static final String BINARY_SECURITY_TOKEN_PREFIX = "wsse";
    public static final String WSSE_NAMESPACE = "http://schemas.xmlsoap.org/ws/2002/04/secext";
    public static final String VALUE_TYPE_LABEL = "ValueType";
    public static final String ENCODING_TYPE_LABEL = "EncodingType";
    public static final String BASE64 = "wsse:Base64Binary";
    public static final String ID_LABEL = "Id";
    public static final String SECURITY_TOKEN = "SecurityToken";

    public StubMessageManager(Stub stub) {
        this.stub = stub;
    }

    public void setCredentials(Credentials credentials) {
        System.out.println("Setting credentials..");
        credentials.prepareCredentials();
        String headerString = credentials.getHeaderString();
        System.out.println("Header string = " + headerString);
        if (headerString != null) {
            System.out.println("Inserting credentials string into the header");
            try {
                System.out.println("Inserting the header in the message");
                this.stub.setHeader(this.generateBinaryTokenElement(credentials.getAuthenticationType(), headerString));
                System.out.println("Header added");
            }
            catch (SOAPException e) {
                this.log.error((Object)"Unable to generate token security header", (Throwable)e);
            }
        } else {
            System.out.println("No headers to be inserted in the message");
        }
    }

    private SOAPHeaderElement generateBinaryTokenElement(String type, String binaryTokenValue) throws SOAPException {
        System.out.println("Generating token SOAP element");
        System.out.println("Type = " + type);
        System.out.println("Value = " + binaryTokenValue);
        SOAPHeaderElement headerElement = new SOAPHeaderElement(new QName(WSSE_NAMESPACE, "wsse:BinarySecurityToken"));
        headerElement.addAttribute(WSSE_NAMESPACE, VALUE_TYPE_LABEL, type);
        headerElement.addAttribute(WSSE_NAMESPACE, ENCODING_TYPE_LABEL, BASE64);
        headerElement.addAttribute(WSSE_NAMESPACE, ID_LABEL, SECURITY_TOKEN);
        headerElement.setValue(binaryTokenValue);
        System.out.println("Header completed");
        return headerElement;
    }
}

