/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.integration;

import java.io.File;
import java.io.FileReader;
import java.util.Map;
import java.util.Properties;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.security.GCUBESecurityController;
import org.gcube.common.core.security.GCUBEServiceAuthorizationController;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.security.soa3.configuration.ConfigurationManager;
import org.gcube.security.soa3.connector.SOA3SecurityController;

public class SOA3IntegrationSecurityController
implements GCUBEServiceAuthorizationController {
    private GCUBELog log = new GCUBELog((Object)this);
    private GCUBESecurityController controller = new SOA3SecurityController();
    private boolean isSecurityEnabled = false;
    public static final String SERVICE_PROPERTIES = "serviceSecurityProperties.props";

    public void initialise(GCUBEServiceContext ctxt, GCUBEServiceSecurityManager securityManager) throws Exception {
        String serviceName = ctxt.getName();
        Properties properties = null;
        this.log.debug((Object)("Service name " + serviceName));
        try {
            File servicePropertiesFile = ctxt.getFile(SERVICE_PROPERTIES, new boolean[]{false});
            this.log.debug((Object)("Service Property file = " + servicePropertiesFile));
            if (servicePropertiesFile != null && servicePropertiesFile.exists()) {
                properties = new Properties();
                properties.load(new FileReader(servicePropertiesFile));
            }
        }
        catch (Exception e) {
            this.log.debug((Object)"Unable to load local property file");
        }
        if (properties != null) {
            ConfigurationManager.getInstance().setServiceProperties(serviceName, properties);
        }
        this.log.debug((Object)"Initializing the controller");
        this.controller.init(ctxt);
        this.isSecurityEnabled = ConfigurationManager.getInstance().isSecurityEnabled(ctxt.getName());
        this.log.debug((Object)"Init completed");
    }

    public boolean isSecurityEnabled() {
        return this.isSecurityEnabled;
    }

    public void authoriseCall(Map<String, Object> parameters) throws GCUBEException {
        this.log.debug((Object)"Checking the privileges...");
        if (!this.controller.checkAccess(parameters)) {
            this.log.debug((Object)"Access not granted");
            throw new GCUBEUnrecoverableException("Security exception: the requirer is not authorized to perform the selected operation");
        }
        this.log.debug((Object)"Access granted");
    }
}

