/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.handlers;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.wssec.GSSConfig;
import org.w3c.dom.Element;

public class SecurityTokenHandler
extends GenericHandler {
    protected static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authorization.errors");
    private static Log log = LogFactory.getLog((String)SecurityTokenHandler.class.getName());

    public boolean handleRequest(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleResponse(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleMessage(SOAPMessageContext ctx) {
        Object obj = ctx.getProperty("SECURITY_TOKEN");
        if (obj == null) {
            log.debug((Object)"No token configured");
            return true;
        }
        log.debug((Object)"Token Object ");
        if (!(obj instanceof Element)) {
            log.warn((Object)"Property SECURITY_TOKEN does not have Security Token instance");
            return true;
        }
        Element token = (Element)obj;
        SOAPMessage msg = ctx.getMessage();
        if (msg == null) {
            log.debug((Object)"No message");
            return true;
        }
        String type = token.getAttribute("EncodingType");
        String binaryTokenValue = token.getAttribute("Id");
        log.debug((Object)("Token type = " + type));
        log.debug((Object)("Token value = " + binaryTokenValue));
        ctx.setProperty("axis.form.optimization", (Object)Boolean.TRUE);
        try {
            log.debug((Object)"Generating security token");
            SOAPElement tokenElement = this.generateBinaryTokenElement(type, binaryTokenValue);
            log.debug((Object)"Security token generated");
            msg.getSOAPHeader().addChildElement(tokenElement);
            msg.saveChanges();
            log.debug((Object)"Security token generated added to the message");
        }
        catch (Exception e) {
            log.error((Object)"Unable to add the security token to the message", (Throwable)e);
        }
        ctx.setMessage(msg);
        log.debug((Object)"Exit: SecurityTokenHandler");
        return true;
    }

    public QName[] getHeaders() {
        return null;
    }

    private SOAPElement generateBinaryTokenElement(String type, String binaryTokenValue) throws SOAPException {
        log.debug((Object)"Generating token SOAP element");
        log.debug((Object)("Type = " + type));
        log.debug((Object)("Value = " + binaryTokenValue));
        SOAPFactory sf = SOAPFactory.newInstance();
        SOAPElement tokenElement = sf.createElement(new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "wsse:BinarySecurityToken"));
        tokenElement.setAttribute("ValueType", type);
        tokenElement.setAttribute("EncodingType", "wsse:Base64Binary");
        tokenElement.setAttribute("Id", "SecurityToken");
        tokenElement.setValue(binaryTokenValue);
        log.debug((Object)"Header completed");
        return tokenElement;
    }

    static {
        GSSConfig.init();
    }
}

