/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.soa3.connector.common.security.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.common.security.Credentials;
import org.gcube.soa3.connector.common.security.impl.X509TLSCredentials;

public class X509CombinedCredentials
extends X509TLSCredentials {
    private Log log = LogFactory.getLog(this.getClass());
    private Credentials extraCredentials;

    public X509CombinedCredentials(Credentials extraCredentials) {
        this(extraCredentials, null, null, null, null);
    }

    public X509CombinedCredentials(Credentials extraCredentials, String certFile, String keyFile, String trustDir, String trustExt) {
        super(certFile, keyFile, trustDir, trustExt);
        this.extraCredentials = extraCredentials;
    }

    @Override
    public String getAuthenticationType() {
        if (this.extraCredentials != null) {
            return super.getAuthenticationType() + "-" + this.extraCredentials.getAuthenticationString();
        }
        return super.getAuthenticationType();
    }

    @Override
    public void prepareCredentials() {
        this.log.debug((Object)"Setting X509 certificate...");
        super.prepareCredentials();
        this.log.debug((Object)"Certificates loaded");
        if (this.extraCredentials != null) {
            this.log.debug((Object)"Generating string based credentials...");
            this.extraCredentials.prepareCredentials();
            this.log.debug((Object)"String based credentials generated");
        }
    }

    @Override
    public String getAuthenticationString() {
        if (this.extraCredentials != null) {
            return this.extraCredentials.getAuthenticationString();
        }
        return super.getAuthenticationString();
    }

    @Override
    public String getHeaderString() {
        if (this.extraCredentials != null) {
            return this.extraCredentials.getHeaderString();
        }
        return null;
    }
}

