package org.gcube.soa3.connector.common.security.messages.impl;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.common.security.Credentials;
import org.gcube.soa3.connector.common.security.messages.MessageManager;

import com.sun.jersey.api.client.WebResource;

/**
 * 
 * Specification of {@link MessageManager} class for REST messages
 * 
 * @author Ciro Formisano (ENG)
 *
 */
public class RestMessageManager implements MessageManager {

	private Log log;
	private WebResource resource;
	private String AUTHORIZATION_HEADER = "Authorization";
	
	public RestMessageManager (WebResource resource)
	{
		this.log = LogFactory.getLog(this.getClass());
		this.resource = resource;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setCredentials(Credentials credentials) 
	{
		log.debug("Setting credentials..");
		credentials.prepareCredentials();
		String headerString = credentials.getHeaderString();
		log.debug("Header string = "+headerString);
		
		if (headerString!= null)
		{
			log.debug("Inserting the header in the message");
			resource.header(AUTHORIZATION_HEADER, headerString);
			log.debug("Header added");
		}
		else
		{
			log.debug("No headers to be inserted in the message");
		}
		
		log.debug("Operation completed");

	}

}
